/*
 * Decompiled with CFR 0.152.
 */
package com.kiuwan.plugins.kiuwanJenkinsPlugin.runnable;

import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanBuildSummaryAction;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanConnectionProfile;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanGlobalConfigDescriptor;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanRecorder;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.filecallable.KiuwanRemoteEnvironment;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.Measure;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.Mode;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.results.AnalysisResult;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.util.KiuwanAnalyzerCommandBuilder;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.util.KiuwanAnalyzerInstaller;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.util.KiuwanUtils;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

public class KiuwanRunnable
implements Runnable {
    private static final int KLA_RETURN_CODE_AUDIT_FAILED = 10;
    private static final String JAVA_HOME_ENV_VAR = "JAVA_HOME";
    private KiuwanRecorder recorder;
    private FilePath workspace;
    private KiuwanConnectionProfile connectionProfile;
    private Node node;
    private Run<?, ?> run;
    private Launcher launcher;
    private TaskListener listener;
    private AtomicReference<Throwable> exceptionReference;
    private AtomicReference<Result> resultReference;
    private KiuwanAnalyzerCommandBuilder commandBuilder;
    private PrintStream loggerPrintStream;

    public KiuwanRunnable(KiuwanRecorder recorder, FilePath workspace, KiuwanConnectionProfile connectionProfile, KiuwanGlobalConfigDescriptor descriptor, Node node, Run<?, ?> run, Launcher launcher, TaskListener listener, AtomicReference<Throwable> exceptionReference, AtomicReference<Result> resultReference) {
        this.recorder = recorder;
        this.workspace = workspace;
        this.connectionProfile = connectionProfile;
        this.node = node;
        this.run = run;
        this.launcher = launcher;
        this.listener = listener;
        this.exceptionReference = exceptionReference;
        this.resultReference = resultReference;
        this.commandBuilder = new KiuwanAnalyzerCommandBuilder(recorder, workspace, connectionProfile, descriptor, run, launcher, listener);
        this.loggerPrintStream = listener.getLogger();
    }

    @Override
    public void run() {
        try {
            if (this.connectionProfile == null) {
                String uuid = this.recorder.getConnectionProfileUuid();
                if (StringUtils.isEmpty((String)uuid)) {
                    this.loggerPrintStream.println("A connection profile has not been set. Please set a connection profile before analyzing.");
                } else {
                    this.loggerPrintStream.print("Could not find the specified connection profile (" + uuid + "). Verify your ");
                    this.listener.hyperlink("/configure", "Kiuwan Global Settings");
                    this.loggerPrintStream.println(".");
                }
                this.resultReference.set(Result.NOT_BUILT);
            } else {
                this.performAnalysis();
            }
        }
        catch (IOException e) {
            this.loggerPrintStream.println(e.toString());
            this.exceptionReference.set(e);
            this.resultReference.set(Result.NOT_BUILT);
        }
        catch (InterruptedException e) {
            this.loggerPrintStream.println("Analysis interrupted.");
            this.exceptionReference.set(e);
            this.resultReference.set(Result.ABORTED);
        }
        catch (Throwable throwable) {
            this.loggerPrintStream.println(ExceptionUtils.getFullStackTrace((Throwable)throwable));
            this.resultReference.set(Result.NOT_BUILT);
        }
    }

    private void performAnalysis() throws IOException, InterruptedException {
        FilePath localAnalyzerHome = this.installLocalAnalyzer();
        EnvVars envVars = this.buildEnvVars();
        this.printExecutionConfiguration(localAnalyzerHome);
        List<String> args = this.commandBuilder.buildLocalAnalyzerCommand(localAnalyzerHome, envVars);
        this.initAnalysisResults();
        int klaReturnCode = this.runKiuwanLocalAnalyzer(args, envVars, localAnalyzerHome);
        AnalysisResult analysisResult = this.loadAnalysisResults();
        if (klaReturnCode == 0 && analysisResult == null) {
            this.loggerPrintStream.println("Kiuwan Local Analyzer returned a success status code but the plugin could not read the analysis results file and check the remote status of the analysis");
            this.resultReference.set(Result.NOT_BUILT);
        } else {
            if (Mode.STANDARD_MODE.getValue().equals(this.recorder.getSelectedMode())) {
                this.onAnalysisFinishedStandardMode(klaReturnCode, analysisResult);
            } else if (Mode.DELIVERY_MODE.getValue().equals(this.recorder.getSelectedMode())) {
                this.onAnalysisFinishedDeliveryMode(klaReturnCode);
            } else if (Mode.EXPERT_MODE.getValue().equals(this.recorder.getSelectedMode())) {
                this.onAnalysisFinishedExpertMode(klaReturnCode);
            }
            KiuwanBuildSummaryAction resultsSummaryAction = new KiuwanBuildSummaryAction(analysisResult);
            this.run.addAction((Action)resultsSummaryAction);
        }
    }

    private FilePath installLocalAnalyzer() throws IOException, InterruptedException {
        FilePath nodeJenkinsDir = KiuwanUtils.getNodeJenkinsDirectory(this.node, this.workspace);
        FilePath agentHome = KiuwanAnalyzerInstaller.installKiuwanLocalAnalyzer(nodeJenkinsDir, this.listener, this.connectionProfile);
        return agentHome;
    }

    private EnvVars buildEnvVars() throws IOException, InterruptedException {
        EnvVars remoteEnv;
        EnvVars environment = this.run.getEnvironment(this.listener);
        EnvVars envVars = new EnvVars(environment);
        if (this.run instanceof AbstractBuild) {
            AbstractBuild build = (AbstractBuild)this.run;
            Map buildVariables = build.getBuildVariables();
            envVars.putAll(buildVariables);
        }
        if (!(remoteEnv = (EnvVars)this.workspace.act((FilePath.FileCallable)new KiuwanRemoteEnvironment())).containsKey((Object)JAVA_HOME_ENV_VAR)) {
            envVars.remove((Object)JAVA_HOME_ENV_VAR);
        }
        envVars.putAll((Map)remoteEnv);
        return envVars;
    }

    private void printExecutionConfiguration(FilePath agentHome) throws IOException, InterruptedException {
        FilePath script = KiuwanAnalyzerCommandBuilder.getLocalAnalyzerCommandFilePath(this.launcher, agentHome);
        this.loggerPrintStream.println("Script: " + KiuwanUtils.getRemoteFileAbsolutePath(script, this.listener));
        this.loggerPrintStream.println("Connection profile: " + this.connectionProfile.getDisplayName());
        if (Mode.STANDARD_MODE.getValue().equals(this.recorder.getSelectedMode())) {
            this.loggerPrintStream.println("Threshold measure: " + this.recorder.getMeasure());
            if (!Measure.NONE.getValue().equals(this.recorder.getMeasure())) {
                this.loggerPrintStream.println("Unstable threshold: " + this.recorder.getUnstableThreshold());
                this.loggerPrintStream.println("Failure threshold: " + this.recorder.getFailureThreshold());
            }
        }
    }

    private int runKiuwanLocalAnalyzer(List<String> args, EnvVars envVars, FilePath localAnalyzerHome) throws IOException, InterruptedException {
        FilePath localAnalyzerBinDir = KiuwanAnalyzerCommandBuilder.getAgentBinDir(localAnalyzerHome);
        boolean[] masks = KiuwanAnalyzerCommandBuilder.getMasks(args);
        Launcher.ProcStarter procStarter = this.launcher.launch().cmds(args).masks(masks).envs((Map)envVars).pwd(localAnalyzerBinDir).stdout(this.listener);
        Proc process = procStarter.start();
        int klaReturnCode = process.join();
        this.loggerPrintStream.println("Result code: " + klaReturnCode);
        return klaReturnCode;
    }

    private void initAnalysisResults() {
        try {
            FilePath outputReportFilePath = new FilePath(this.workspace, this.recorder.getOutputFilename());
            if (outputReportFilePath != null && outputReportFilePath.exists()) {
                outputReportFilePath.delete();
                this.loggerPrintStream.println("Previous analysis results deleted: " + outputReportFilePath);
            }
        }
        catch (IOException | InterruptedException e) {
            this.loggerPrintStream.println("Could not delete previous analysis results: " + e);
        }
    }

    private AnalysisResult loadAnalysisResults() {
        AnalysisResult analysisResults;
        block15: {
            analysisResults = null;
            try {
                FilePath outputReportFilePath = new FilePath(this.workspace, this.recorder.getOutputFilename());
                if (outputReportFilePath != null && outputReportFilePath.exists()) {
                    try (InputStream is = outputReportFilePath.read();){
                        analysisResults = KiuwanUtils.readAnalysisResult(is);
                        break block15;
                    }
                }
                this.loggerPrintStream.println("Analysis results file not found: " + outputReportFilePath);
            }
            catch (IOException | InterruptedException e) {
                this.loggerPrintStream.println("Could not read analysis results: " + e);
            }
        }
        return analysisResults;
    }

    private void onAnalysisFinishedStandardMode(int klaReturnCode, AnalysisResult analysisResult) {
        if (klaReturnCode != 0) {
            this.loggerPrintStream.println("Kiuwan Local Analyzer has returned a failure status.");
            this.resultReference.set(Result.NOT_BUILT);
        } else if (!Measure.NONE.getValue().equals(this.recorder.getMeasure())) {
            if ("FINISHED".equalsIgnoreCase(analysisResult.getAnalysisStatus())) {
                Double qualityIndicator = null;
                if (analysisResult.getQualityIndicator() != null) {
                    qualityIndicator = KiuwanUtils.roundDouble(analysisResult.getQualityIndicator().getValue());
                }
                Double effortToTarget = null;
                if (analysisResult.getEffortToTarget() != null) {
                    effortToTarget = KiuwanUtils.roundDouble(analysisResult.getEffortToTarget().getValue());
                }
                Double riskIndex = null;
                if (analysisResult.getRiskIndex() != null) {
                    riskIndex = KiuwanUtils.roundDouble(analysisResult.getRiskIndex().getValue());
                }
                this.printStandardModeConsoleSummary(qualityIndicator, effortToTarget, riskIndex);
                this.checkThresholds(qualityIndicator, effortToTarget, riskIndex);
            } else {
                this.loggerPrintStream.println("Build failed in Kiuwan");
                this.resultReference.set(Result.NOT_BUILT);
            }
        }
    }

    private void onAnalysisFinishedDeliveryMode(int klaReturnCode) {
        if (this.recorder.getWaitForAuditResults_dm().booleanValue() && klaReturnCode == 10) {
            String markBuildWhenNoPass = this.recorder.getMarkBuildWhenNoPass_dm();
            this.loggerPrintStream.println("Audit not passed. Marking build as " + markBuildWhenNoPass);
            this.resultReference.set(Result.fromString((String)markBuildWhenNoPass));
        } else if (klaReturnCode != 0) {
            this.loggerPrintStream.println("Kiuwan Local Analyzer has returned a failure status.");
            this.resultReference.set(Result.NOT_BUILT);
        }
    }

    private void onAnalysisFinishedExpertMode(int klaReturnCode) {
        Set<Integer> successCodes = KiuwanUtils.parseErrorCodes(this.recorder.getSuccessResultCodes_em());
        Set<Integer> failureCodes = KiuwanUtils.parseErrorCodes(this.recorder.getFailureResultCodes_em());
        Set<Integer> unstableCodes = KiuwanUtils.parseErrorCodes(this.recorder.getUnstableResultCodes_em());
        Set<Integer> abortedCodes = KiuwanUtils.parseErrorCodes(this.recorder.getAbortedResultCodes_em());
        Set<Integer> notBuiltCodes = KiuwanUtils.parseErrorCodes(this.recorder.getNotBuiltResultCodes_em());
        if (!successCodes.contains(klaReturnCode)) {
            if (failureCodes.contains(klaReturnCode)) {
                this.resultReference.set(Result.FAILURE);
            } else if (unstableCodes.contains(klaReturnCode)) {
                this.resultReference.set(Result.UNSTABLE);
            } else if (abortedCodes.contains(klaReturnCode)) {
                this.resultReference.set(Result.ABORTED);
            } else if (notBuiltCodes.contains(klaReturnCode)) {
                this.resultReference.set(Result.NOT_BUILT);
            } else {
                String markAsInOtherCases = this.recorder.getMarkAsInOtherCases_em();
                this.loggerPrintStream.println("Kiuwan Local Analyzer has returned an exit code that does not match any of the configured exit codes: " + klaReturnCode + ". Marking build as " + markAsInOtherCases + ".");
                this.resultReference.set(Result.fromString((String)markAsInOtherCases));
            }
        }
    }

    private void printStandardModeConsoleSummary(Double qualityIndicator, Double effortToTarget, Double riskIndex) {
        this.loggerPrintStream.println("==========================================================================");
        this.loggerPrintStream.println("                    Kiuwan Static Analysis Summary                        ");
        this.loggerPrintStream.println("==========================================================================");
        this.loggerPrintStream.println(" - Global indicator: " + (qualityIndicator != null ? qualityIndicator : "unknown"));
        this.loggerPrintStream.println(" - Effort to target: " + (effortToTarget != null ? effortToTarget : "unknown"));
        this.loggerPrintStream.println(" - Risk index: " + (riskIndex != null ? riskIndex : "unknown"));
    }

    private void checkThresholds(Double qualityIndicator, Double effortToTarget, Double riskIndex) {
        String measure = this.recorder.getMeasure();
        if (Measure.QUALITY_INDICATOR.getValue().equals(measure)) {
            if (qualityIndicator == null) {
                this.loggerPrintStream.println("Global indicator value is unknown, cannot check configured value");
            } else if (qualityIndicator < this.recorder.getFailureThreshold()) {
                this.resultReference.set(Result.FAILURE);
                this.loggerPrintStream.println("Global indicator is lower than " + this.recorder.getFailureThreshold());
            } else if (qualityIndicator < this.recorder.getUnstableThreshold()) {
                this.resultReference.set(Result.UNSTABLE);
                this.loggerPrintStream.println("Global indicator is lower than " + this.recorder.getUnstableThreshold());
            }
        } else if (Measure.EFFORT_TO_TARGET.getValue().equals(measure)) {
            if (effortToTarget == null) {
                this.loggerPrintStream.println("Effort to target value is unknown, cannot check configured value");
            } else if (effortToTarget > this.recorder.getFailureThreshold()) {
                this.resultReference.set(Result.FAILURE);
                this.loggerPrintStream.println("Effort to target is greater than " + this.recorder.getFailureThreshold());
            } else if (effortToTarget > this.recorder.getUnstableThreshold()) {
                this.resultReference.set(Result.UNSTABLE);
                this.loggerPrintStream.println("Effort to target is greater than " + this.recorder.getUnstableThreshold());
            }
        } else if (Measure.RISK_INDEX.getValue().equals(measure)) {
            if (riskIndex == null) {
                this.loggerPrintStream.println("Risk index value is unknown, cannot check configured value");
            } else if (riskIndex > this.recorder.getFailureThreshold()) {
                this.resultReference.set(Result.FAILURE);
                this.loggerPrintStream.println("Risk index is greater than " + this.recorder.getFailureThreshold());
            } else if (riskIndex > this.recorder.getUnstableThreshold()) {
                this.resultReference.set(Result.UNSTABLE);
                this.loggerPrintStream.println("Risk index is greater than " + this.recorder.getUnstableThreshold());
            }
        }
    }
}

