/*
 * Decompiled with CFR 0.152.
 */
package com.kiuwan.plugins.kiuwanJenkinsPlugin.model;

import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.ProxyAuthentication;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.ProxyProtocol;
import java.net.Proxy;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class ProxyConfig {
    public static final int PORT_DEFAULT = 3128;
    public static final ProxyConfig EMPTY = new ProxyConfig("", 3128, ProxyProtocol.HTTP, ProxyAuthentication.NONE, "", "");
    private String host;
    private int port;
    private ProxyProtocol protocol;
    private ProxyAuthentication authentication;
    private String username;
    private String password;

    public ProxyConfig(String host, int port, String protocolStr, String authenticationStr, String username, String password) {
        this(host, port, ProxyConfig.parseProtocol(protocolStr), ProxyConfig.parseAuthentication(authenticationStr), username, password);
    }

    public ProxyConfig(String host, int port, ProxyProtocol protocol, ProxyAuthentication authentication, String username, String password) {
        this.host = host;
        this.port = port;
        this.protocol = protocol;
        this.authentication = authentication;
        this.username = username;
        this.password = password;
    }

    public Proxy.Type getJavaProxyType() {
        Proxy.Type proxyType = null;
        if (ProxyProtocol.HTTP.equals(this.protocol)) {
            proxyType = Proxy.Type.HTTP;
        } else if (ProxyProtocol.SOCKS.equals(this.protocol)) {
            proxyType = Proxy.Type.SOCKS;
        }
        return proxyType;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public ProxyProtocol getProtocol() {
        return this.protocol;
    }

    public ProxyAuthentication getAuthentication() {
        return this.authentication;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getLocalAnalyzerProtocolOption() {
        String localAnalyzerProtocol = null;
        localAnalyzerProtocol = ProxyProtocol.HTTP.equals(this.protocol) ? "http" : (ProxyProtocol.SOCKS.equals(this.protocol) ? "socks" : "");
        return localAnalyzerProtocol;
    }

    public String getLocalAnalyzerAuthenticationOption() {
        String localAnalyzerAuthentication = null;
        localAnalyzerAuthentication = ProxyAuthentication.NONE.equals(this.authentication) ? "None" : (ProxyAuthentication.BASIC.equals(this.authentication) ? "Basic" : "");
        return localAnalyzerAuthentication;
    }

    private static ProxyProtocol parseProtocol(String protocolStr) {
        ProxyProtocol protocol = null;
        if (StringUtils.isNotEmpty((String)protocolStr)) {
            protocol = ProxyProtocol.valueOf(protocolStr.toUpperCase(Locale.ENGLISH));
        }
        return protocol;
    }

    private static ProxyAuthentication parseAuthentication(String authenticationStr) {
        ProxyAuthentication authentication = null;
        if (StringUtils.isNotEmpty((String)authenticationStr)) {
            authentication = ProxyAuthentication.valueOf(authenticationStr.toUpperCase(Locale.ENGLISH));
        }
        return authentication;
    }
}

