/*
 * Decompiled with CFR 0.152.
 */
package com.kiuwan.plugins.kiuwanJenkinsPlugin.client;

import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.ProxyAuthentication;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.ProxyConfig;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.util.KiuwanUtils;
import com.kiuwan.rest.client.ApiClient;
import com.kiuwan.rest.client.Configuration;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;

public class KiuwanClientUtils {
    public static ApiClient instantiateClient(boolean isConfigureKiuwanURL, String kiuwanURL, String username, String password, String domain) {
        ProxyConfig proxyConfig;
        if (isConfigureKiuwanURL) {
            try {
                new URL(kiuwanURL);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Cannot instantiate client - Kiuwan server URL is not valid (" + e.getLocalizedMessage() + ")", e);
            }
        }
        ApiClient apiClient = Configuration.newClient((boolean)isConfigureKiuwanURL, (String)kiuwanURL).withBasicAuthentication(username, password).withDomain(domain);
        URL basePathURL = null;
        try {
            basePathURL = new URL(apiClient.getBasePath());
        }
        catch (MalformedURLException e) {
            KiuwanUtils.logger().log(Level.WARNING, "Could not create URL to setup proxy: " + e.getLocalizedMessage());
        }
        if (basePathURL != null && (proxyConfig = KiuwanUtils.getJenkinsProxy(basePathURL.getHost())) != null) {
            apiClient = ProxyAuthentication.NONE.equals(proxyConfig.getAuthentication()) ? apiClient.withProxy(proxyConfig.getJavaProxyType().name(), proxyConfig.getHost(), proxyConfig.getPort()) : apiClient.withProxy(proxyConfig.getJavaProxyType().name(), proxyConfig.getHost(), proxyConfig.getPort(), proxyConfig.getUsername(), proxyConfig.getPassword());
        }
        return apiClient;
    }
}

