/*
 * Decompiled with CFR 0.152.
 */
package com.kiuwan.plugins.kiuwanJenkinsPlugin.client;

import com.google.gson.JsonSyntaxException;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.client.KiuwanClientErrorResponse;
import com.kiuwan.rest.client.ApiException;
import com.kiuwan.rest.client.JSON;

public class KiuwanClientException
extends Exception {
    private static final long serialVersionUID = -4940952505703754667L;
    private KiuwanClientErrorResponse errorResponse;

    public KiuwanClientException(String message) {
        super(message);
    }

    public KiuwanClientException(ApiException cause) {
        super((Throwable)cause);
    }

    public KiuwanClientException(String message, ApiException cause) {
        super(message, (Throwable)cause);
    }

    public KiuwanClientException(KiuwanClientErrorResponse errorResponse, ApiException cause) {
        super(errorResponse.toString(), (Throwable)cause);
        this.errorResponse = errorResponse;
    }

    public synchronized ApiException getCause() {
        return (ApiException)super.getCause();
    }

    public KiuwanClientErrorResponse getErrorResponse() {
        return this.errorResponse;
    }

    public static KiuwanClientException from(ApiException e) {
        if (e.getCode() == 401 || e.getCode() == 419) {
            return new KiuwanClientException(e.getCode() + " - Unauthorized");
        }
        if (e.getResponseBody() == null) {
            return new KiuwanClientException(e);
        }
        KiuwanClientErrorResponse errorResponse = null;
        try {
            errorResponse = (KiuwanClientErrorResponse)JSON.createGson().create().fromJson(e.getResponseBody(), KiuwanClientErrorResponse.class);
        }
        catch (JsonSyntaxException jse) {
            if (e.getCode() == 404) {
                return new KiuwanClientException(e.getCode() + " - A server responded but Kiuwan is not available in the specified URL", e);
            }
            if (e.getCode() == 407) {
                return new KiuwanClientException(e.getCode() + " - Proxy authentication required", e);
            }
            return new KiuwanClientException("Cannot deserialize error response", e);
        }
        return new KiuwanClientException(errorResponse, e);
    }
}

