/*
 * Decompiled with CFR 0.152.
 */
package com.kiuwan.plugins.kiuwanJenkinsPlugin;

import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanConnectionProfile;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanGlobalConfigDescriptor;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanRecorder;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.ChangeRequestStatusType;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.DeliveryType;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.KiuwanModelObject;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.Measure;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.Mode;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.SelectableResult;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.util.KiuwanUtils;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.QueryParameter;

@Symbol(value={"kiuwan"})
@Extension
public class KiuwanRecorderDescriptor
extends BuildStepDescriptor<Publisher> {
    public static final String DEFAULT_SOURCE_PATH = "";
    public static final String DEFAULT_OUTPUT_FILENAME = "kiuwan/output.json";
    public static final String DEFAULT_MODE = Mode.STANDARD_MODE.getValue();
    public static final String DEFAULT_APPLICATION_NAME = "${JOB_NAME}";
    public static final String DEFAULT_LABEL = "#${BUILD_NUMBER}";
    public static final String DEFAULT_ANALYSIS_SCOPE = DeliveryType.COMPLETE_DELIVERY.getValue();
    public static final String DEFAULT_CHANGE_REQUEST = "";
    public static final String DEFAULT_BRANCH = "";
    public static final String DEFAULT_CHANGE_REQUEST_STATUS = ChangeRequestStatusType.RESOLVED.getValue();
    public static final String DEFAULT_MEASURE = Measure.QUALITY_INDICATOR.getValue();
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String DEFAULT_INCLUDES = "";
    public static final String DEFAULT_EXCLUDES = "**/src/test/**,**/__MACOSX/**,**/*.min.js,**/*.Designer.vb,**/*.designer.vb,**/*Reference.vb,**/*Service.vb,**/*Silverlight.vb,**/*.Designer.cs,**/*.designer.cs,**/*Reference.cs,**/*Service.cs,**/*Silverlight.cs,**/.*,**/Pods/BuildHeaders/**/*.h,**/Pods/Headers/**/*.h,**/node_modules/**,**/bower_components/**,**/target/**,**/bin/**,**/obj/**,**/dist/**,**/lib/**";
    public static final Integer DEFAULT_TIMEOUT = 60;
    public static final Boolean DEFAULT_INDICATE_LANGUAGES = false;
    public static final Boolean DEFAULT_WAIT_FOR_AUDIT_RESULTS = false;
    public static final String DEFAULT_LANGUAGES = "abap,actionscript,aspnet,c,cobol,cpp,csharp,go,groovy,html,informix,java,javascript,jcl,jsp,kotlin,natural,objectivec,oracleforms,other,perl,php,plsql,powerscript,python,rpg4,ruby,scala,sqlscript,swift,transactsql,vb6,vbnet,xml";
    public static final String DEFAULT_MARK_BUILD_WHEN_NO_PASS = "UNSTABLE";
    public static final String DEFAULT_COMMAND_ARGS = "-c -n \"${JOB_NAME}\" -l \"#${BUILD_NUMBER}\"";
    public static final String DEFAULT_EXTRA_PARAMETERS = "encoding=\"UTF-8\" supported.technologies=\"abap,actionscript,aspnet,c,cobol,cpp,csharp,go,groovy,html,informix,java,javascript,jcl,jsp,kotlin,natural,objectivec,oracleforms,other,perl,php,plsql,powerscript,python,rpg4,ruby,scala,sqlscript,swift,transactsql,vb6,vbnet,xml\" exclude.patterns=\"**/src/test/**,**/__MACOSX/**,**/*.min.js,**/*.Designer.vb,**/*.designer.vb,**/*Reference.vb,**/*Service.vb,**/*Silverlight.vb,**/*.Designer.cs,**/*.designer.cs,**/*Reference.cs,**/*Service.cs,**/*Silverlight.cs,**/.*,**/Pods/BuildHeaders/**/*.h,**/Pods/Headers/**/*.h,**/node_modules/**,**/bower_components/**,**/target/**,**/bin/**,**/obj/**,**/dist/**,**/lib/**\"";
    public static final String DEFAULT_SUCCESS_RESULT_CODES = "0";
    public static final String DEFAULT_UNSTABLE_RESULT_CODES = "10, 13";
    public static final String DEFAULT_FAILURE_RESULT_CODES = "1, 11, 12, 14";
    public static final String DEFAULT_NOT_BUILT_RESULT_CODES = "";
    public static final String DEFAULT_ABORTED_RESULT_CODES = "";
    public static final String DEFAULT_MARK_AS_IN_OTHER_CASES_RESULT_CODES = "FAILURE";

    public KiuwanRecorderDescriptor() {
        super(KiuwanRecorder.class);
    }

    public boolean isApplicable(Class<? extends AbstractProject> item) {
        return true;
    }

    public String getDisplayName() {
        return "Analyze your source code with Kiuwan!";
    }

    public boolean isConnectionProfilesConfigured() {
        KiuwanGlobalConfigDescriptor descriptor = KiuwanGlobalConfigDescriptor.get();
        List<KiuwanConnectionProfile> connectionProfiles = descriptor.getConnectionProfiles();
        return connectionProfiles != null && !connectionProfiles.isEmpty();
    }

    public Mode getBaselineMode() {
        return Mode.STANDARD_MODE;
    }

    public Mode getDeliveryMode() {
        return Mode.DELIVERY_MODE;
    }

    public Mode getExpertMode() {
        return Mode.EXPERT_MODE;
    }

    public ListBoxModel doFillConnectionProfileUuidItems(@QueryParameter(value="connectionProfileUuid") String connectionProfileUuid) {
        List<KiuwanConnectionProfile> connectionProfiles;
        KiuwanModelObject[] data;
        boolean found;
        ListBoxModel items = new ListBoxModel();
        items.add("", "");
        KiuwanGlobalConfigDescriptor descriptor = KiuwanGlobalConfigDescriptor.get();
        if (descriptor.getConnectionProfiles() != null && !(found = KiuwanUtils.addAllOptionsToListBoxModel(items, data = (connectionProfiles = descriptor.getConnectionProfiles()).toArray(new KiuwanConnectionProfile[connectionProfiles.size()]), connectionProfileUuid)) && StringUtils.isNotEmpty((String)connectionProfileUuid)) {
            String displayName = "[UNKNOWN PROFILE] (" + connectionProfileUuid + ")";
            items.add((Object)new ListBoxModel.Option(displayName, connectionProfileUuid, true));
        }
        return items;
    }

    public ListBoxModel doFillMeasureItems(@QueryParameter(value="measure") String measure) {
        return KiuwanUtils.createListBoxModel(Measure.values(), measure);
    }

    public ListBoxModel doFillAnalysisScope_dmItems(@QueryParameter(value="analysisScope_dm") String deliveryType) {
        return KiuwanUtils.createListBoxModel(DeliveryType.values(), deliveryType);
    }

    public ListBoxModel doFillChangeRequestStatus_dmItems(@QueryParameter(value="changeRequestStatus_dm") String changeRequestStatus) {
        return KiuwanUtils.createListBoxModel(ChangeRequestStatusType.values(), changeRequestStatus);
    }

    public ListBoxModel doFillMarkBuildWhenNoPass_dmItems(@QueryParameter(value="markBuildWhenNoPass_dm") String markBuildWhenNoPass) {
        return KiuwanUtils.createListBoxModel(SelectableResult.values(), markBuildWhenNoPass);
    }

    public ListBoxModel doFillMarkAsInOtherCases_emItems(@QueryParameter(value="markAsInOtherCases_em") String markAsInOtherCases) {
        return KiuwanUtils.createListBoxModel(SelectableResult.values(), markAsInOtherCases);
    }

    public FormValidation doCheckConnectionProfileUuid(@QueryParameter(value="connectionProfileUuid") String connectionProfileUuid) {
        if (StringUtils.isEmpty((String)connectionProfileUuid)) {
            return FormValidation.error((String)"This field is required.");
        }
        KiuwanConnectionProfile connectionProfile = KiuwanGlobalConfigDescriptor.get().getConnectionProfile(connectionProfileUuid);
        if (connectionProfile == null) {
            return FormValidation.errorWithMarkup((String)("Selected connection profile does not exist anymore or is not correctly set up. Please, check your connection profiles in <a href=\"" + Jenkins.getInstance().getRootUrl() + "configure\" target=\"_blank\">Kiuwan Global Settings</a> or select a substitute from the list."));
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckTimeout(@QueryParameter(value="timeout") int timeout) {
        if (timeout < 1) {
            return FormValidation.error((String)"Timeout must be a number greater than 0.");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckTimeout_dm(@QueryParameter(value="timeout_dm") int timeout) {
        return this.doCheckTimeout(timeout);
    }

    public FormValidation doCheckTimeout_em(@QueryParameter(value="timeout_em") int timeout) {
        return this.doCheckTimeout(timeout);
    }

    public FormValidation doCheckThresholds(@QueryParameter(value="unstableThreshold") String unstableThreshold, @QueryParameter(value="failureThreshold") String failureThreshold, @QueryParameter(value="measure") String measure) {
        FormValidation unstableThresholdValidationResult = this.doCheckUnstableThreshold(unstableThreshold, failureThreshold, measure);
        if (FormValidation.Kind.OK.equals((Object)unstableThresholdValidationResult.kind)) {
            return this.doCheckFailureThreshold(failureThreshold, unstableThreshold, measure);
        }
        return unstableThresholdValidationResult;
    }

    public FormValidation doCheckUnstableThreshold(@QueryParameter(value="unstableThreshold") String unstableThreshold, @QueryParameter(value="failureThreshold") String failureThreshold, @QueryParameter(value="measure") String measure) {
        Double unstable = KiuwanUtils.parseDouble(unstableThreshold);
        Double failure = KiuwanUtils.parseDouble(failureThreshold);
        if (unstable == null) {
            return FormValidation.error((String)"Unstable threshold must be a non-negative numeric value.");
        }
        if (unstable < 0.0) {
            return FormValidation.error((String)"Unstable threshold must be a positive number.");
        }
        if (Measure.QUALITY_INDICATOR.getValue().equals(measure)) {
            if (unstable >= 100.0) {
                return FormValidation.error((String)"Unstable threshold must be lower than 100.");
            }
            if (failure != null && failure >= unstable) {
                return FormValidation.error((String)"Unstable threshold can not be lower or equal than failure threshold.");
            }
        } else if (Measure.RISK_INDEX.getValue().equals(measure)) {
            if (unstable <= 0.0) {
                return FormValidation.error((String)"Unstable threshold must be greater than 0.");
            }
            if (failure != null && failure <= unstable) {
                return FormValidation.error((String)"Unstable threshold can not be greater or equal than failure threshold.");
            }
        } else if (Measure.EFFORT_TO_TARGET.getValue().equals(measure) && failure != null && failure <= unstable) {
            return FormValidation.error((String)"Unstable threshold can not be greater or equal than failure threshold.");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckFailureThreshold(@QueryParameter(value="failureThreshold") String failureThreshold, @QueryParameter(value="unstableThreshold") String unstableThreshold, @QueryParameter(value="measure") String measure) {
        Double unstable = KiuwanUtils.parseDouble(unstableThreshold);
        Double failure = KiuwanUtils.parseDouble(failureThreshold);
        if (failure == null) {
            return FormValidation.error((String)"Failure threshold must be a non-negative numeric value.");
        }
        if (failure < 0.0) {
            return FormValidation.error((String)"Failure threshold must be a positive number.");
        }
        if (Measure.QUALITY_INDICATOR.getValue().equals(measure)) {
            if (unstable != null && failure >= unstable) {
                return FormValidation.error((String)"Failure threshold can not be greater or equal than unstable threshold.");
            }
        } else if (Measure.RISK_INDEX.getValue().equals(measure)) {
            if (failure > 100.0) {
                return FormValidation.error((String)"Failure threshold must be lower or equal than 100.");
            }
            if (unstable != null && failure <= unstable) {
                return FormValidation.error((String)"Failure threshold can not be lower or equal than unstable threshold.");
            }
        } else if (Measure.EFFORT_TO_TARGET.getValue().equals(measure) && unstable != null && failure <= unstable) {
            return FormValidation.error((String)"Failure threshold can not be lower or equal than unstable threshold.");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckSuccessResultCodes_em(@QueryParameter(value="successResultCodes_em") String successResultCodes, @QueryParameter(value="unstableResultCodes_em") String unstableResultCodes, @QueryParameter(value="failureResultCodes_em") String failureResultCodes, @QueryParameter(value="notBuiltResultCodes_em") String notBuiltResultCodes, @QueryParameter(value="abortedResultCodes_em") String abortedResultCodes) {
        return this.validateResultCodes(successResultCodes, new String[]{unstableResultCodes, failureResultCodes, notBuiltResultCodes, abortedResultCodes});
    }

    public FormValidation doCheckUnstableResultCodes_em(@QueryParameter(value="successResultCodes_em") String successResultCodes, @QueryParameter(value="unstableResultCodes_em") String unstableResultCodes, @QueryParameter(value="failureResultCodes_em") String failureResultCodes, @QueryParameter(value="notBuiltResultCodes_em") String notBuiltResultCodes, @QueryParameter(value="abortedResultCodes_em") String abortedResultCodes) {
        return this.validateResultCodes(unstableResultCodes, new String[]{successResultCodes, failureResultCodes, notBuiltResultCodes, abortedResultCodes});
    }

    public FormValidation doCheckFailureResultCodes_em(@QueryParameter(value="successResultCodes_em") String successResultCodes, @QueryParameter(value="unstableResultCodes_em") String unstableResultCodes, @QueryParameter(value="failureResultCodes_em") String failureResultCodes, @QueryParameter(value="notBuiltResultCodes_em") String notBuiltResultCodes, @QueryParameter(value="abortedResultCodes_em") String abortedResultCodes) {
        return this.validateResultCodes(failureResultCodes, new String[]{successResultCodes, unstableResultCodes, notBuiltResultCodes, abortedResultCodes});
    }

    public FormValidation doCheckNotBuiltResultCodes_em(@QueryParameter(value="successResultCodes_em") String successResultCodes, @QueryParameter(value="unstableResultCodes_em") String unstableResultCodes, @QueryParameter(value="failureResultCodes_em") String failureResultCodes, @QueryParameter(value="notBuiltResultCodes_em") String notBuiltResultCodes, @QueryParameter(value="abortedResultCodes_em") String abortedResultCodes) {
        return this.validateResultCodes(notBuiltResultCodes, new String[]{successResultCodes, unstableResultCodes, failureResultCodes, abortedResultCodes});
    }

    public FormValidation doCheckAbortedResultCodes_em(@QueryParameter(value="successResultCodes_em") String successResultCodes, @QueryParameter(value="unstableResultCodes_em") String unstableResultCodes, @QueryParameter(value="failureResultCodes_em") String failureResultCodes, @QueryParameter(value="notBuiltResultCodes_em") String notBuiltResultCodes, @QueryParameter(value="abortedResultCodes_em") String abortedResultCodes) {
        return this.validateResultCodes(abortedResultCodes, new String[]{successResultCodes, unstableResultCodes, failureResultCodes, notBuiltResultCodes});
    }

    private FormValidation validateResultCodes(String codesStr, String[] otherCodesStrArray) {
        if (codesStr != null) {
            Set<Integer> codes = null;
            try {
                codes = KiuwanUtils.parseErrorCodes(codesStr);
            }
            catch (Throwable throwable) {
                return FormValidation.error((String)"Invalid value. Result codes must be specified as a comma-separated list of numbers.");
            }
            HashSet<Integer> repeatedValues = new HashSet<Integer>();
            for (String otherCodesStr : otherCodesStrArray) {
                try {
                    Set<Integer> otherCodes = KiuwanUtils.parseErrorCodes(otherCodesStr);
                    if (Collections.disjoint(codes, otherCodes) || otherCodes.isEmpty()) continue;
                    otherCodes.retainAll(codes);
                    repeatedValues.addAll(otherCodes);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!repeatedValues.isEmpty()) {
                String codeMessage = null;
                codeMessage = repeatedValues.size() == 1 ? "This code is bound to multiple build statuses: " : "These codes are bound to multiple build statuses: ";
                return FormValidation.error((String)("One result code can only be assigned to one build status. " + codeMessage + repeatedValues + ". Please remove the duplicity."));
            }
        }
        return FormValidation.ok();
    }
}

