/*
 * Decompiled with CFR 0.152.
 */
package com.kiuwan.plugins.kiuwanJenkinsPlugin;

import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanConnectionProfile;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanGlobalConfigDescriptor;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanRecorderDescriptor;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.Mode;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.runnable.KiuwanRunnable;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class KiuwanRecorder
extends Recorder
implements SimpleBuildStep {
    public static final Long TIMEOUT_MARGIN_MILLIS = 5000L;
    public static final Long TIMEOUT_MARGIN_SECONDS = TimeUnit.SECONDS.convert(TIMEOUT_MARGIN_MILLIS, TimeUnit.MILLISECONDS);
    private String connectionProfileUuid;
    private String sourcePath = "";
    private String outputFilename = "kiuwan/output.json";
    private String selectedMode = KiuwanRecorderDescriptor.DEFAULT_MODE;
    private String applicationName = "${JOB_NAME}";
    private String label = "#${BUILD_NUMBER}";
    private String encoding = "UTF-8";
    private String includes = "";
    private String excludes = "**/src/test/**,**/__MACOSX/**,**/*.min.js,**/*.Designer.vb,**/*.designer.vb,**/*Reference.vb,**/*Service.vb,**/*Silverlight.vb,**/*.Designer.cs,**/*.designer.cs,**/*Reference.cs,**/*Service.cs,**/*Silverlight.cs,**/.*,**/Pods/BuildHeaders/**/*.h,**/Pods/Headers/**/*.h,**/node_modules/**,**/bower_components/**,**/target/**,**/bin/**,**/obj/**,**/dist/**,**/lib/**";
    private Integer timeout = KiuwanRecorderDescriptor.DEFAULT_TIMEOUT;
    private Boolean indicateLanguages = KiuwanRecorderDescriptor.DEFAULT_INDICATE_LANGUAGES;
    private String languages = "abap,actionscript,aspnet,c,cobol,cpp,csharp,go,groovy,html,informix,java,javascript,jcl,jsp,kotlin,natural,objectivec,oracleforms,other,perl,php,plsql,powerscript,python,rpg4,ruby,scala,sqlscript,swift,transactsql,vb6,vbnet,xml";
    private String measure = KiuwanRecorderDescriptor.DEFAULT_MEASURE;
    private Double unstableThreshold;
    private Double failureThreshold;
    private String applicationName_dm = "${JOB_NAME}";
    private String label_dm = "#${BUILD_NUMBER}";
    private String changeRequest_dm = "";
    private String analysisScope_dm = KiuwanRecorderDescriptor.DEFAULT_ANALYSIS_SCOPE;
    private String branch_dm = "";
    private String changeRequestStatus_dm = KiuwanRecorderDescriptor.DEFAULT_CHANGE_REQUEST_STATUS;
    private String encoding_dm = "UTF-8";
    private String includes_dm = "";
    private String excludes_dm = "**/src/test/**,**/__MACOSX/**,**/*.min.js,**/*.Designer.vb,**/*.designer.vb,**/*Reference.vb,**/*Service.vb,**/*Silverlight.vb,**/*.Designer.cs,**/*.designer.cs,**/*Reference.cs,**/*Service.cs,**/*Silverlight.cs,**/.*,**/Pods/BuildHeaders/**/*.h,**/Pods/Headers/**/*.h,**/node_modules/**,**/bower_components/**,**/target/**,**/bin/**,**/obj/**,**/dist/**,**/lib/**";
    private Integer timeout_dm = KiuwanRecorderDescriptor.DEFAULT_TIMEOUT;
    private Boolean indicateLanguages_dm = KiuwanRecorderDescriptor.DEFAULT_INDICATE_LANGUAGES;
    private String languages_dm = "abap,actionscript,aspnet,c,cobol,cpp,csharp,go,groovy,html,informix,java,javascript,jcl,jsp,kotlin,natural,objectivec,oracleforms,other,perl,php,plsql,powerscript,python,rpg4,ruby,scala,sqlscript,swift,transactsql,vb6,vbnet,xml";
    private Boolean waitForAuditResults_dm = KiuwanRecorderDescriptor.DEFAULT_WAIT_FOR_AUDIT_RESULTS;
    private String markBuildWhenNoPass_dm = "UNSTABLE";
    private String commandArgs_em = "-c -n \"${JOB_NAME}\" -l \"#${BUILD_NUMBER}\"";
    private String extraParameters_em = "encoding=\"UTF-8\" supported.technologies=\"abap,actionscript,aspnet,c,cobol,cpp,csharp,go,groovy,html,informix,java,javascript,jcl,jsp,kotlin,natural,objectivec,oracleforms,other,perl,php,plsql,powerscript,python,rpg4,ruby,scala,sqlscript,swift,transactsql,vb6,vbnet,xml\" exclude.patterns=\"**/src/test/**,**/__MACOSX/**,**/*.min.js,**/*.Designer.vb,**/*.designer.vb,**/*Reference.vb,**/*Service.vb,**/*Silverlight.vb,**/*.Designer.cs,**/*.designer.cs,**/*Reference.cs,**/*Service.cs,**/*Silverlight.cs,**/.*,**/Pods/BuildHeaders/**/*.h,**/Pods/Headers/**/*.h,**/node_modules/**,**/bower_components/**,**/target/**,**/bin/**,**/obj/**,**/dist/**,**/lib/**\"";
    private Integer timeout_em = KiuwanRecorderDescriptor.DEFAULT_TIMEOUT;
    private String successResultCodes_em = "0";
    private String unstableResultCodes_em = "10, 13";
    private String failureResultCodes_em = "1, 11, 12, 14";
    private String notBuiltResultCodes_em = "";
    private String abortedResultCodes_em = "";
    private String markAsInOtherCases_em = "FAILURE";

    @DataBoundConstructor
    public KiuwanRecorder() {
    }

    public boolean needsToRunAfterFinalized() {
        return false;
    }

    public KiuwanRecorderDescriptor getDescriptor() {
        return (KiuwanRecorderDescriptor)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        Result result;
        Throwable throwable;
        long startTime = System.currentTimeMillis();
        Integer timeout = null;
        Mode mode = Mode.valueOf(this.selectedMode != null ? this.selectedMode : KiuwanRecorderDescriptor.DEFAULT_MODE);
        timeout = Mode.DELIVERY_MODE.equals(mode) ? this.getTimeout_dm() : (Mode.EXPERT_MODE.equals(mode) ? this.getTimeout_em() : this.getTimeout());
        long endTime = startTime + TimeUnit.MILLISECONDS.convert(timeout.intValue(), TimeUnit.MINUTES);
        Computer computer = workspace.toComputer();
        if (computer == null) {
            throw new RuntimeException("Workspace yielded no computer. Make sure a workspace is defined.");
        }
        Node node = computer.getNode();
        if (node == null) {
            throw new RuntimeException("Computer yielded no node. Make sure the selected executor's node is online.");
        }
        AtomicReference<Throwable> exceptionReference = new AtomicReference<Throwable>();
        AtomicReference<Result> resultReference = new AtomicReference<Result>();
        KiuwanGlobalConfigDescriptor descriptor = KiuwanGlobalConfigDescriptor.get();
        KiuwanConnectionProfile connectionProfile = descriptor.getConnectionProfile(this.connectionProfileUuid);
        KiuwanRunnable runnable = new KiuwanRunnable(this, workspace, connectionProfile, descriptor, node, run, launcher, listener, exceptionReference, resultReference);
        Thread thread = new Thread(runnable);
        thread.start();
        long currentTime = System.currentTimeMillis();
        try {
            while (thread.isAlive() && currentTime < endTime) {
                TimeUnit.MILLISECONDS.sleep(TIMEOUT_MARGIN_MILLIS);
                currentTime = System.currentTimeMillis();
            }
        }
        catch (InterruptedException interruptedException) {
            if (thread.isAlive()) {
                thread.interrupt();
            }
            run.setResult(Result.ABORTED);
            throw interruptedException;
        }
        if (thread.isAlive()) {
            listener.getLogger().println("Aborted by timeout.");
            run.setResult(Result.ABORTED);
        }
        if ((throwable = exceptionReference.get()) != null) {
            if (throwable instanceof InterruptedException) {
                throw (InterruptedException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            run.setResult(Result.FAILURE);
        }
        if ((result = resultReference.get()) != null) {
            run.setResult(result);
        }
    }

    public boolean isModeBaseline() {
        return Mode.STANDARD_MODE.getValue().equals(this.selectedMode);
    }

    public boolean isModeDelivery() {
        return Mode.DELIVERY_MODE.getValue().equals(this.selectedMode);
    }

    public boolean isModeExpert() {
        return Mode.EXPERT_MODE.getValue().equals(this.selectedMode);
    }

    public Double getUnstableThreshold() {
        Double ret = new Double(0.0);
        if (this.unstableThreshold != null) {
            ret = this.unstableThreshold;
        }
        return ret;
    }

    public Double getFailureThreshold() {
        Double ret = new Double(0.0);
        if (this.failureThreshold != null) {
            ret = this.failureThreshold;
        }
        return ret;
    }

    public String getConnectionProfileUuid() {
        return this.connectionProfileUuid;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public String getSelectedMode() {
        return this.selectedMode;
    }

    public String getOutputFilename() {
        return this.outputFilename;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getLabel() {
        return this.label;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Boolean getIndicateLanguages() {
        return this.indicateLanguages;
    }

    public String getMeasure() {
        return this.measure;
    }

    public String getLanguages() {
        return this.languages;
    }

    public String getApplicationName_dm() {
        return this.applicationName_dm;
    }

    public String getLabel_dm() {
        return this.label_dm;
    }

    public String getEncoding_dm() {
        return this.encoding_dm;
    }

    public String getIncludes_dm() {
        return this.includes_dm;
    }

    public String getExcludes_dm() {
        return this.excludes_dm;
    }

    public Integer getTimeout_dm() {
        return this.timeout_dm;
    }

    public Integer getTimeout_em() {
        return this.timeout_em;
    }

    public Boolean getIndicateLanguages_dm() {
        return this.indicateLanguages_dm;
    }

    public String getLanguages_dm() {
        return this.languages_dm;
    }

    public String getChangeRequest_dm() {
        return this.changeRequest_dm;
    }

    public String getAnalysisScope_dm() {
        return this.analysisScope_dm;
    }

    public Boolean getWaitForAuditResults_dm() {
        return this.waitForAuditResults_dm;
    }

    public String getBranch_dm() {
        return this.branch_dm;
    }

    public String getChangeRequestStatus_dm() {
        return this.changeRequestStatus_dm;
    }

    public String getCommandArgs_em() {
        return this.commandArgs_em;
    }

    public String getExtraParameters_em() {
        return this.extraParameters_em;
    }

    public String getMarkBuildWhenNoPass_dm() {
        return this.markBuildWhenNoPass_dm;
    }

    public String getSuccessResultCodes_em() {
        return this.successResultCodes_em;
    }

    public String getUnstableResultCodes_em() {
        return this.unstableResultCodes_em;
    }

    public String getFailureResultCodes_em() {
        return this.failureResultCodes_em;
    }

    public String getNotBuiltResultCodes_em() {
        return this.notBuiltResultCodes_em;
    }

    public String getAbortedResultCodes_em() {
        return this.abortedResultCodes_em;
    }

    public String getMarkAsInOtherCases_em() {
        return this.markAsInOtherCases_em;
    }

    @DataBoundSetter
    public void setConnectionProfileUuid(String connectionProfileUuid) {
        this.connectionProfileUuid = connectionProfileUuid;
    }

    @DataBoundSetter
    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    @DataBoundSetter
    public void setOutputFilename(String outputFilename) {
        this.outputFilename = outputFilename;
    }

    @DataBoundSetter
    public void setSelectedMode(String selectedMode) {
        this.selectedMode = selectedMode;
    }

    @DataBoundSetter
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @DataBoundSetter
    public void setApplicationName_dm(String applicationName_dm) {
        this.applicationName_dm = applicationName_dm;
    }

    @DataBoundSetter
    public void setLabel(String label) {
        this.label = label;
    }

    @DataBoundSetter
    public void setLabel_dm(String label_dm) {
        this.label_dm = label_dm;
    }

    @DataBoundSetter
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @DataBoundSetter
    public void setEncoding_dm(String encoding_dm) {
        this.encoding_dm = encoding_dm;
    }

    @DataBoundSetter
    public void setIncludes(String includes) {
        this.includes = includes;
    }

    @DataBoundSetter
    public void setIncludes_dm(String includes_dm) {
        this.includes_dm = includes_dm;
    }

    @DataBoundSetter
    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    @DataBoundSetter
    public void setExcludes_dm(String excludes_dm) {
        this.excludes_dm = excludes_dm;
    }

    @DataBoundSetter
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    @DataBoundSetter
    public void setTimeout_dm(Integer timeout_dm) {
        this.timeout_dm = timeout_dm;
    }

    @DataBoundSetter
    public void setTimeout_em(Integer timeout_em) {
        this.timeout_em = timeout_em;
    }

    @DataBoundSetter
    public void setIndicateLanguages(Boolean indicateLanguages) {
        this.indicateLanguages = indicateLanguages;
    }

    @DataBoundSetter
    public void setMeasure(String measure) {
        this.measure = measure;
    }

    @DataBoundSetter
    public void setLanguages(String languages) {
        this.languages = languages;
    }

    @DataBoundSetter
    public void setIndicateLanguages_dm(Boolean indicateLanguages_dm) {
        this.indicateLanguages_dm = indicateLanguages_dm;
    }

    @DataBoundSetter
    public void setLanguages_dm(String languages_dm) {
        this.languages_dm = languages_dm;
    }

    @DataBoundSetter
    public void setUnstableThreshold(Double unstableThreshold) {
        this.unstableThreshold = unstableThreshold;
    }

    @DataBoundSetter
    public void setFailureThreshold(Double failureThreshold) {
        this.failureThreshold = failureThreshold;
    }

    @DataBoundSetter
    public void setChangeRequest_dm(String changeRequest_dm) {
        this.changeRequest_dm = changeRequest_dm;
    }

    @DataBoundSetter
    public void setAnalysisScope_dm(String analysisScope_dm) {
        this.analysisScope_dm = analysisScope_dm;
    }

    @DataBoundSetter
    public void setWaitForAuditResults_dm(Boolean waitForAuditResults_dm) {
        this.waitForAuditResults_dm = waitForAuditResults_dm;
    }

    @DataBoundSetter
    public void setBranch_dm(String branch_dm) {
        this.branch_dm = branch_dm;
    }

    @DataBoundSetter
    public void setChangeRequestStatus_dm(String changeRequestStatus_dm) {
        this.changeRequestStatus_dm = changeRequestStatus_dm;
    }

    @DataBoundSetter
    public void setCommandArgs_em(String commandArgs_em) {
        this.commandArgs_em = commandArgs_em;
    }

    @DataBoundSetter
    public void setExtraParameters_em(String extraParameters_em) {
        this.extraParameters_em = extraParameters_em;
    }

    @DataBoundSetter
    public void setMarkBuildWhenNoPass_dm(String markBuildWhenNoPass_dm) {
        this.markBuildWhenNoPass_dm = markBuildWhenNoPass_dm;
    }

    @DataBoundSetter
    public void setSuccessResultCodes_em(String successResultCodes_em) {
        this.successResultCodes_em = successResultCodes_em;
    }

    @DataBoundSetter
    public void setUnstableResultCodes_em(String unstableResultCodes_em) {
        this.unstableResultCodes_em = unstableResultCodes_em;
    }

    @DataBoundSetter
    public void setFailureResultCodes_em(String failureResultCodes_em) {
        this.failureResultCodes_em = failureResultCodes_em;
    }

    @DataBoundSetter
    public void setNotBuiltResultCodes_em(String notBuiltResultCodes_em) {
        this.notBuiltResultCodes_em = notBuiltResultCodes_em;
    }

    @DataBoundSetter
    public void setAbortedResultCodes_em(String abortedResultCodes_em) {
        this.abortedResultCodes_em = abortedResultCodes_em;
    }

    @DataBoundSetter
    public void setMarkAsInOtherCases_em(String markAsInOtherCases_em) {
        this.markAsInOtherCases_em = markAsInOtherCases_em;
    }
}

