/*
 * Decompiled with CFR 0.152.
 */
package com.kiuwan.plugins.kiuwanJenkinsPlugin;

import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanConnectionProfile;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanRecorder;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.upgrade.UpgradeToConnectionProfiles;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.util.KiuwanUtils;
import com.thoughtworks.xstream.XStream;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Items;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class KiuwanGlobalConfigDescriptor
extends GlobalConfiguration
implements Serializable {
    private static final long serialVersionUID = 3509491644782698195L;
    private List<KiuwanConnectionProfile> connectionProfiles;
    private String configSaveTimestamp;
    private String upgradeConfigToConnectionProfilesTimestamp;
    private String upgradeJobsToConnectionProfilesTimestamp;

    public KiuwanGlobalConfigDescriptor() {
        this.load();
    }

    public List<KiuwanConnectionProfile> getConnectionProfiles() {
        return this.connectionProfiles;
    }

    public String getConfigSaveTimestamp() {
        return this.configSaveTimestamp;
    }

    public void setUpgradeConfigToConnectionProfilesTimestamp(String upgradeConfigToConnectionProfilesTimestamp) {
        this.upgradeConfigToConnectionProfilesTimestamp = upgradeConfigToConnectionProfilesTimestamp;
    }

    public void setUpgradeJobsToConnectionProfilesTimestamp(String upgradeJobsToConnectionProfilesTimestamp) {
        this.upgradeJobsToConnectionProfilesTimestamp = upgradeJobsToConnectionProfilesTimestamp;
    }

    public boolean isConfigUpgradedToConnectionProfiles() {
        return StringUtils.isNotEmpty((String)this.upgradeConfigToConnectionProfilesTimestamp);
    }

    public boolean isJobsUpgradedToConnectionProfiles() {
        return StringUtils.isNotEmpty((String)this.upgradeJobsToConnectionProfilesTimestamp);
    }

    public static KiuwanGlobalConfigDescriptor get() {
        return (KiuwanGlobalConfigDescriptor)GlobalConfiguration.all().get(KiuwanGlobalConfigDescriptor.class);
    }

    public KiuwanConnectionProfile getConnectionProfile(String connectionProfileUuid) {
        KiuwanConnectionProfile connectionProfile = null;
        for (KiuwanConnectionProfile cp : this.connectionProfiles) {
            if (connectionProfileUuid == null || !connectionProfileUuid.equals(cp.getUuid())) continue;
            connectionProfile = cp;
            break;
        }
        return connectionProfile;
    }

    public String getDisplayName() {
        return "Kiuwan Global Configuration";
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        List list = req.bindJSONToList(KiuwanConnectionProfile.class, json.get("connectionProfiles"));
        this.setConnectionProfiles(list);
        this.save();
        return true;
    }

    public synchronized void save() {
        this.configSaveTimestamp = KiuwanUtils.getCurrentTimestampString();
        super.save();
    }

    protected XmlFile getConfigFile() {
        File file = KiuwanGlobalConfigDescriptor.getGlobalConfigFile();
        return new XmlFile((XStream)Items.XSTREAM2, file);
    }

    public boolean existOldConfigFile() {
        File oldConfigFile = KiuwanGlobalConfigDescriptor.getOldGlobalConfigFile();
        return oldConfigFile.exists();
    }

    public FormValidation doUpgradeToConnectionProfiles() {
        KiuwanGlobalConfigDescriptor instance = KiuwanGlobalConfigDescriptor.get();
        boolean upgradeConfigOk = true;
        if (instance == null || !instance.isConfigUpgradedToConnectionProfiles()) {
            upgradeConfigOk = UpgradeToConnectionProfiles.upgradeConfiguration();
        }
        boolean upgradeJobsOk = true;
        if (instance == null || !instance.isJobsUpgradedToConnectionProfiles()) {
            upgradeJobsOk = UpgradeToConnectionProfiles.upgradeJobs();
        }
        FormValidation ret = null;
        ret = upgradeConfigOk && upgradeJobsOk ? FormValidation.okWithMarkup((String)("Upgrade done! Please reload the <a href=\"" + Jenkins.getInstance().getRootUrl() + "configure\">settings page</a>.")) : FormValidation.warning((String)"Upgrade failed! Please check Jenkins logs to diagnose the problem.");
        return ret;
    }

    public boolean existMisconfiguredJobs() {
        List jobs = Jenkins.getInstance().getAllItems(AbstractProject.class);
        for (AbstractProject job : jobs) {
            DescribableList publishers = job.getPublishersList();
            for (Publisher publisher : publishers) {
                if (!(publisher instanceof KiuwanRecorder)) continue;
                KiuwanRecorder kiuwanRecorder = (KiuwanRecorder)publisher;
                String connectionProfileUuid = kiuwanRecorder.getConnectionProfileUuid();
                if (StringUtils.isEmpty((String)connectionProfileUuid)) {
                    return true;
                }
                KiuwanConnectionProfile connectionProfile = this.getConnectionProfile(connectionProfileUuid);
                if (connectionProfile != null) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getMisconfiguredJobs() {
        ArrayList<String> misconfiguredJobs = new ArrayList<String>();
        List jobs = Jenkins.getInstance().getAllItems(AbstractProject.class);
        for (AbstractProject job : jobs) {
            DescribableList publishers = job.getPublishersList();
            for (Publisher publisher : publishers) {
                if (!(publisher instanceof KiuwanRecorder)) continue;
                KiuwanRecorder kiuwanRecorder = (KiuwanRecorder)publisher;
                String connectionProfileUuid = kiuwanRecorder.getConnectionProfileUuid();
                if (connectionProfileUuid == null) {
                    misconfiguredJobs.add(job.getFullDisplayName() + " (old configuration)");
                    continue;
                }
                if (connectionProfileUuid.isEmpty()) {
                    misconfiguredJobs.add(job.getFullDisplayName() + " (profile not set)");
                    continue;
                }
                KiuwanConnectionProfile connectionProfile = this.getConnectionProfile(connectionProfileUuid);
                if (connectionProfile != null) continue;
                misconfiguredJobs.add(job.getFullDisplayName() + " (configured profile not found)");
            }
        }
        return misconfiguredJobs;
    }

    public boolean existDuplicateNames() {
        if (this.connectionProfiles == null) {
            return false;
        }
        HashSet<String> profileNames = new HashSet<String>();
        for (KiuwanConnectionProfile connectionProfile : this.connectionProfiles) {
            if (profileNames.contains(connectionProfile.getName())) {
                return true;
            }
            if (!StringUtils.isNotEmpty((String)connectionProfile.getName())) continue;
            profileNames.add(connectionProfile.getName());
        }
        return false;
    }

    public List<String> getDuplicateNames() {
        HashSet<String> profileNames = new HashSet<String>();
        ArrayList<String> duplicates = new ArrayList<String>();
        for (KiuwanConnectionProfile connectionProfile : this.connectionProfiles) {
            if (profileNames.add(connectionProfile.getName()) || !StringUtils.isNotEmpty((String)connectionProfile.getName())) continue;
            duplicates.add(connectionProfile.getName());
        }
        return duplicates;
    }

    public void setConnectionProfiles(List<KiuwanConnectionProfile> list) {
        for (KiuwanConnectionProfile connectionProfile : list) {
            if (!StringUtils.isEmpty((String)connectionProfile.getUuid())) continue;
            connectionProfile.generateUuid();
        }
        this.connectionProfiles = new ArrayList<KiuwanConnectionProfile>();
        this.connectionProfiles.addAll(list);
    }

    public static File getGlobalConfigFile() {
        return new File(Jenkins.getInstance().getRootDir(), "com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanGlobalConfig.xml");
    }

    public static File getOldGlobalConfigFile() {
        return new File(Jenkins.getInstance().getRootDir(), "com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanRecorder.xml");
    }
}

