/*
 * Decompiled with CFR 0.152.
 */
package com.kiuwan.plugins.kiuwanJenkinsPlugin;

import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanConnectionProfile;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.client.KiuwanClientException;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.client.KiuwanClientUtils;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.ProxyAuthentication;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.ProxyMode;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.ProxyProtocol;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.util.KiuwanAnalyzerInstaller;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.util.KiuwanUtils;
import com.kiuwan.rest.client.ApiClient;
import com.kiuwan.rest.client.ApiException;
import com.kiuwan.rest.client.api.InformationApi;
import com.kiuwan.rest.client.model.UserInformationResponse;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.kohsuke.stapler.QueryParameter;

@Extension
public class KiuwanConnectionProfileDescriptor
extends Descriptor<KiuwanConnectionProfile> {
    public static final String DEFAULT_CONFIGURE_PROXY = ProxyMode.NONE.getValue();
    public static final int DEFAULT_PROXY_PORT = 3128;

    public KiuwanConnectionProfileDescriptor() {
        super(KiuwanConnectionProfile.class);
    }

    public String getDisplayName() {
        return "Kiuwan Connection Profile";
    }

    public ProxyMode getConfigureProxyNone() {
        return ProxyMode.NONE;
    }

    public ProxyMode getConfigureProxyJenkins() {
        return ProxyMode.JENKINS;
    }

    public ProxyMode getConfigureProxyCustom() {
        return ProxyMode.CUSTOM;
    }

    public FormValidation doCheckName(@QueryParameter(value="name") String name) {
        if (StringUtils.isEmpty((String)name)) {
            return FormValidation.error((String)"Field is required");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckKiuwanURL(@QueryParameter(value="configureKiuwanURL") boolean configureKiuwanURL, @QueryParameter(value="kiuwanURL") String kiuwanURL) {
        if (configureKiuwanURL) {
            try {
                new URL(kiuwanURL + "/rest");
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)"URL is not a valid.");
            }
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckProxyHost(@QueryParameter(value="configureProxy") boolean configureProxy, @QueryParameter(value="proxyHost") String proxyHost) {
        if (configureProxy && StringUtils.isEmpty((String)proxyHost)) {
            return FormValidation.error((String)"Field is required");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckProxyPort(@QueryParameter(value="proxyPort") int proxyPort) {
        if (proxyPort <= 0) {
            return FormValidation.error((String)"Proxy port must be a number greater than 0");
        }
        return FormValidation.ok();
    }

    public ListBoxModel doFillProxyProtocolItems(@QueryParameter(value="proxyProtocol") String proxyProtocol) {
        return KiuwanUtils.createListBoxModel(ProxyProtocol.values(), proxyProtocol);
    }

    public ListBoxModel doFillProxyAuthenticationItems(@QueryParameter(value="proxyAuthentication") String proxyAuthentication) {
        return KiuwanUtils.createListBoxModel(ProxyAuthentication.values(), proxyAuthentication);
    }

    public FormValidation doCheckCredentials(@QueryParameter String username, @QueryParameter String password, @QueryParameter String domain, @QueryParameter boolean configureKiuwanURL, @QueryParameter String kiuwanURL) {
        String customerEngineVersion = null;
        String credentialsErrorMessage = null;
        try {
            ApiClient client = KiuwanClientUtils.instantiateClient(configureKiuwanURL, kiuwanURL, username, password, domain);
            InformationApi api = new InformationApi(client);
            UserInformationResponse information = api.getInformation();
            customerEngineVersion = information.getEngineVersion() + (information.isEngineFrozen() != false ? " [FROZEN]" : "");
        }
        catch (ApiException e) {
            KiuwanClientException krce = KiuwanClientException.from(e);
            KiuwanUtils.logger().log(Level.WARNING, krce.toString());
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)krce);
            credentialsErrorMessage = "Authentication failed. Reason: " + krce.getLocalizedMessage() + (rootCause != null ? " (" + rootCause + ")" : "");
        }
        catch (Throwable t) {
            KiuwanUtils.logger().log(Level.SEVERE, t.toString());
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
            credentialsErrorMessage = "Could not initiate the authentication process. Reason: " + t.getLocalizedMessage() + (rootCause != null ? " (" + rootCause + ")" : "");
        }
        String currentKlaVersion = null;
        String connectionErrorMessage = null;
        try {
            currentKlaVersion = KiuwanAnalyzerInstaller.getCurrentKlaVersion(configureKiuwanURL, kiuwanURL);
        }
        catch (Throwable t) {
            KiuwanUtils.logger().log(Level.SEVERE, t.toString());
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
            connectionErrorMessage = "Cannot reach Kiuwan using Jenkins connection API. Reason: " + t + (rootCause != null ? " (" + rootCause + ")" : "");
        }
        FormValidation formValidation = null;
        formValidation = customerEngineVersion != null && currentKlaVersion != null ? FormValidation.okWithMarkup((String)("Authentication completed successfully.<ul><li>Current Kiuwan Local Analyzer version: <b>" + currentKlaVersion + "</b>.</li><li>Current Kiuwan Engine version: <b>" + customerEngineVersion + "</b>.</li></ul>")) : (customerEngineVersion == null && currentKlaVersion != null ? FormValidation.error((String)credentialsErrorMessage) : (customerEngineVersion != null && currentKlaVersion == null ? FormValidation.error(connectionErrorMessage) : FormValidation.errorWithMarkup((String)(credentialsErrorMessage + "<br><br>" + connectionErrorMessage))));
        return formValidation;
    }
}

