/*
 * Decompiled with CFR 0.152.
 */
package com.kiuwan.plugins.kiuwanJenkinsPlugin;

import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanConnectionProfileDescriptor;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.KiuwanModelObject;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.ProxyMode;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.Secret;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import jenkins.model.Jenkins;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class KiuwanConnectionProfile
implements Describable<KiuwanConnectionProfile>,
KiuwanModelObject,
Serializable {
    private static final long serialVersionUID = 1768850962607295267L;
    private String uuid;
    private String name;
    private String username;
    private String password;
    private String domain;
    private boolean configureKiuwanURL;
    private String kiuwanURL;
    private String configureProxy = KiuwanConnectionProfileDescriptor.DEFAULT_CONFIGURE_PROXY;
    private String proxyHost;
    private int proxyPort = 3128;
    private String proxyProtocol;
    private String proxyAuthentication;
    private String proxyUsername;
    private String proxyPassword;

    @DataBoundConstructor
    public KiuwanConnectionProfile() {
    }

    public Descriptor<KiuwanConnectionProfile> getDescriptor() {
        return Jenkins.getInstance().getDescriptorByType(KiuwanConnectionProfileDescriptor.class);
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        ProxyMode selectedProxyMode;
        String profileName = StringUtils.isNotEmpty((String)this.name) ? this.name : "?";
        String profileUsername = StringUtils.isNotEmpty((String)this.username) ? this.username : "?";
        String profileHost = null;
        if (this.configureKiuwanURL) {
            try {
                URL url = new URL(this.kiuwanURL);
                profileHost = url.getHost() + (url.getPort() >= 0 ? ":" + url.getPort() : "");
            }
            catch (MalformedURLException e) {
                profileHost = "?";
            }
        } else {
            profileHost = "www.kiuwan.com";
        }
        String profileProxyMode = (selectedProxyMode = ProxyMode.valueFrom(this.configureProxy)) != null ? selectedProxyMode.getDisplayName() : "?";
        return profileName + " - " + profileUsername + "@" + profileHost + " - " + profileProxyMode + " for KLA (" + this.uuid + ")";
    }

    @Override
    public String getValue() {
        return this.uuid;
    }

    public boolean isConfigureProxyNone() {
        return ProxyMode.NONE.getValue().equals(this.configureProxy);
    }

    public boolean isConfigureProxyJenkins() {
        return ProxyMode.JENKINS.getValue().equals(this.configureProxy);
    }

    public boolean isConfigureProxyCustom() {
        return ProxyMode.CUSTOM.getValue().equals(this.configureProxy);
    }

    public String generateUuid() {
        int length = 8;
        String randomAlphanumeric = RandomStringUtils.randomAlphanumeric((int)length);
        String head = randomAlphanumeric.substring(0, length / 2);
        String tail = randomAlphanumeric.substring(length / 2);
        this.uuid = head + "-" + tail;
        return this.uuid;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return KiuwanConnectionProfile.decrypt(this.password);
    }

    public String getDomain() {
        return this.domain;
    }

    public boolean isConfigureKiuwanURL() {
        return this.configureKiuwanURL;
    }

    public String getKiuwanURL() {
        return this.kiuwanURL;
    }

    public String getConfigureProxy() {
        return this.configureProxy;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyProtocol() {
        return this.proxyProtocol;
    }

    public String getProxyAuthentication() {
        return this.proxyAuthentication;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return KiuwanConnectionProfile.decrypt(this.proxyPassword);
    }

    @DataBoundSetter
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    @DataBoundSetter
    public void setUsername(String username) {
        this.username = username;
    }

    @DataBoundSetter
    public void setPassword(String password) {
        this.password = KiuwanConnectionProfile.encrypt(password);
    }

    @DataBoundSetter
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @DataBoundSetter
    public void setConfigureKiuwanURL(boolean configureKiuwanURL) {
        this.configureKiuwanURL = configureKiuwanURL;
    }

    @DataBoundSetter
    public void setKiuwanURL(String kiuwanURL) {
        this.kiuwanURL = kiuwanURL;
    }

    @DataBoundSetter
    public void setConfigureProxy(String configureProxy) {
        this.configureProxy = configureProxy;
    }

    @DataBoundSetter
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @DataBoundSetter
    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    @DataBoundSetter
    public void setProxyProtocol(String proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    @DataBoundSetter
    public void setProxyAuthentication(String proxyAuthentication) {
        this.proxyAuthentication = proxyAuthentication;
    }

    @DataBoundSetter
    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    @DataBoundSetter
    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = KiuwanConnectionProfile.encrypt(proxyPassword);
    }

    private static String encrypt(String value) {
        return Secret.fromString((String)value).getEncryptedValue();
    }

    private static String decrypt(String value) {
        return Secret.toString((Secret)Secret.decrypt((String)value));
    }
}

