/*
 * Decompiled with CFR 0.152.
 */
package com.kiuwan.plugins.kiuwanJenkinsPlugin;

import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanConnectionProfile;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.KiuwanGlobalConfigDescriptor;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.util.KiuwanAnalyzerInstaller;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.util.KiuwanUtils;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.slaves.ComputerListener;
import java.io.IOException;
import java.util.logging.Level;
import jenkins.model.Jenkins;

@Extension
public class KiuwanComputerListener
extends ComputerListener {
    public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
        if (c.getNode() == Jenkins.getInstance()) {
            this.process(c, c.getNode().getRootPath(), listener);
        }
    }

    public void preOnline(Computer c, Channel channel, FilePath root, TaskListener listener) throws IOException, InterruptedException {
        this.process(c, root, listener);
    }

    public void process(Computer computer, FilePath root, TaskListener listener) throws IOException, InterruptedException {
        KiuwanGlobalConfigDescriptor descriptor = KiuwanGlobalConfigDescriptor.get();
        if (descriptor.getConnectionProfiles() != null) {
            String message = "Checking Kiuwan Local Analyzer installations on node " + computer.getDisplayName();
            KiuwanUtils.logger().log(Level.INFO, message);
            listener.getLogger().println(message);
            for (KiuwanConnectionProfile connectionProfile : descriptor.getConnectionProfiles()) {
                try {
                    KiuwanAnalyzerInstaller.installKiuwanLocalAnalyzer(root, listener, connectionProfile);
                }
                catch (IOException e) {
                    String error = "Failed to install Kiuwan Local Analyzer: " + e;
                    KiuwanUtils.logger().log(Level.SEVERE, error);
                    listener.error(error);
                }
            }
        }
    }
}

