/*
 * Decompiled with CFR 0.152.
 */
package com.kiuwan.plugins.kiuwanJenkinsPlugin;

import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.results.AnalysisResult;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.results.CheckpointResult;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.results.MetricValue;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.model.results.ViolatedRule;
import com.kiuwan.plugins.kiuwanJenkinsPlugin.util.KiuwanUtils;
import hudson.model.Action;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=2)
public class KiuwanBuildSummaryAction
implements Action,
Serializable {
    private static final long serialVersionUID = 351165444201348768L;
    private AnalysisResult analysisResult;
    private String url;
    private String icon;
    private AuditFixStatistics auditFixStatistics;

    @Deprecated
    public KiuwanBuildSummaryAction(String url) {
        this((AnalysisResult)null);
        this.url = url;
    }

    @DataBoundConstructor
    public KiuwanBuildSummaryAction(AnalysisResult analysisResult) {
        this.analysisResult = analysisResult;
        this.icon = "/plugin/kiuwanJenkinsPlugin/images/kiuwan-logo.png";
        if (analysisResult != null) {
            this.url = this.isBaseline() ? analysisResult.getAnalysisURL() : analysisResult.getAuditResultURL();
        }
    }

    public String getIcon() {
        return this.icon;
    }

    public String getUrl() {
        return this.url;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }

    public AnalysisResult getAnalysisResult() {
        return this.analysisResult;
    }

    public boolean isResultAvailable() {
        return this.analysisResult != null;
    }

    public boolean isSimpleSummary() {
        return this.analysisResult == null && !StringUtils.isEmpty((String)this.icon) && !StringUtils.isEmpty((String)this.url);
    }

    public boolean isBaseline() {
        return "Baseline".equals(this.analysisResult.getAnalysisScope());
    }

    public boolean isDelivery() {
        return "Complete delivery".equals(this.analysisResult.getAnalysisScope()) || "Partial delivery".equals(this.analysisResult.getAnalysisScope());
    }

    public Integer getLinesOfCode() {
        Double loc = this.getMainMetricValue("Lines of code");
        return loc != null ? Integer.valueOf(loc.intValue()) : null;
    }

    public boolean hasSecurity() {
        return this.analysisResult.getSecurityMetrics() != null && !this.analysisResult.getSecurityMetrics().isEmpty();
    }

    public boolean hasQuality() {
        MetricValue qualityIndicator = this.analysisResult.getQualityIndicator();
        MetricValue effortToTarget = this.analysisResult.getEffortToTarget();
        MetricValue riskIndex = this.analysisResult.getRiskIndex();
        return riskIndex != null && qualityIndicator != null && effortToTarget != null;
    }

    public boolean hasInsights() {
        return this.analysisResult.getInsightsData() != null;
    }

    public boolean hasAuditResults() {
        return this.analysisResult.getAuditResult() != null;
    }

    public int getSecurityRating() {
        Double securityRating = (Double)this.analysisResult.getSecurityMetrics().get("Rating");
        return securityRating != null ? securityRating.intValue() : 0;
    }

    public boolean hasSecurityRating(int rating) {
        return this.getSecurityRating() >= rating;
    }

    public Integer getSecurityVulnerabilities(String key) {
        Map vulnerabilities = (Map)this.analysisResult.getSecurityMetrics().get("Vulnerabilities");
        Object value = vulnerabilities.get(key);
        Integer valueInt = null;
        if (value instanceof Double) {
            Double valueDouble = (Double)value;
            valueInt = valueDouble != null ? Integer.valueOf(valueDouble.intValue()) : null;
        } else if (value instanceof Integer) {
            valueInt = (Integer)value;
        }
        return valueInt;
    }

    public Double getMainMetricValue(String name) {
        if (this.analysisResult.getMainMetrics() != null) {
            for (MetricValue metricValue : this.analysisResult.getMainMetrics()) {
                if (!name.equals(metricValue.getName())) continue;
                return metricValue.getValue();
            }
        }
        return null;
    }

    public Double getQualityIndicator(String name) {
        if (this.analysisResult.getQualityIndicator().getChildren() != null) {
            for (MetricValue metricValue : this.analysisResult.getQualityIndicator().getChildren()) {
                if (!name.equals(metricValue.getName())) continue;
                return metricValue.getValue();
            }
        }
        return null;
    }

    public Integer getInsightRiskMap(String key, String entryKey) {
        Map<String, Integer> riskMap = this.analysisResult.getInsightsData().getRiskMap(key);
        Integer value = riskMap.get(entryKey);
        return value != null ? value : 0;
    }

    public Integer getSecurityVulnerabilitiesTotal() {
        return this.getSecurityVulnerabilities("Total");
    }

    public Integer getSecurityVulnerabilitiesVeryHigh() {
        return this.getSecurityVulnerabilities("VeryHigh");
    }

    public Integer getSecurityVulnerabilitiesHigh() {
        return this.getSecurityVulnerabilities("High");
    }

    public Integer getSecurityVulnerabilitiesNormal() {
        return this.getSecurityVulnerabilities("Normal");
    }

    public Integer getSecurityVulnerabilitiesLow() {
        return this.getSecurityVulnerabilities("Low");
    }

    public Integer getTotalDefects() {
        Double totalDefects = this.getMainMetricValue("Total defects");
        return totalDefects != null ? Integer.valueOf(totalDefects.intValue()) : null;
    }

    public String getRiskIndex() {
        return KiuwanBuildSummaryAction.formatDouble(this.analysisResult.getRiskIndex().getValue());
    }

    public String getQualityIndicator() {
        return KiuwanBuildSummaryAction.formatDouble(this.analysisResult.getQualityIndicator().getValue());
    }

    public String getEffortToTarget() {
        Double effortToTarget = this.analysisResult.getEffortToTarget().getValue();
        StringBuilder sb = new StringBuilder();
        int effortM = (int)(KiuwanUtils.roundDouble(effortToTarget) * 60.0);
        int effortH = effortM / 60;
        effortM %= 60;
        if (effortH > 0) {
            sb.append(effortH + "h ");
        }
        if (effortH <= 100) {
            sb.append(effortM + "m");
        }
        return sb.toString();
    }

    public String getEfficiency() {
        return KiuwanBuildSummaryAction.formatDouble(this.getQualityIndicator("Efficiency"));
    }

    public String getMaintainability() {
        return KiuwanBuildSummaryAction.formatDouble(this.getQualityIndicator("Maintainability"));
    }

    public String getPortability() {
        return KiuwanBuildSummaryAction.formatDouble(this.getQualityIndicator("Portability"));
    }

    public String getReliability() {
        return KiuwanBuildSummaryAction.formatDouble(this.getQualityIndicator("Reliability"));
    }

    public String getSecurity() {
        return KiuwanBuildSummaryAction.formatDouble(this.getQualityIndicator("Security"));
    }

    public Integer getTotalComponents() {
        return this.analysisResult.getInsightsData().getComponents();
    }

    public Integer getDuplicatedComponents() {
        return this.analysisResult.getInsightsData().getDuplicates();
    }

    public Integer getInsightVulnerabilityRiskHigh() {
        return this.getInsightRiskMap("Vulnerability risk", "HIGH");
    }

    public Integer getInsightVulnerabilityRiskMedium() {
        return this.getInsightRiskMap("Vulnerability risk", "MEDIUM");
    }

    public Integer getInsightVulnerabilityRiskLow() {
        return this.getInsightRiskMap("Vulnerability risk", "LOW");
    }

    public Integer getInsightVulnerabilityRiskNone() {
        return this.getInsightRiskMap("Vulnerability risk", "NONE");
    }

    public Integer getInsightObsolescenceRiskHigh() {
        return this.getInsightRiskMap("Obsolescence risk", "HIGH");
    }

    public Integer getInsightObsolescenceRiskMedium() {
        return this.getInsightRiskMap("Obsolescence risk", "MEDIUM");
    }

    public Integer getInsightObsolescenceRiskLow() {
        return this.getInsightRiskMap("Obsolescence risk", "LOW");
    }

    public Integer getInsightObsolescenceRiskNone() {
        return this.getInsightRiskMap("Obsolescence risk", "NONE");
    }

    public Integer getInsightLicenseRiskHigh() {
        return this.getInsightRiskMap("License risk", "HIGH");
    }

    public Integer getInsightLicenseRiskNone() {
        return this.getInsightRiskMap("License risk", "NONE");
    }

    public Integer getInsightLicenseRiskUnknown() {
        return this.getInsightRiskMap("License risk", "UNKNOWN");
    }

    public boolean auditPassed() {
        return "OK".equals(this.analysisResult.getAuditResult().getOverallResult());
    }

    public String getAuditScore() {
        return KiuwanBuildSummaryAction.formatDouble(this.analysisResult.getAuditResult().getScore());
    }

    public int getFailedCheckpointsCount() {
        return this.getAuditFixStatistics().getFailedCheckpointsCount();
    }

    public int getTotalCheckpointsCount() {
        return this.getAuditFixStatistics().getTotalCheckpointsCount();
    }

    public List<CheckpointResult> getCheckpointResults() {
        return this.analysisResult.getAuditResult().getCheckpointResults();
    }

    public boolean isCheckpointResultOK(CheckpointResult checkpointResult) {
        return checkpointResult != null && "OK".equals(checkpointResult.getResult());
    }

    public int getAuditFixTotalDefectsCount() {
        return this.getAuditFixStatistics().getDefects();
    }

    public int getDeliveryTotalFilesCount() {
        return this.analysisResult.getDeliveryFiles().getCount();
    }

    public String getAuditEffort() {
        StringBuilder sb = new StringBuilder();
        int effortH = this.getAuditFixStatistics().getEffortHours();
        int effortM = this.getAuditFixStatistics().getEffortMinutes();
        effortH += effortM / 60;
        effortM %= 60;
        if (effortH > 0) {
            sb.append(effortH + " hours ");
        }
        if (effortH <= 100) {
            sb.append(effortM + " minutes");
        }
        return sb.toString();
    }

    private static String formatDouble(Double number) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(2);
        return nf.format(number);
    }

    private AuditFixStatistics getAuditFixStatistics() {
        if (this.auditFixStatistics == null) {
            this.auditFixStatistics = new AuditFixStatistics(this.analysisResult);
        }
        return this.auditFixStatistics;
    }

    private static class AuditFixStatistics {
        private int totalCheckpointsCount = 0;
        private int failedCheckpointsCount = 0;
        private int defects = 0;
        private int effortHours = 0;
        private int effortMinutes = 0;

        private AuditFixStatistics(AnalysisResult analysisResult) {
            if (analysisResult.getAuditResult() == null) {
                return;
            }
            List<CheckpointResult> checkpointResults = analysisResult.getAuditResult().getCheckpointResults();
            if (checkpointResults == null) {
                return;
            }
            this.totalCheckpointsCount = checkpointResults.size();
            for (CheckpointResult cr : checkpointResults) {
                if ("OK".equals(cr.getResult())) continue;
                ++this.failedCheckpointsCount;
                if (cr.getViolatedRules() == null) continue;
                for (ViolatedRule vr : cr.getViolatedRules()) {
                    this.defects = (int)((long)this.defects + vr.getDefectsCount());
                    String effortStr = vr.getEffort();
                    int[] parsedEffort = AuditFixStatistics.parseEffort(effortStr);
                    this.effortHours += parsedEffort[0];
                    this.effortMinutes += parsedEffort[1];
                }
            }
        }

        public int getTotalCheckpointsCount() {
            return this.totalCheckpointsCount;
        }

        public int getFailedCheckpointsCount() {
            return this.failedCheckpointsCount;
        }

        public int getDefects() {
            return this.defects;
        }

        public int getEffortHours() {
            return this.effortHours;
        }

        public int getEffortMinutes() {
            return this.effortMinutes;
        }

        private static int[] parseEffort(String effortStr) {
            int[] effortHoursMinutes = new int[]{0, 0};
            if (effortStr != null) {
                String hoursStr = null;
                String minsStr = null;
                int indexH = effortStr.lastIndexOf("h");
                int indexM = effortStr.lastIndexOf("m");
                if (indexH >= 0) {
                    hoursStr = effortStr.substring(0, indexH);
                    minsStr = effortStr.substring(indexH + 1, effortStr.length());
                    minsStr = minsStr.trim();
                } else {
                    minsStr = effortStr.substring(0, indexM);
                }
                try {
                    effortHoursMinutes[0] = Integer.parseInt(hoursStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    effortHoursMinutes[1] = Integer.parseInt(minsStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return effortHoursMinutes;
        }
    }
}

