/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.plugins.jobConfigHistory.ConfigInfo;
import hudson.plugins.jobConfigHistory.DeletedFileFilter;
import hudson.plugins.jobConfigHistory.FileNameComparator;
import hudson.plugins.jobConfigHistory.HistoryDescr;
import hudson.plugins.jobConfigHistory.HistoryDescrToConfigInfo;
import hudson.plugins.jobConfigHistory.OverviewHistoryDao;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

final class ConfigInfoCollector {
    private final List<ConfigInfo> configs = new ArrayList<ConfigInfo>();
    private final String type;
    private final OverviewHistoryDao overViewhistoryDao;

    public ConfigInfoCollector(String type, OverviewHistoryDao overviewHistoryDao) {
        this.type = type;
        this.overViewhistoryDao = overviewHistoryDao;
    }

    void getConfigsForType(File itemDir, String folderName) throws IOException {
        boolean isNotADeletedJob;
        String itemName = folderName.isEmpty() ? itemDir.getName() : folderName + "/jobs/" + itemDir.getName();
        ArrayList<HistoryDescr> historyEntries = new ArrayList<HistoryDescr>(this.overViewhistoryDao.getJobHistory(itemName).values());
        if (historyEntries.isEmpty()) {
            return;
        }
        boolean isADeletedJob = DeletedFileFilter.accepts(itemName);
        boolean bl = isNotADeletedJob = !isADeletedJob;
        if ("created".equals(this.type)) {
            if (isADeletedJob) {
                return;
            }
            HistoryDescr histDescr = (HistoryDescr)historyEntries.get(0);
            if ("Created".equals(histDescr.getOperation())) {
                ConfigInfo config = ConfigInfo.create(itemName, true, histDescr, true);
                this.configs.add(config);
            } else {
                histDescr = (HistoryDescr)historyEntries.get(1);
                if ("Created".equals(histDescr.getOperation())) {
                    ConfigInfo config = ConfigInfo.create(itemName, true, histDescr, true);
                    this.configs.add(config);
                }
            }
        } else if ("deleted".equals(this.type)) {
            HistoryDescr histDescr = (HistoryDescr)historyEntries.get(historyEntries.size() - 1);
            if ("Deleted".equals(histDescr.getOperation())) {
                ConfigInfo config = ConfigInfo.create(itemName, false, histDescr, false);
                this.configs.add(config);
            }
        } else {
            this.configs.addAll(HistoryDescrToConfigInfo.convert(itemName, true, historyEntries, isNotADeletedJob));
        }
    }

    public List<ConfigInfo> collect(String folderName) throws IOException {
        File[] itemDirs = "deleted".equals(this.type) ? this.overViewhistoryDao.getDeletedJobs(folderName) : (File[])ArrayUtils.addAll((Object[])this.overViewhistoryDao.getDeletedJobs(folderName), (Object[])this.overViewhistoryDao.getJobs(folderName));
        Arrays.sort(itemDirs, FileNameComparator.INSTANCE);
        for (File itemDir : itemDirs) {
            this.getConfigsForType(itemDir, folderName);
        }
        return this.configs;
    }
}

