/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.XmlFile;
import hudson.maven.MavenModule;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.plugins.jobConfigHistory.ConfigInfo;
import hudson.plugins.jobConfigHistory.HistoryDao;
import hudson.plugins.jobConfigHistory.HistoryDescr;
import hudson.plugins.jobConfigHistory.JobConfigHistoryBaseAction;
import hudson.plugins.jobConfigHistory.ParsedDateComparator;
import hudson.plugins.jobConfigHistory.PluginUtils;
import hudson.plugins.jobConfigHistory.SideBySideView;
import hudson.security.AccessControlled;
import hudson.util.MultipartFormDataParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class JobConfigHistoryProjectAction
extends JobConfigHistoryBaseAction {
    private final transient AbstractItem project;

    public JobConfigHistoryProjectAction(AbstractItem project) {
        this.project = project;
    }

    JobConfigHistoryProjectAction(Hudson hudson, AbstractItem project) {
        super(hudson);
        this.project = project;
    }

    public final String getIconFileName() {
        if (!this.hasConfigurePermission()) {
            return null;
        }
        if (!this.getPlugin().getSaveModuleConfiguration() && this.project instanceof MavenModule) {
            return null;
        }
        return "/plugin/jobConfigHistory/img/confighistory.png";
    }

    public final List<ConfigInfo> getJobConfigs() throws IOException {
        this.checkConfigurePermission();
        ArrayList<ConfigInfo> configs = new ArrayList<ConfigInfo>();
        ArrayList<HistoryDescr> values = new ArrayList<HistoryDescr>(this.getHistoryDao().getRevisions(this.project.getConfigFile()).values());
        for (HistoryDescr historyDescr : values) {
            String timestamp = historyDescr.getTimestamp();
            XmlFile oldRevision = this.getHistoryDao().getOldRevision(this.project, timestamp);
            if (oldRevision.getFile() != null) {
                configs.add(ConfigInfo.create(this.project.getFullName(), true, historyDescr, true));
                continue;
            }
            if (!"Deleted".equals(historyDescr.getOperation())) continue;
            configs.add(ConfigInfo.create(this.project.getFullName(), false, historyDescr, true));
        }
        Collections.sort(configs, ParsedDateComparator.DESCENDING);
        return configs;
    }

    public final String getFile() throws IOException {
        this.checkConfigurePermission();
        String timestamp = this.getRequestParameter("timestamp");
        XmlFile xmlFile = this.getOldConfigXml(timestamp);
        return xmlFile.asString();
    }

    public final AbstractItem getProject() {
        return this.project;
    }

    @Override
    protected AccessControlled getAccessControlledObject() {
        return this.project;
    }

    @Override
    protected void checkConfigurePermission() {
        this.getAccessControlledObject().checkPermission(AbstractProject.CONFIGURE);
    }

    @Override
    public boolean hasConfigurePermission() {
        return this.getAccessControlledObject().hasPermission(AbstractProject.CONFIGURE);
    }

    public final void doDiffFiles(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        MultipartFormDataParser parser = new MultipartFormDataParser((HttpServletRequest)req);
        rsp.sendRedirect("showDiffFiles?timestamp1=" + parser.get("timestamp1") + "&timestamp2=" + parser.get("timestamp2"));
    }

    public final List<SideBySideView.Line> getLines() throws IOException {
        this.checkConfigurePermission();
        String timestamp1 = this.getRequestParameter("timestamp1");
        String timestamp2 = this.getRequestParameter("timestamp2");
        XmlFile configXml1 = this.getOldConfigXml(timestamp1);
        String[] configXml1Lines = configXml1.asString().split("\\n");
        XmlFile configXml2 = this.getOldConfigXml(timestamp2);
        String[] configXml2Lines = configXml2.asString().split("\\n");
        String diffAsString = this.getDiffAsString(configXml1.getFile(), configXml2.getFile(), configXml1Lines, configXml2Lines);
        List<String> diffLines = Arrays.asList(diffAsString.split("\n"));
        return this.getDiffLines(diffLines);
    }

    private XmlFile getOldConfigXml(String timestamp) {
        this.checkConfigurePermission();
        XmlFile oldRevision = this.getHistoryDao().getOldRevision(this.project, timestamp);
        if (oldRevision.getFile() != null) {
            return oldRevision;
        }
        throw new IllegalArgumentException("Non existent timestamp " + timestamp);
    }

    public final void doRestore(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.checkConfigurePermission();
        String timestamp = req.getParameter("timestamp");
        XmlFile xmlFile = this.getHistoryDao().getOldRevision(this.project, timestamp);
        ByteArrayInputStream is = new ByteArrayInputStream(xmlFile.asString().getBytes("UTF-8"));
        this.project.updateByXml((Source)new StreamSource(is));
        this.project.save();
        rsp.sendRedirect(this.getHudson().getRootUrl() + this.project.getUrl());
    }

    public final void doForwardToRestoreQuestion(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String timestamp = req.getParameter("timestamp");
        rsp.sendRedirect("restoreQuestion?timestamp=" + timestamp);
    }

    @Override
    HistoryDao getHistoryDao() {
        return PluginUtils.getHistoryDao();
    }
}

