/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import bmsi.util.Diff;
import bmsi.util.DiffPrint;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.plugins.jobConfigHistory.GetDiffLines;
import hudson.plugins.jobConfigHistory.HistoryDao;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import hudson.plugins.jobConfigHistory.Messages;
import hudson.plugins.jobConfigHistory.PluginUtils;
import hudson.plugins.jobConfigHistory.SideBySideView;
import hudson.security.AccessControlled;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public abstract class JobConfigHistoryBaseAction
implements Action {
    private final Hudson hudson;

    public JobConfigHistoryBaseAction() {
        this.hudson = Hudson.getInstance();
    }

    JobConfigHistoryBaseAction(Hudson hudson) {
        this.hudson = hudson;
    }

    public final String getDisplayName() {
        return Messages.displayName();
    }

    public String getUrlName() {
        return "jobConfigHistory";
    }

    public final String getOutputType() {
        if ("xml".equalsIgnoreCase(this.getRequestParameter("type"))) {
            return "xml";
        }
        return "plain";
    }

    protected boolean checkTimestamp(String timestamp) {
        if (timestamp == null || "null".equals(timestamp)) {
            return false;
        }
        PluginUtils.parsedDate(timestamp);
        return true;
    }

    protected String getRequestParameter(String parameterName) {
        return this.getCurrentRequest().getParameter(parameterName);
    }

    protected abstract void checkConfigurePermission();

    protected abstract boolean hasConfigurePermission();

    protected Hudson getHudson() {
        return this.hudson;
    }

    protected abstract AccessControlled getAccessControlledObject();

    public final List<SideBySideView.Line> getDiffLines(List<String> diffLines) throws IOException {
        return new GetDiffLines(diffLines).get();
    }

    protected final String getDiffAsString(File file1, File file2, String[] file1Lines, String[] file2Lines) {
        Diff.change change2 = new Diff(file1Lines, file2Lines).diff_2(false);
        DiffPrint.UnifiedPrint unifiedPrint = new DiffPrint.UnifiedPrint(file1Lines, file2Lines);
        StringWriter output = new StringWriter();
        unifiedPrint.setOutput(output);
        unifiedPrint.print_header(file1.getPath(), file2.getPath());
        unifiedPrint.print_script(change2);
        return output.toString();
    }

    StaplerRequest getCurrentRequest() {
        return Stapler.getCurrentRequest();
    }

    JobConfigHistory getPlugin() {
        return PluginUtils.getPlugin();
    }

    HistoryDao getHistoryDao() {
        return PluginUtils.getHistoryDao();
    }
}

