/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildBadgeAction;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.jobConfigHistory.FileHistoryDao;
import hudson.plugins.jobConfigHistory.HistoryDao;
import hudson.plugins.jobConfigHistory.HistoryDescr;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import hudson.plugins.jobConfigHistory.Messages;
import hudson.plugins.jobConfigHistory.ParsedDateComparator;
import hudson.plugins.jobConfigHistory.PluginUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import jenkins.model.RunAction2;

public class JobConfigBadgeAction
implements BuildBadgeAction,
RunAction2 {
    private String[] configDates;
    private transient AbstractBuild build;

    JobConfigBadgeAction(String[] configDates) {
        this.configDates = (String[])configDates.clone();
        this.build = null;
    }

    public void onAttached(Run<?, ?> r) {
        this.build = (AbstractBuild)r;
    }

    public void onLoad(Run<?, ?> r) {
        this.build = (AbstractBuild)r;
    }

    public boolean showBadge() {
        return this.getPlugin().showBuildBadges(this.build.getProject());
    }

    public boolean oldConfigsExist() {
        HistoryDao historyDao = this.getHistoryDao();
        AbstractProject project = this.build.getProject();
        for (String timestamp : this.configDates) {
            if (historyDao.hasOldRevision((AbstractItem)project, timestamp)) continue;
            return false;
        }
        return true;
    }

    public String createLink() {
        return this.getRootUrl() + this.build.getProject().getUrl() + "jobConfigHistory" + "/showDiffFiles?timestamp1=" + this.configDates[1] + "&timestamp2=" + this.configDates[0];
    }

    String getRootUrl() {
        return Hudson.getInstance().getRootUrl();
    }

    public String getTooltip() {
        return Messages.JobConfigBadgeAction_ToolTip();
    }

    public String getIcon() {
        return "/plugin/jobConfigHistory/img/buildbadge.png";
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "";
    }

    JobConfigHistory getPlugin() {
        return PluginUtils.getPlugin();
    }

    HistoryDao getHistoryDao() {
        return PluginUtils.getHistoryDao();
    }

    @Extension
    public static class Listener
    extends RunListener<AbstractBuild> {
        public void onStarted(AbstractBuild build, TaskListener listener) {
            List<HistoryDescr> historyDescriptions;
            AbstractProject project = build.getProject();
            if (project.getNextBuildNumber() <= 2) {
                super.onStarted((Run)build, listener);
                return;
            }
            Date lastBuildDate = null;
            if (project.getLastBuild().getPreviousBuild() != null) {
                lastBuildDate = project.getLastBuild().getPreviousBuild().getTime();
            }
            if ((historyDescriptions = this.getRevisions(project)).size() > 1) {
                Collections.sort(historyDescriptions, ParsedDateComparator.DESCENDING);
                HistoryDescr lastChange = (HistoryDescr)Collections.min(historyDescriptions, ParsedDateComparator.DESCENDING);
                Date lastConfigChange = lastChange.parsedDate();
                if (lastBuildDate != null && lastConfigChange.after(lastBuildDate)) {
                    String[] dates = new String[]{lastChange.getTimestamp(), this.findLastRelevantConfigChangeDate(historyDescriptions, lastBuildDate)};
                    build.addAction((Action)new JobConfigBadgeAction(dates));
                }
            }
            super.onStarted((Run)build, listener);
        }

        List<HistoryDescr> getRevisions(AbstractProject<?, ?> project) {
            FileHistoryDao historyDao = PluginUtils.getHistoryDao();
            ArrayList<HistoryDescr> historyDescriptions = new ArrayList<HistoryDescr>(historyDao.getRevisions(project.getConfigFile()).values());
            return historyDescriptions;
        }

        private String findLastRelevantConfigChangeDate(List<HistoryDescr> historyDescriptions, Date lastBuildDate) {
            for (HistoryDescr oldConfigChange : historyDescriptions.subList(1, historyDescriptions.size())) {
                Date changeDate = oldConfigChange.parsedDate();
                if (changeDate == null || !changeDate.before(lastBuildDate)) continue;
                return oldConfigChange.getTimestamp();
            }
            return historyDescriptions.get(1).getTimestamp();
        }
    }
}

