/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.PeriodicWork;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

@Extension
public class JobConfigHistoryPurger
extends PeriodicWork {
    private static final Logger LOG = Logger.getLogger(JobConfigHistoryPurger.class.getName());
    private final JobConfigHistory plugin = (JobConfigHistory)Hudson.getInstance().getPlugin(JobConfigHistory.class);
    private int maxAge;

    public long getRecurrencePeriod() {
        return 86400000L;
    }

    protected void doRun() throws Exception {
        String maxAgeString = this.plugin.getMaxDaysToKeepEntries();
        int maxAge = 0;
        if (StringUtils.isNotEmpty((String)maxAgeString)) {
            try {
                maxAge = Integer.parseInt(maxAgeString);
                if (maxAge < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                LOG.warning("maximum age of history entries not formatted properly, unable to purge: " + maxAgeString);
            }
        }
        if (maxAge > 0) {
            LOG.fine("checking for history files to purge (max age of " + maxAge + " days allowed)");
            this.maxAge = maxAge;
            this.purgeHistoryByAge();
        }
    }

    private void purgeHistoryByAge() {
        this.purgeSystemOrJobHistory(this.plugin.getConfiguredHistoryRootDir().listFiles());
        this.purgeSystemOrJobHistory(this.plugin.getJobHistoryRootDir().listFiles());
    }

    private void purgeSystemOrJobHistory(File[] itemDirs) {
        if (itemDirs != null && itemDirs.length > 0) {
            for (File itemDir : itemDirs) {
                Object[] historyDirs = itemDir.listFiles(JobConfigHistory.HISTORY_FILTER);
                if (historyDirs == null) continue;
                Arrays.sort(historyDirs);
                for (Object historyDir : historyDirs) {
                    if (!this.isTooOld((File)historyDir)) break;
                    LOG.finest("Should delete: " + historyDir);
                    this.deleteDirectory((File)historyDir);
                }
            }
        }
    }

    private boolean isTooOld(File historyDir) {
        Date parsedDate = null;
        SimpleDateFormat dateParser = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        try {
            parsedDate = dateParser.parse(historyDir.getName());
        }
        catch (ParseException ex) {
            LOG.warning("Unable to parse Date: " + ex);
        }
        GregorianCalendar historyDate = new GregorianCalendar();
        if (parsedDate != null) {
            historyDate.setTime(parsedDate);
            GregorianCalendar oldestAllowedDate = new GregorianCalendar();
            ((Calendar)oldestAllowedDate).add(6, -this.maxAge);
            if (historyDate.before(oldestAllowedDate)) {
                return true;
            }
        }
        return false;
    }

    private void deleteDirectory(File dir) {
        for (File file : dir.listFiles()) {
            if (file.delete()) continue;
            LOG.warning("problem deleting history file: " + file);
        }
        if (!dir.delete()) {
            LOG.warning("problem deleting history directory: " + dir);
        }
    }
}

