/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.Extension;
import hudson.FilePath;
import hudson.XmlFile;
import hudson.maven.MavenModule;
import hudson.model.AbstractItem;
import hudson.model.Item;
import hudson.model.Node;
import hudson.plugins.jobConfigHistory.DeletedFileFilter;
import hudson.plugins.jobConfigHistory.HistoryDescr;
import hudson.plugins.jobConfigHistory.HistoryFileFilter;
import hudson.plugins.jobConfigHistory.JobConfigHistoryStrategy;
import hudson.plugins.jobConfigHistory.LazyHistoryDescr;
import hudson.plugins.jobConfigHistory.Messages;
import hudson.plugins.jobConfigHistory.MimickedUser;
import hudson.plugins.jobConfigHistory.NonDeletedFileFilter;
import hudson.plugins.jobConfigHistory.NonJobsDirectoryFileFilter;
import hudson.plugins.jobConfigHistory.PluginUtils;
import hudson.plugins.jobConfigHistory.Purgeable;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Extension
public class FileHistoryDao
extends JobConfigHistoryStrategy
implements Purgeable {
    private static final Logger LOG = Logger.getLogger(FileHistoryDao.class.getName());
    private static final int CLASH_SLEEP_TIME = 500;
    private final File historyRootDir;
    private final File jenkinsHome;
    private final MimickedUser currentUser;
    private final int maxHistoryEntries;
    private final boolean saveDuplicates;

    public FileHistoryDao() {
        this(null, null, null, 0, false);
    }

    public FileHistoryDao(File historyRootDir, File jenkinsHome, MimickedUser currentUser, int maxHistoryEntries, boolean saveDuplicates) {
        this.historyRootDir = historyRootDir;
        this.jenkinsHome = jenkinsHome;
        this.currentUser = currentUser;
        this.maxHistoryEntries = maxHistoryEntries;
        this.saveDuplicates = saveDuplicates;
    }

    static void copyConfigFile(File currentConfig, File timestampedDir) throws FileNotFoundException, IOException {
        try (BufferedOutputStream configCopy = new BufferedOutputStream(new FileOutputStream(new File(timestampedDir, currentConfig.getName())));
             FileInputStream configOriginal = new FileInputStream(currentConfig);){
            IOUtils.copy((InputStream)configOriginal, (OutputStream)configCopy);
        }
    }

    static SimpleDateFormat getIdFormatter() {
        return new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    }

    static File createNewHistoryDir(File itemHistoryDir, AtomicReference<Calendar> timestampHolder) throws IOException {
        File f;
        GregorianCalendar timestamp;
        while (true) {
            timestamp = new GregorianCalendar();
            f = new File(itemHistoryDir, FileHistoryDao.getIdFormatter().format(timestamp.getTime()));
            if (!f.isDirectory()) break;
            LOG.log(Level.FINE, "clash on {0}, will wait a moment", f);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException x) {
                throw new RuntimeException(x);
            }
        }
        timestampHolder.set(timestamp);
        File jenkinsRootDir = Jenkins.get().getRootDir();
        boolean hasWritePermission = false;
        File firstExistingFile = null;
        boolean foundfirstExistingFile = false;
        for (File currentFile = f; currentFile != null && !currentFile.equals(jenkinsRootDir.getParentFile()); currentFile = currentFile.getParentFile()) {
            if (!currentFile.exists() || foundfirstExistingFile) continue;
            foundfirstExistingFile = true;
            hasWritePermission = currentFile.canWrite();
            firstExistingFile = currentFile;
        }
        if (!hasWritePermission) {
            String msg = "Could not create history entry's root directory \"" + f + "\": no write rights on \"" + firstExistingFile + "\".";
            LOG.log(Level.WARNING, msg);
            throw new IOException(msg);
        }
        if (!f.mkdirs() && !f.exists()) {
            throw new RuntimeException("Could not create rootDir " + f);
        }
        return f;
    }

    public static File getConfigFile(File historyDir) {
        File configFile = null;
        if (HistoryFileFilter.accepts(historyDir)) {
            try {
                File[] listing;
                for (File file : listing = historyDir.listFiles()) {
                    if (file.getName().equals("history.xml") || !file.getName().matches(".*\\.xml$")) continue;
                    configFile = file;
                }
            }
            catch (NullPointerException e) {
                LOG.log(Level.WARNING, "History dir is null. ", e);
            }
        }
        return configFile;
    }

    File getRootDir(XmlFile xmlFile, AtomicReference<Calendar> timestampHolder) throws IOException {
        File configFile = xmlFile.getFile();
        File itemHistoryDir = this.getHistoryDir(configFile);
        this.purgeOldEntries(itemHistoryDir, this.maxHistoryEntries);
        return FileHistoryDao.createNewHistoryDir(itemHistoryDir, timestampHolder);
    }

    void createHistoryXmlFile(Calendar timestamp, File timestampedDir, String operation, String newName, String oldName, String changeReasonComment) throws IOException {
        oldName = oldName == null ? "" : oldName;
        String user = this.currentUser != null ? this.currentUser.getFullName() : "unknown";
        String userId = this.currentUser != null ? this.currentUser.getId() : "unknown";
        XmlFile historyDescription = this.getHistoryXmlFile(timestampedDir);
        HistoryDescr myDescr = new HistoryDescr(user, userId, operation, FileHistoryDao.getIdFormatter().format(timestamp.getTime()), newName == null ? "" : newName, newName == null ? "" : (newName.equals(oldName) ? "" : oldName), changeReasonComment);
        historyDescription.write((Object)myDescr);
    }

    private XmlFile getHistoryXmlFile(File directory) {
        return new XmlFile(new File(directory, "history.xml"));
    }

    @Override
    public void createNewItem(Item item) {
        AbstractItem aItem = (AbstractItem)item;
        this.createNewHistoryEntryAndCopyConfig(aItem.getConfigFile(), Messages.ConfigHistoryListenerHelper_CREATED(), null, null, Optional.empty());
    }

    private void createNewHistoryEntryAndCopyConfig(XmlFile configFile, String operation, String newName, String oldName, Optional<String> changeReasonCommentOptional) {
        File timestampedDir = this.createNewHistoryEntry(configFile, operation, newName, oldName, (String)changeReasonCommentOptional.orElse(null));
        try {
            FileHistoryDao.copyConfigFile(configFile.getFile(), timestampedDir);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to copy " + configFile, ex);
        }
    }

    private Optional<String> removeChangeReasonComment(XmlFile configFile) throws IOException, SAXException, TransformerException, ParserConfigurationException {
        Document configFiledocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(configFile.getFile());
        NodeList jobLocalConfigurationNodes = configFiledocument.getElementsByTagName("hudson.plugins.jobConfigHistory.JobLocalConfiguration");
        if (jobLocalConfigurationNodes.getLength() > 1) {
            LOG.log(Level.FINEST, "tag \"{0}\" found twice in {1}, not saving the change reason comment.", new Object[]{"hudson.plugins.jobConfigHistory.JobLocalConfiguration", configFile.getFile()});
            return Optional.empty();
        }
        if (jobLocalConfigurationNodes.getLength() == 1) {
            org.w3c.dom.Node jobLocalConfiguration = jobLocalConfigurationNodes.item(0);
            NodeList jlcChildren = jobLocalConfiguration.getChildNodes();
            org.w3c.dom.Node changeReasonCommentNode = null;
            for (int i = 0; i < jlcChildren.getLength(); ++i) {
                org.w3c.dom.Node node = jlcChildren.item(i);
                if (!node.getNodeName().equals("changeReasonComment")) continue;
                changeReasonCommentNode = node;
            }
            if (changeReasonCommentNode != null) {
                String changeReasonComment = changeReasonCommentNode.getTextContent();
                if (changeReasonComment != null) {
                    jobLocalConfiguration.getParentNode().removeChild(jobLocalConfiguration);
                    TransformerFactory.newInstance().newTransformer().transform(new DOMSource(configFiledocument), new StreamResult(configFile.getFile()));
                    return changeReasonComment.isEmpty() ? Optional.empty() : Optional.of(changeReasonComment);
                }
                return Optional.empty();
            }
            return Optional.empty();
        }
        LOG.log(Level.FINEST, "tag \"{0}\" not found in {1}, no comment could be found.", new Object[]{"hudson.plugins.jobConfigHistory.JobLocalConfiguration", configFile.getFile()});
        return Optional.empty();
    }

    @Override
    public void saveItem(XmlFile file) {
        Optional<String> changeReasonCommentOptional;
        try {
            changeReasonCommentOptional = this.removeChangeReasonComment(file);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            LOG.log(Level.WARNING, "Error occurred while trying to extract changeReasonComment from config file: {0}", e);
            changeReasonCommentOptional = Optional.empty();
        }
        if (this.checkDuplicate(file)) {
            this.createNewHistoryEntryAndCopyConfig(file, Messages.ConfigHistoryListenerHelper_CHANGED(), null, null, changeReasonCommentOptional);
        }
    }

    @Override
    public void deleteItem(Item item) {
        AbstractItem aItem = (AbstractItem)item;
        this.createNewHistoryEntry(aItem.getConfigFile(), Messages.ConfigHistoryListenerHelper_DELETED(), null, null, null);
        File configFile = aItem.getConfigFile().getFile();
        File currentHistoryDir = this.getHistoryDir(configFile);
        SimpleDateFormat buildDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
        String timestamp = buildDateFormat.format(new Date());
        String deletedHistoryName = item.getName() + "_deleted_" + timestamp;
        File deletedHistoryDir = new File(currentHistoryDir.getParentFile(), deletedHistoryName);
        if (!currentHistoryDir.renameTo(deletedHistoryDir)) {
            LOG.log(Level.WARNING, "unable to rename deleted history dir to: {0}", deletedHistoryDir);
        }
    }

    private File getHistoryDir(Item item) {
        return new File(this.getHistoryDir(item.getRootDir()), item.getName());
    }

    @Override
    public void changeItemLocation(Item item, String oldFullName, String newFullName) {
        String onLocationChangedDescription = "old full name: " + oldFullName + ", new full name: " + newFullName;
        if (this.historyRootDir != null) {
            File newHistoryDir = this.getHistoryDir(item);
            String jobsStr = SystemUtils.IS_OS_UNIX ? "/jobs/" : "\\jobs\\";
            File oldHistoryDir = new File(newHistoryDir.getAbsolutePath().replaceFirst(newFullName.replaceAll("/", jobsStr), oldFullName.replaceAll("/", jobsStr)));
            if (oldHistoryDir.exists()) {
                FilePath newHistoryFilePath = new FilePath(newHistoryDir);
                FilePath oldHistoryFilePath = new FilePath(oldHistoryDir);
                try {
                    oldHistoryFilePath.copyRecursiveTo(newHistoryFilePath);
                    oldHistoryFilePath.deleteRecursive();
                    LOG.log(Level.FINEST, "completed move of old history files on location change {0}{1}", onLocationChangedDescription);
                }
                catch (IOException e) {
                    String ioExceptionStr = "unable to move old history on location change." + onLocationChangedDescription;
                    LOG.log(Level.SEVERE, ioExceptionStr, e);
                }
                catch (InterruptedException e) {
                    String irExceptionStr = "interrupted while moving old history on location change." + onLocationChangedDescription;
                    LOG.log(Level.WARNING, irExceptionStr, e);
                }
            }
        }
    }

    @Override
    public void renameItem(Item item, String oldName, String newName) {
        File configFile;
        File currentHistoryDir;
        File historyParentDir;
        File oldHistoryDir;
        AbstractItem aItem = (AbstractItem)item;
        String onRenameDesc = " old name: " + oldName + ", new name: " + newName;
        if (this.historyRootDir != null && (oldHistoryDir = new File(historyParentDir = (currentHistoryDir = this.getHistoryDir(configFile = aItem.getConfigFile().getFile())).getParentFile(), oldName)).exists()) {
            FilePath fp = new FilePath(oldHistoryDir);
            try {
                fp.copyRecursiveTo(new FilePath(currentHistoryDir));
                fp.deleteRecursive();
                LOG.log(Level.FINEST, "completed move of old history files on rename.{0}", onRenameDesc);
            }
            catch (IOException e) {
                String ioExceptionStr = "unable to move old history on rename." + onRenameDesc;
                LOG.log(Level.SEVERE, ioExceptionStr, e);
            }
            catch (InterruptedException e) {
                String irExceptionStr = "interrupted while moving old history on rename." + onRenameDesc;
                LOG.log(Level.WARNING, irExceptionStr, e);
            }
        }
        this.createNewHistoryEntryAndCopyConfig(aItem.getConfigFile(), Messages.ConfigHistoryListenerHelper_RENAMED(), newName, oldName, Optional.empty());
    }

    @Override
    public SortedMap<String, HistoryDescr> getRevisions(XmlFile xmlFile) {
        return this.getRevisions(xmlFile.getFile());
    }

    private SortedMap<String, HistoryDescr> getRevisions(File configFile) {
        File historiesDir = this.getHistoryDir(configFile);
        return this.getRevisions(historiesDir, configFile);
    }

    private SortedMap<String, HistoryDescr> getRevisions(File historiesDir, File configFile) {
        File[] historyDirsOfItem = historiesDir.listFiles(HistoryFileFilter.INSTANCE);
        TreeMap<String, HistoryDescr> map = new TreeMap<String, HistoryDescr>();
        if (historyDirsOfItem == null) {
            return map;
        }
        for (File historyDir : historyDirsOfItem) {
            XmlFile historyXml = this.getHistoryXmlFile(historyDir);
            LazyHistoryDescr historyDescription = new LazyHistoryDescr(historyXml);
            map.put(historyDir.getName(), historyDescription);
        }
        return map;
    }

    @Override
    public int getRevisionAmount(XmlFile xmlFile) {
        File configFile = xmlFile.getFile();
        File historiesDir = this.getHistoryDir(configFile);
        File[] historyDirsOfItem = historiesDir.listFiles(HistoryFileFilter.INSTANCE);
        if (historyDirsOfItem == null) {
            LOG.log(Level.WARNING, "Error occurred while trying to calculate the current revision amount: {0}.listFiles(..) returned null.", historiesDir);
        }
        return historyDirsOfItem != null ? historyDirsOfItem.length : -1;
    }

    @Override
    public int getSystemRevisionAmount(String sysConfigName) {
        return this.getSystemHistory(sysConfigName).size();
    }

    @Override
    public int getSystemRevisionAmount() {
        return this.countSubDirs(this.getSystemConfigs());
    }

    @Override
    public int getJobRevisionAmount() {
        return this.countSubDirs(this.getJobs()) + this.getDeletedJobAmount();
    }

    @Override
    public int getDeletedJobAmount() {
        return this.getDeletedJobs().length;
    }

    @Override
    public int getJobRevisionAmount(String jobName) {
        return this.getJobHistory(jobName).size();
    }

    @Override
    public int getTotalRevisionAmount() {
        return this.getJobRevisionAmount() + this.getSystemRevisionAmount();
    }

    private int countSubDirs(File[] files) {
        return Arrays.stream(files).map(file -> file.listFiles(HistoryFileFilter.INSTANCE).length).reduce(Integer::sum).orElse(0);
    }

    @Override
    public XmlFile getOldRevision(AbstractItem item, String identifier) {
        File configFile = item.getConfigFile().getFile();
        File historyDir = new File(this.getHistoryDir(configFile), identifier);
        if (PluginUtils.isMavenPluginAvailable() && item instanceof MavenModule) {
            String path = historyDir + ((MavenModule)item).getParent().getFullName().replace("/", "/jobs/") + "/modules/" + ((MavenModule)item).getModuleName().toFileSystemName() + "/" + identifier;
            return new XmlFile(FileHistoryDao.getConfigFile(new File(path)));
        }
        return new XmlFile(FileHistoryDao.getConfigFile(historyDir));
    }

    @Override
    public XmlFile getOldRevision(XmlFile xmlFile, String identifier) {
        File configFile = xmlFile.getFile();
        return this.getOldRevision(configFile, identifier);
    }

    private XmlFile getOldRevision(File configFile, String identifier) {
        File historyDir = new File(this.getHistoryDir(configFile), identifier);
        return new XmlFile(FileHistoryDao.getConfigFile(historyDir));
    }

    @Override
    public XmlFile getOldRevision(String configFileName, String identifier) {
        File historyDir = new File(new File(this.historyRootDir, configFileName), identifier);
        File configFile = FileHistoryDao.getConfigFile(historyDir);
        if (configFile == null) {
            throw new IllegalArgumentException("Could not find " + historyDir);
        }
        return new XmlFile(configFile);
    }

    @Override
    public void deleteRevision(AbstractItem abstractItem, String identifier) {
        File configFile = abstractItem.getConfigFile().getFile();
        File currentHistoryDir = this.getHistoryDir(configFile);
        try {
            File timestampDir = this.getSubDirectory(currentHistoryDir, identifier);
            try {
                FileUtils.deleteDirectory((File)timestampDir);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "unable to delete revision {0}: {1}", new Object[]{identifier, e.getMessage()});
            }
        }
        catch (FileNotFoundException e) {
            LOG.log(Level.WARNING, "unable to delete revision {0}: file not found.", identifier);
        }
        LOG.log(Level.FINEST, "{0} 's revision {1} deleted.", new Object[]{abstractItem.getFullName(), identifier});
    }

    @Override
    public void deleteRevision(Node node, String identifier) {
        File timestampDir = this.getOldRevision(node, identifier).getFile().getParentFile();
        try {
            FileUtils.deleteDirectory((File)timestampDir);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "unable to delete revision {0}: {1}", new Object[]{identifier, e.getMessage()});
        }
        LOG.log(Level.FINEST, "{0} 's revision {1} deleted.", new Object[]{node.getDisplayName(), identifier});
    }

    @Override
    public void deleteRevision(File historyDir, String identifier) {
        try {
            File timestampDir = this.getSubDirectory(historyDir, identifier);
            try {
                FileUtils.deleteDirectory((File)timestampDir);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "unable to delete revision {0}: {1}", new Object[]{identifier, e.getMessage()});
            }
        }
        catch (FileNotFoundException e) {
            LOG.log(Level.WARNING, "unable to delete revision {0}: file not found.", identifier);
        }
        LOG.log(Level.FINEST, "{0} 's revision {1} deleted.", new Object[]{historyDir.getName(), identifier});
    }

    @Override
    public boolean revisionEqualsCurrent(AbstractItem project, String identifier1) {
        try {
            return FileUtils.contentEquals((File)FileHistoryDao.getConfigFile(this.getSubDirectory(this.getHistoryDir((Item)project), identifier1)), (File)project.getConfigFile().getFile());
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, " could not access config file while trying to check revision equality.");
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean revisionEqualsCurrent(Node node, String identifier1) {
        String currentContent = Jenkins.XSTREAM2.toXML((Object)node);
        try {
            return StringUtils.equals((String)FileUtils.readFileToString((File)this.getOldRevision(node, identifier1).getFile(), (String)"UTF-8"), (String)currentContent);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, " could not access config file while trying to check revision equality.");
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean hasOldRevision(XmlFile xmlFile, String identifier) {
        File configFile = xmlFile.getFile();
        XmlFile oldRevision = this.getOldRevision(configFile, identifier);
        return oldRevision.getFile() != null && oldRevision.getFile().exists();
    }

    public File getHistoryDir(File configFile) {
        File historyDir;
        String jenkinsRootDir;
        String configRootDir = configFile.getParent();
        if (!configRootDir.startsWith(jenkinsRootDir = this.jenkinsHome.getPath())) {
            throw new IllegalArgumentException("Trying to get history dir for object outside of Jenkins: " + configFile);
        }
        String underRootDir = null;
        if (configRootDir.equals(jenkinsRootDir)) {
            String fileName = configFile.getName();
            underRootDir = fileName.substring(0, fileName.lastIndexOf(46));
        }
        if (underRootDir == null) {
            String remainingPath = configRootDir.substring(jenkinsRootDir.length() + "jobs".length() + 1);
            historyDir = new File(this.getJobHistoryRootDir(), remainingPath);
        } else {
            historyDir = new File(this.historyRootDir, underRootDir);
        }
        return historyDir;
    }

    File getJobHistoryRootDir() {
        return new File(this.historyRootDir, "/jobs");
    }

    @Override
    public void purgeOldEntries(File itemHistoryRoot, int maxEntries) {
        if (maxEntries > 0) {
            LOG.log(Level.FINE, "checking for history files to purge ({0} max allowed)", maxEntries);
            int entriesToLeave = maxEntries - 1;
            File[] historyDirs = itemHistoryRoot.listFiles(HistoryFileFilter.INSTANCE);
            if (historyDirs != null && historyDirs.length >= entriesToLeave) {
                Arrays.sort(historyDirs, Collections.reverseOrder());
                for (int i = entriesToLeave; i < historyDirs.length; ++i) {
                    if (this.isCreatedEntry(historyDirs[i])) continue;
                    LOG.log(Level.FINE, "purging old directory from history logs: {0}", historyDirs[i]);
                    this.deleteDirectory(historyDirs[i]);
                }
            }
        }
    }

    @Override
    public boolean isCreatedEntry(File historyDir) {
        XmlFile historyXml = this.getHistoryXmlFile(historyDir);
        try {
            HistoryDescr histDescr = (HistoryDescr)historyXml.read();
            LOG.log(Level.FINEST, "historyDir: {0}", historyDir);
            LOG.log(Level.FINEST, "histDescr.getOperation(): {0}", histDescr.getOperation());
            if ("Created".equals(histDescr.getOperation())) {
                return true;
            }
        }
        catch (IOException ex) {
            LOG.log(Level.FINEST, "Unable to retrieve history file for {0}", historyDir);
        }
        return false;
    }

    private void deleteDirectory(File dir) {
        try {
            for (File file : dir.listFiles()) {
                if (file.delete()) continue;
                LOG.log(Level.WARNING, "problem deleting history file: {0}", file);
            }
            if (!dir.delete()) {
                LOG.log(Level.WARNING, "problem deleting history directory: {0}", dir);
            }
        }
        catch (NullPointerException e) {
            LOG.log(Level.WARNING, "Directory already deleted or null. ", e);
        }
    }

    boolean hasDuplicateHistory(XmlFile xmlFile) {
        boolean isDuplicated = false;
        ArrayList<String> timeStamps = new ArrayList<String>(this.getRevisions(xmlFile).keySet());
        if (!timeStamps.isEmpty()) {
            timeStamps.sort(Collections.reverseOrder());
            XmlFile lastRevision = this.getOldRevision(xmlFile, timeStamps.get(0));
            try {
                if (xmlFile.asString().equals(lastRevision.asString())) {
                    isDuplicated = true;
                }
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "unable to check for duplicate previous history file: {0}\n{1}", new Object[]{lastRevision, e});
            }
        }
        return isDuplicated;
    }

    boolean checkDuplicate(XmlFile xmlFile) {
        if (!this.saveDuplicates && this.hasDuplicateHistory(xmlFile)) {
            LOG.log(Level.FINE, "found duplicate history, skipping save of {0}", xmlFile);
            return false;
        }
        return true;
    }

    @Override
    public File[] getDeletedJobs() {
        return this.returnEmptyFileArrayForNull(this.getJobFilesIncludingThoseInFolders(DeletedFileFilter.INSTANCE));
    }

    @Override
    public File[] getDeletedJobs(String folderName) {
        return this.returnEmptyFileArrayForNull(this.getJobDirectoryIncludingFolder(folderName).listFiles(DeletedFileFilter.INSTANCE));
    }

    @Override
    public File[] getJobs() {
        return this.returnEmptyFileArrayForNull(this.getJobFilesIncludingThoseInFolders(NonDeletedFileFilter.INSTANCE));
    }

    @Override
    public File[] getJobs(String folderName) {
        return this.returnEmptyFileArrayForNull(this.getJobDirectoryIncludingFolder(folderName).listFiles(NonDeletedFileFilter.INSTANCE));
    }

    private File getJobDirectoryIncludingFolder(String folderName) {
        String realFolderName = folderName.isEmpty() ? folderName : folderName + "/jobs";
        return new File(this.getJobHistoryRootDir(), realFolderName);
    }

    private File[] getJobFilesIncludingThoseInFolders(FileFilter fileFilter) {
        List<File> folderFiles = this.getJobFilesIncludingThoseInFolders();
        return (File[])folderFiles.stream().filter(fileFilter::accept).toArray(File[]::new);
    }

    private List<File> getJobFilesIncludingThoseInFolders() {
        return this.getJobFilesIncludingThoseInFolders(this.getJobHistoryRootDir());
    }

    private boolean isFolder(File file) {
        boolean hasJobsSubdirectory = false;
        File[] files = file.listFiles();
        if (files == null) {
            return false;
        }
        for (File child : files) {
            if (!child.getName().equals("jobs")) continue;
            hasJobsSubdirectory = true;
            break;
        }
        return file.getParentFile().getName().equals("jobs") && file.isDirectory() && hasJobsSubdirectory;
    }

    private boolean isJobFile(File file) {
        return file.getParentFile().getName().equals("jobs");
    }

    private File getSubDirectory(File file, String subdirectoryName) throws FileNotFoundException {
        FileNotFoundException up = new FileNotFoundException("File " + new File(file, subdirectoryName) + " not found.");
        File[] files = file.listFiles();
        if (files == null) {
            throw up;
        }
        for (File child : files) {
            if (!child.getName().equals(subdirectoryName)) continue;
            return child;
        }
        throw up;
    }

    private List<File> getJobFilesIncludingThoseInFolders(File fromFile) {
        LinkedList<File> folderNames = new LinkedList<File>();
        File[] currentChildren = fromFile.listFiles();
        if (currentChildren == null) {
            return folderNames;
        }
        for (File child : currentChildren) {
            if (this.isFolder(child)) {
                try {
                    folderNames.addAll(this.getJobFilesIncludingThoseInFolders(this.getSubDirectory(child, "jobs")));
                }
                catch (FileNotFoundException e) {
                    LOG.log(Level.SEVERE, "File not found although it should have been found: " + new File(child, "jobs"));
                }
                continue;
            }
            if (!this.isJobFile(child)) continue;
            folderNames.add(child);
        }
        return folderNames;
    }

    @Override
    public File[] getSystemConfigs() {
        return this.returnEmptyFileArrayForNull(this.historyRootDir.listFiles(NonJobsDirectoryFileFilter.INSTANCE));
    }

    @Override
    public SortedMap<String, HistoryDescr> getSystemConfigsMap() {
        File[] systemConfigsArr = this.getSystemConfigs();
        if (systemConfigsArr.length == 0) {
            return Collections.emptySortedMap();
        }
        TreeMap<String, HistoryDescr> map = new TreeMap<String, HistoryDescr>();
        for (File historyDir : systemConfigsArr) {
            XmlFile historyXml = this.getHistoryXmlFile(historyDir);
            LazyHistoryDescr historyDescription = new LazyHistoryDescr(historyXml);
            map.put(historyDir.getName(), historyDescription);
        }
        return map;
    }

    private File[] returnEmptyFileArrayForNull(File[] array) {
        if (array != null) {
            return array;
        }
        return new File[0];
    }

    @Override
    public SortedMap<String, HistoryDescr> getJobHistory(String jobName) {
        return this.getRevisions(new File(this.getJobHistoryRootDir(), jobName), new File(jobName));
    }

    @Override
    public SortedMap<String, HistoryDescr> getSystemHistory(String name) {
        return this.getRevisions(new File(this.historyRootDir, name), new File(name));
    }

    @Deprecated
    public void copyHistoryAndDelete(String oldName, String newName) {
        File oldFile = new File(this.getJobHistoryRootDir(), oldName);
        File newFile = new File(this.getJobHistoryRootDir(), newName);
        try {
            FileUtils.copyDirectory((File)oldFile, (File)newFile);
            FileUtils.deleteDirectory((File)oldFile);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Unable to move from " + oldFile + " to " + newFile, ex);
        }
    }

    @Override
    public void createNewNode(Node node) {
        String content = Jenkins.XSTREAM2.toXML((Object)node);
        this.createNewHistoryEntryAndSaveConfig(node, content, Messages.ConfigHistoryListenerHelper_CREATED(), null, null);
    }

    private void createNewHistoryEntryAndSaveConfig(Node node, String content, String operation, String newName, String oldName) {
        File timestampedDir = this.createNewHistoryEntry(node, operation, newName, oldName, null);
        File nodeConfigHistoryFile = new File(timestampedDir, "config.xml");
        try (PrintStream stream = new PrintStream(nodeConfigHistoryFile, "UTF-8");){
            stream.print(content);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to write " + nodeConfigHistoryFile, ex);
        }
    }

    @Override
    public void deleteNode(Node node) {
        this.createNewHistoryEntry(node, Messages.ConfigHistoryListenerHelper_DELETED(), null, null, null);
        File currentHistoryDir = this.getHistoryDirForNode(node);
        SimpleDateFormat buildDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
        String timestamp = buildDateFormat.format(new Date());
        String deletedHistoryName = node.getNodeName() + "_deleted_" + timestamp;
        File deletedHistoryDir = new File(currentHistoryDir.getParentFile(), deletedHistoryName);
        if (!currentHistoryDir.renameTo(deletedHistoryDir)) {
            LOG.log(Level.WARNING, "unable to rename deleted history dir to: {0}", deletedHistoryDir);
        }
    }

    @Override
    public void renameNode(Node node, String oldName, String newName) {
        File currentHistoryDir;
        File historyParentDir;
        File oldHistoryDir;
        String onRenameDesc = " old name: " + oldName + ", new name: " + newName;
        if (this.historyRootDir != null && (oldHistoryDir = new File(historyParentDir = (currentHistoryDir = this.getHistoryDirForNode(node)).getParentFile(), oldName)).exists()) {
            FilePath fp = new FilePath(oldHistoryDir);
            try {
                fp.copyRecursiveTo(new FilePath(currentHistoryDir));
                fp.deleteRecursive();
                LOG.log(Level.FINEST, "completed move of old history files on rename.{0}", onRenameDesc);
            }
            catch (IOException e) {
                String ioExceptionStr = "unable to move old history on rename." + onRenameDesc;
                LOG.log(Level.SEVERE, ioExceptionStr, e);
            }
            catch (InterruptedException e) {
                String irExceptionStr = "interrupted while moving old history on rename." + onRenameDesc;
                LOG.log(Level.WARNING, irExceptionStr, e);
            }
        }
        String content = Jenkins.XSTREAM2.toXML((Object)node);
        this.createNewHistoryEntryAndSaveConfig(node, content, Messages.ConfigHistoryListenerHelper_RENAMED(), newName, oldName);
    }

    @Override
    public SortedMap<String, HistoryDescr> getRevisions(Node node) {
        File historiesDir = this.getHistoryDirForNode(node);
        File[] historyDirsOfItem = historiesDir.listFiles(HistoryFileFilter.INSTANCE);
        TreeMap<String, HistoryDescr> map = new TreeMap<String, HistoryDescr>();
        if (historyDirsOfItem == null) {
            return map;
        }
        for (File historyDir : historyDirsOfItem) {
            HistoryDescr historyDescription;
            XmlFile historyXml = this.getHistoryXmlFile(historyDir);
            try {
                historyDescription = (HistoryDescr)historyXml.read();
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to read history for " + node.getDisplayName(), ex);
            }
            map.put(historyDir.getName(), historyDescription);
        }
        return map;
    }

    private File getRootDir(Node node, AtomicReference<Calendar> timestampHolder) throws IOException {
        File itemHistoryDir = this.getHistoryDirForNode(node);
        this.purgeOldEntries(itemHistoryDir, this.maxHistoryEntries);
        return FileHistoryDao.createNewHistoryDir(itemHistoryDir, timestampHolder);
    }

    private File createNewHistoryEntry(Node node, String operation, String newName, String oldName, String changeReasonComment) {
        try {
            AtomicReference<Calendar> timestampHolder = new AtomicReference<Calendar>();
            File timestampedDir = this.getRootDir(node, timestampHolder);
            LOG.log(Level.FINE, "{0} on {1}", new Object[]{this, timestampedDir});
            this.createHistoryXmlFile(timestampHolder.get(), timestampedDir, operation, newName, oldName, changeReasonComment);
            assert (timestampHolder.get() != null);
            return timestampedDir;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create history entry for configuration file of node \"" + node.getDisplayName() + "\": " + e.getMessage(), e);
        }
    }

    File createNewHistoryEntry(XmlFile xmlFile, String operation, String newName, String oldName, String changeReasonComment) {
        try {
            AtomicReference<Calendar> timestampHolder = new AtomicReference<Calendar>();
            File timestampedDir = this.getRootDir(xmlFile, timestampHolder);
            LOG.log(Level.FINE, "{0} on {1}", new Object[]{this, timestampedDir});
            this.createHistoryXmlFile(timestampHolder.get(), timestampedDir, operation, newName, oldName, changeReasonComment);
            assert (timestampHolder.get() != null);
            return timestampedDir;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create history entry for configuration file \"" + xmlFile.getFile().getAbsolutePath() + "\": " + e.getMessage(), e);
        }
    }

    private File getHistoryDirForNode(Node node) {
        String name = node.getNodeName();
        File configHistoryDir = this.getNodeHistoryRootDir();
        return new File(configHistoryDir, name);
    }

    File getNodeHistoryRootDir() {
        return new File(this.historyRootDir, "/nodes");
    }

    @Override
    public boolean hasDuplicateHistory(Node node) {
        String content = Jenkins.XSTREAM2.toXML((Object)node);
        boolean isDuplicated = false;
        ArrayList<String> timeStamps = new ArrayList<String>(this.getRevisions(node).keySet());
        if (!timeStamps.isEmpty()) {
            timeStamps.sort(Collections.reverseOrder());
            XmlFile lastRevision = this.getOldRevision(node, timeStamps.get(0));
            try {
                if (content.equals(lastRevision.asString())) {
                    isDuplicated = true;
                }
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "unable to check for duplicate previous history file: {0}\n{1}", new Object[]{lastRevision, e});
            }
        }
        return isDuplicated;
    }

    private boolean checkDuplicate(Node node) {
        if (!this.saveDuplicates && this.hasDuplicateHistory(node)) {
            LOG.log(Level.FINE, "found duplicate history, skipping save of {0}", node.getDisplayName());
            return false;
        }
        return true;
    }

    @Override
    public void saveNode(Node node) {
        String content = Jenkins.XSTREAM2.toXML((Object)node);
        if (this.checkDuplicate(node)) {
            this.createNewHistoryEntryAndSaveConfig(node, content, Messages.ConfigHistoryListenerHelper_CHANGED(), null, null);
        }
    }

    @Override
    public XmlFile getOldRevision(Node node, String identifier) {
        File historyDir = new File(this.getHistoryDirForNode(node), identifier);
        return new XmlFile(FileHistoryDao.getConfigFile(historyDir));
    }

    @Override
    public boolean hasOldRevision(Node node, String identifier) {
        XmlFile oldRevision = this.getOldRevision(node, identifier);
        return oldRevision.getFile() != null && oldRevision.getFile().exists();
    }
}

