/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.Extension;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.jobConfigHistory.JobConfigHistoryStrategy;
import hudson.plugins.jobConfigHistory.NodeListenerHistoryDao;
import hudson.plugins.jobConfigHistory.PluginUtils;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.ComputerListener;
import hudson.slaves.EphemeralNode;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class ComputerHistoryListener
extends ComputerListener {
    private static final Logger LOG = Logger.getLogger(ComputerHistoryListener.class.getName());
    List<Node> nodes;

    public void onConfigurationChange() {
        Jenkins jenkins = Jenkins.get();
        if (this.nodes == null) {
            this.nodes = jenkins.getNodes();
        }
        if (this.nodes.size() < jenkins.getNodes().size()) {
            this.onAdd();
            this.nodes = jenkins.getNodes();
            return;
        }
        if (this.nodes.size() > jenkins.getNodes().size()) {
            this.onRemove();
            this.nodes = jenkins.getNodes();
            return;
        }
        if (!this.nodes.equals(jenkins.getNodes())) {
            this.onRename();
            this.nodes = jenkins.getNodes();
        }
        if (this.nodes.size() == jenkins.getNodes().size()) {
            this.onChange();
        }
    }

    private void onAdd() {
        Jenkins jenkins = Jenkins.get();
        for (Node node : jenkins.getNodes()) {
            if (this.nodes.contains(node) || !this.isTracked(node)) continue;
            this.switchHistoryDao(node).createNewNode(node);
            return;
        }
    }

    private boolean isTracked(Node node) {
        return node != null && !(node instanceof AbstractCloudSlave) && !(node instanceof EphemeralNode);
    }

    private void onRemove() {
        Jenkins jenkins = Jenkins.get();
        for (Node node : this.nodes) {
            if (jenkins.getNodes().contains(node) || !this.isTracked(node)) continue;
            this.switchHistoryDao(node).deleteNode(node);
            return;
        }
    }

    private void onChange() {
        Jenkins jenkins = Jenkins.get();
        JobConfigHistoryStrategy hdao = PluginUtils.getHistoryDao();
        for (Node node : jenkins.getNodes()) {
            if (PluginUtils.isUserExcluded(PluginUtils.getPlugin()) || !this.isTracked(node) || hdao.hasDuplicateHistory(node)) continue;
            PluginUtils.getHistoryDao().saveNode(node);
            return;
        }
    }

    private void onRename() {
        Node originalNode = null;
        Jenkins jenkins = Jenkins.get();
        for (Node node : this.nodes) {
            if (jenkins.getNodes().contains(node) || !this.isTracked(node)) continue;
            originalNode = node;
        }
        if (originalNode == null) {
            LOG.log(Level.WARNING, "Can not find changed node.");
            return;
        }
        Node newNode = null;
        for (Node node : jenkins.getNodes()) {
            if (this.nodes.contains(node) || !this.isTracked(node)) continue;
            newNode = node;
        }
        if (!originalNode.getNodeName().equals(newNode.getNodeName())) {
            this.switchHistoryDao(originalNode).renameNode(newNode, originalNode.getNodeName(), newNode.getNodeName());
        }
    }

    private NodeListenerHistoryDao switchHistoryDao(Node node) {
        return node instanceof Slave ? this.getHistoryDao() : NoOpNodeListenerHistoryDao.INSTANCE;
    }

    NodeListenerHistoryDao getHistoryDao() {
        return PluginUtils.getHistoryDao();
    }

    private static class NoOpNodeListenerHistoryDao
    implements NodeListenerHistoryDao {
        static final NoOpNodeListenerHistoryDao INSTANCE = new NoOpNodeListenerHistoryDao();

        private NoOpNodeListenerHistoryDao() {
        }

        @Override
        public void createNewNode(Node node) {
            LOG.log(Level.FINEST, "onCreated: not an agent {0}, skipping.", node);
        }

        @Override
        public void renameNode(Node node, String oldName, String newName) {
            LOG.log(Level.FINEST, "onRenamed: not an agent {0}, skipping.", node);
        }

        @Override
        public void deleteNode(Node node) {
            LOG.log(Level.FINEST, "onDeleted: not an agent {0}, skipping.", node);
        }
    }
}

