/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Item;
import hudson.model.RootAction;
import hudson.plugins.jobConfigHistory.ConfigInfo;
import hudson.plugins.jobConfigHistory.ConfigInfoComparator;
import hudson.plugins.jobConfigHistory.HistoryDescr;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import hudson.plugins.jobConfigHistory.JobConfigHistoryBaseAction;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class JobConfigHistoryRootAction
extends JobConfigHistoryBaseAction
implements RootAction {
    private static final Logger LOG = Logger.getLogger(JobConfigHistoryRootAction.class.getName());

    @Override
    public final String getUrlName() {
        return "/jobConfigHistory";
    }

    public final String getIconFileName() {
        if (this.hasConfigurePermission() || this.hasJobConfigurePermission()) {
            return "/plugin/jobConfigHistory/img/confighistory.png";
        }
        return null;
    }

    public final List<ConfigInfo> getConfigs() throws IOException {
        String filter = this.getRequestParameter("filter");
        List<ConfigInfo> configs = null;
        if (filter == null || "system".equals(filter)) {
            configs = this.getSystemConfigs();
        } else if ("all".equals(filter)) {
            configs = this.getJobConfigs("jobs");
            configs.addAll(this.getJobConfigs("deleted"));
            configs.addAll(this.getSystemConfigs());
        } else {
            configs = this.getJobConfigs(filter);
        }
        Collections.sort(configs, ConfigInfoComparator.INSTANCE);
        return configs;
    }

    protected List<ConfigInfo> getSystemConfigs() throws IOException {
        ArrayList<ConfigInfo> configs = new ArrayList<ConfigInfo>();
        File historyRootDir = this.getPlugin().getConfiguredHistoryRootDir();
        if (!this.hasConfigurePermission()) {
            return configs;
        }
        if (!historyRootDir.isDirectory()) {
            LOG.fine(historyRootDir + " is not a directory, assuming that no history exists yet.");
        } else {
            File[] itemDirs;
            for (File itemDir : itemDirs = historyRootDir.listFiles()) {
                if (itemDir.getName().equals("jobs")) continue;
                for (File historyDir : itemDir.listFiles(JobConfigHistory.HISTORY_FILTER)) {
                    XmlFile historyXml = new XmlFile(new File(historyDir, "history.xml"));
                    HistoryDescr histDescr = (HistoryDescr)historyXml.read();
                    ConfigInfo config = ConfigInfo.create(itemDir.getName(), historyDir, histDescr, false);
                    configs.add(config);
                }
            }
        }
        return configs;
    }

    protected List<ConfigInfo> getJobConfigs(String type) throws IOException {
        ArrayList<ConfigInfo> configs = new ArrayList<ConfigInfo>();
        File historyRootDir = this.getPlugin().getJobHistoryRootDir();
        if (!this.hasJobConfigurePermission()) {
            return configs;
        }
        if (!historyRootDir.isDirectory()) {
            LOG.fine(historyRootDir + " is not a directory, assuming that no history exists yet.");
        } else {
            File[] itemDirs = "deleted".equals(type) ? historyRootDir.listFiles(JobConfigHistory.DELETED_FILTER) : historyRootDir.listFiles();
            for (File itemDir : itemDirs) {
                for (File historyDir : itemDir.listFiles(JobConfigHistory.HISTORY_FILTER)) {
                    XmlFile historyXml = new XmlFile(new File(historyDir, "history.xml"));
                    HistoryDescr histDescr = (HistoryDescr)historyXml.read();
                    ConfigInfo config = "jobs".equals(type) && !itemDir.getName().contains("_deleted_") ? ConfigInfo.create(itemDir.getName(), historyDir, histDescr, true) : ConfigInfo.create(itemDir.getName(), historyDir, histDescr, false);
                    if ("deleted".equals(type) && !"Deleted".equals(config.getOperation())) continue;
                    configs.add(config);
                }
            }
        }
        return configs;
    }

    public final List<ConfigInfo> getSingleConfigs(StaplerRequest req) throws IOException {
        String name = req.getParameter("name");
        ArrayList<ConfigInfo> configs = new ArrayList<ConfigInfo>();
        File historyRootDir = name.contains("_deleted_") ? this.getPlugin().getJobHistoryRootDir() : this.getPlugin().getConfiguredHistoryRootDir();
        for (File itemDir : historyRootDir.listFiles()) {
            if (!itemDir.getName().equals(name)) continue;
            for (File historyDir : itemDir.listFiles(JobConfigHistory.HISTORY_FILTER)) {
                XmlFile historyXml = new XmlFile(new File(historyDir, "history.xml"));
                HistoryDescr histDescr = (HistoryDescr)historyXml.read();
                ConfigInfo config = ConfigInfo.create(itemDir.getName(), historyDir, histDescr, false);
                configs.add(config);
            }
        }
        Collections.sort(configs, ConfigInfoComparator.INSTANCE);
        return configs;
    }

    @Override
    protected AccessControlled getAccessControlledObject() {
        return this.getHudson();
    }

    @Override
    protected void checkConfigurePermission() {
        this.getAccessControlledObject().checkPermission(Permission.CONFIGURE);
    }

    @Override
    public boolean hasConfigurePermission() {
        return this.getAccessControlledObject().hasPermission(Permission.CONFIGURE);
    }

    public boolean hasJobConfigurePermission() {
        return this.getAccessControlledObject().hasPermission(Item.CONFIGURE);
    }
}

