/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractItem;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import hudson.plugins.jobConfigHistory.ConfigHistoryListenerHelper;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public final class JobConfigHistoryJobListener
extends ItemListener {
    private static final Logger LOG = Logger.getLogger(JobConfigHistoryJobListener.class.getName());

    public void onCreated(Item item) {
        LOG.finest("In onCreated for " + item);
        if (item instanceof AbstractItem) {
            ConfigHistoryListenerHelper.CREATED.createNewHistoryEntry(((AbstractItem)item).getConfigFile());
        } else {
            LOG.finest("onCreated: not an AbstractItem, skipping history save");
        }
        LOG.finest("onCreated for " + item + " done.");
    }

    public void onRenamed(Item item, String oldName, String newName) {
        String onRenameDesc = " old name: " + oldName + ", new name: " + newName;
        LOG.finest("In onRenamed for " + item + onRenameDesc);
        if (item instanceof AbstractItem) {
            File currentHistoryDir;
            File historyParentDir;
            File oldHistoryDir;
            ConfigHistoryListenerHelper.RENAMED.createNewHistoryEntry(((AbstractItem)item).getConfigFile());
            JobConfigHistory plugin = (JobConfigHistory)Hudson.getInstance().getPlugin(JobConfigHistory.class);
            if (plugin.getConfiguredHistoryRootDir() != null && (oldHistoryDir = new File(historyParentDir = (currentHistoryDir = plugin.getHistoryDir(((AbstractItem)item).getConfigFile())).getParentFile(), oldName)).exists()) {
                FilePath fp = new FilePath(oldHistoryDir);
                try {
                    fp.copyRecursiveTo(new FilePath(currentHistoryDir));
                    fp.deleteRecursive();
                    LOG.finest("completed move of old history files on rename." + onRenameDesc);
                }
                catch (IOException e) {
                    String ioExceptionStr = "unable to move old history on rename." + onRenameDesc;
                    LOG.log(Level.SEVERE, ioExceptionStr, e);
                }
                catch (InterruptedException e) {
                    String irExceptionStr = "interrupted while moving old history on rename." + onRenameDesc;
                    LOG.log(Level.WARNING, irExceptionStr, e);
                }
            }
        }
        LOG.finest("Completed onRename for" + item + " done.");
    }

    public void onDeleted(Item item) {
        LOG.finest("In onDeleted for " + item);
        if (item instanceof AbstractItem) {
            JobConfigHistory plugin = (JobConfigHistory)Hudson.getInstance().getPlugin(JobConfigHistory.class);
            ConfigHistoryListenerHelper.DELETED.createNewHistoryEntry(((AbstractItem)item).getConfigFile());
            File currentHistoryDir = plugin.getHistoryDir(((AbstractItem)item).getConfigFile());
            SimpleDateFormat buildDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
            String timestamp = buildDateFormat.format(new Date());
            String deletedHistoryName = item.getName() + "_deleted_" + timestamp;
            File deletedHistoryDir = new File(currentHistoryDir.getParentFile(), deletedHistoryName);
            if (!currentHistoryDir.renameTo(deletedHistoryDir)) {
                LOG.warning("unable to rename deleted history dir to: " + deletedHistoryDir);
            }
        }
        LOG.finest("onDeleted for " + item + " done.");
    }
}

