/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.Plugin;
import hudson.XmlFile;
import hudson.maven.MavenModule;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.plugins.jobConfigHistory.FileHistoryDao;
import hudson.plugins.jobConfigHistory.HistoryDao;
import hudson.plugins.jobConfigHistory.PluginUtils;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class JobConfigHistory
extends Plugin {
    private String historyRootDir;
    private String maxHistoryEntries;
    private String maxEntriesPerPage;
    private String maxDaysToKeepEntries;
    private String excludedUsers;
    private boolean skipDuplicateHistory = true;
    private String excludePattern;
    private transient Pattern excludeRegexpPattern;
    private boolean saveModuleConfiguration = false;
    private String showBuildBadges = "always";
    private static final Logger LOG = Logger.getLogger(JobConfigHistory.class.getName());

    public void start() throws Exception {
        this.load();
        this.loadRegexpPatterns();
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        this.historyRootDir = formData.getString("historyRootDir").trim();
        this.setMaxHistoryEntries(formData.getString("maxHistoryEntries").trim());
        this.setMaxDaysToKeepEntries(formData.getString("maxDaysToKeepEntries").trim());
        this.setMaxEntriesPerPage(formData.getString("maxEntriesPerPage").trim());
        this.skipDuplicateHistory = formData.getBoolean("skipDuplicateHistory");
        this.excludePattern = formData.getString("excludePattern");
        this.saveModuleConfiguration = formData.getBoolean("saveModuleConfiguration");
        this.showBuildBadges = formData.getString("showBuildBadges");
        this.excludedUsers = formData.getString("excludedUsers");
        this.save();
        this.loadRegexpPatterns();
    }

    public String getDefaultRootDir() {
        return "config-history";
    }

    public String getHistoryRootDir() {
        return this.historyRootDir;
    }

    public String getMaxHistoryEntries() {
        return this.maxHistoryEntries;
    }

    public void setMaxHistoryEntries(String maxEntryInput) {
        String trimmedValue = StringUtils.trimToNull((String)maxEntryInput);
        if (trimmedValue == null || this.isPositiveInteger(trimmedValue)) {
            this.maxHistoryEntries = trimmedValue;
        }
    }

    public String getMaxEntriesPerPage() {
        return this.maxEntriesPerPage;
    }

    public void setMaxEntriesPerPage(String maxEntryInput) {
        String trimmedValue = StringUtils.trimToNull((String)maxEntryInput);
        if (trimmedValue == null || this.isPositiveInteger(trimmedValue)) {
            this.maxEntriesPerPage = trimmedValue;
        }
    }

    public String getMaxDaysToKeepEntries() {
        return this.maxDaysToKeepEntries;
    }

    public void setMaxDaysToKeepEntries(String maxDaysInput) {
        String trimmedValue = StringUtils.trimToNull((String)maxDaysInput);
        if (trimmedValue == null || this.isPositiveInteger(trimmedValue)) {
            this.maxDaysToKeepEntries = trimmedValue;
        }
    }

    public boolean isPositiveInteger(String numberString) {
        try {
            int number = Integer.parseInt(numberString);
            if (number < 0) {
                throw new NumberFormatException();
            }
            return true;
        }
        catch (NumberFormatException e) {
            LOG.log(Level.WARNING, "No positive integer: {0}", numberString);
            return false;
        }
    }

    @Deprecated
    public boolean getSaveItemGroupConfiguration() {
        return true;
    }

    public boolean getSkipDuplicateHistory() {
        return this.skipDuplicateHistory;
    }

    public String getDefaultExcludePattern() {
        return "queue\\.xml|nodeMonitors\\.xml|UpdateCenter\\.xml|global-build-stats|LockableResourcesManager\\.xml|MilestoneStep\\.xml";
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    public boolean getSaveModuleConfiguration() {
        return this.saveModuleConfiguration;
    }

    public String getShowBuildBadges() {
        return this.showBuildBadges;
    }

    public void setShowBuildBadges(String showBuildBadges) {
        this.showBuildBadges = showBuildBadges;
    }

    public boolean showBuildBadges(Job<?, ?> project) {
        if ("always".equals(this.showBuildBadges)) {
            return true;
        }
        if ("userWithConfigPermission".equals(this.showBuildBadges) && project.hasPermission(Item.CONFIGURE)) {
            return true;
        }
        return "adminUser".equals(this.showBuildBadges) && this.getJenkins().hasPermission(Jenkins.ADMINISTER);
    }

    public Pattern getExcludeRegexpPattern() {
        return this.excludeRegexpPattern;
    }

    private void loadRegexpPatterns() {
        this.excludeRegexpPattern = this.loadRegex(this.excludePattern);
    }

    private Pattern loadRegex(String patternString) {
        if (patternString != null) {
            try {
                return Pattern.compile(patternString);
            }
            catch (PatternSyntaxException e) {
                return null;
            }
        }
        return null;
    }

    public File getConfiguredHistoryRootDir() {
        File jenkinsHome = this.getJenkinsHome();
        File rootDir = this.historyRootDir == null ? new File(jenkinsHome, "config-history") : (this.historyRootDir.matches("^(/|\\\\|[a-zA-Z]:).*") ? new File(this.historyRootDir + "/" + "config-history") : new File(jenkinsHome, this.historyRootDir + "/" + "config-history"));
        return rootDir;
    }

    public File getConfigFile(File historyDir) {
        return FileHistoryDao.getConfigFile(historyDir);
    }

    public String getExcludedUsers() {
        return this.excludedUsers;
    }

    public boolean isSaveable(Saveable item, XmlFile xmlFile) {
        boolean canSave = this.checkRegex(xmlFile);
        if (!canSave) {
            LOG.log(Level.FINE, "skipped recording change history for job {0}", xmlFile.getFile().getAbsolutePath());
            return false;
        }
        if (item instanceof TopLevelItem) {
            return true;
        }
        return PluginUtils.isMavenPluginAvailable() && item instanceof MavenModule && this.saveModuleConfiguration;
    }

    private boolean checkRegex(XmlFile xmlFile) {
        if (this.excludeRegexpPattern != null) {
            String fullPath = xmlFile.getFile().getAbsolutePath();
            Matcher matcher = this.excludeRegexpPattern.matcher(fullPath);
            return !matcher.find();
        }
        return true;
    }

    public FormValidation doCheckMaxHistoryEntries(@QueryParameter String value) {
        String trimmedValue = StringUtils.trimToNull((String)value);
        if (trimmedValue == null || this.isPositiveInteger(trimmedValue)) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)"Enter a valid positive integer");
    }

    public FormValidation doCheckMaxEntriesPerPage(@QueryParameter String value) {
        String trimmedValue = StringUtils.trimToNull((String)value);
        if (trimmedValue == null || this.isPositiveInteger(trimmedValue)) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)"Enter a valid positive integer");
    }

    public FormValidation doCheckMaxDaysToKeepEntries(@QueryParameter String value) {
        String trimmedValue = StringUtils.trimToNull((String)value);
        if (trimmedValue == null || this.isPositiveInteger(trimmedValue)) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)"Enter a valid positive integer");
    }

    public FormValidation doCheckExcludePattern(@QueryParameter String value) {
        try {
            Pattern.compile(value);
            return FormValidation.ok();
        }
        catch (PatternSyntaxException e) {
            return FormValidation.error((String)"Enter a valid regular expression");
        }
    }

    protected HistoryDao getHistoryDao() {
        return PluginUtils.getHistoryDao(this);
    }

    protected File getJenkinsHome() {
        Jenkins jenkins = Jenkins.getInstance();
        return jenkins.getRootDir();
    }

    @Deprecated
    public Jenkins getJenkins() {
        return Jenkins.getInstance();
    }
}

