/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.plugins.jobConfigHistory.HistoryDescr;
import hudson.plugins.jobConfigHistory.ParsedDate;
import hudson.plugins.jobConfigHistory.PluginUtils;
import java.util.Date;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class ConfigInfo
implements ParsedDate {
    private final String user;
    private final String userID;
    private final String date;
    private final boolean configExists;
    private final String job;
    private final String operation;
    private boolean isJob;
    private final String currentName;
    private final String oldName;

    public static ConfigInfo create(String name, boolean configExists, HistoryDescr histDescr, boolean isJob) {
        return new ConfigInfo(name, configExists, histDescr.getTimestamp(), histDescr.getUser(), histDescr.getOperation(), histDescr.getUserID(), isJob, histDescr.getCurrentName(), histDescr.getOldName());
    }

    ConfigInfo(String job, boolean configExists, String date, String user, String operation, String userID, boolean isJob, String currentName, String oldName) {
        this.job = job;
        this.configExists = configExists;
        this.date = date;
        this.user = user;
        this.operation = operation;
        this.userID = userID;
        this.isJob = isJob;
        this.currentName = currentName;
        this.oldName = oldName;
    }

    @Exported
    public String getUser() {
        return this.user;
    }

    @Exported
    public String getUserID() {
        return this.userID;
    }

    @Exported
    public String getDate() {
        return this.date;
    }

    @Exported
    public boolean hasConfig() {
        return this.configExists;
    }

    @Exported
    public String getJob() {
        return this.job;
    }

    @Exported
    public String getOperation() {
        return this.operation;
    }

    public boolean getIsJob() {
        return this.isJob;
    }

    public String toString() {
        return this.operation + " on " + this.job + " @" + this.date;
    }

    @Override
    public Date parsedDate() {
        return PluginUtils.parsedDate(this.getDate());
    }

    @Exported
    public String getCurrentName() {
        return this.currentName;
    }

    @Exported
    public String getOldName() {
        return this.oldName;
    }
}

