/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.XmlFile;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.plugins.jobConfigHistory.ConfigInfo;
import hudson.plugins.jobConfigHistory.ConfigInfoComparator;
import hudson.plugins.jobConfigHistory.HistoryDescr;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import hudson.plugins.jobConfigHistory.JobConfigHistoryBaseAction;
import hudson.security.AccessControlled;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobConfigHistoryProjectAction
extends JobConfigHistoryBaseAction {
    private final transient AbstractItem project;

    public JobConfigHistoryProjectAction(AbstractItem project) {
        this.project = project;
    }

    public final String getIconFileName() {
        return this.hasConfigurePermission() ? "/plugin/jobConfigHistory/img/confighistory.png" : null;
    }

    public final List<ConfigInfo> getJobConfigs() throws IOException {
        this.checkConfigurePermission();
        ArrayList<ConfigInfo> configs = new ArrayList<ConfigInfo>();
        File historyRootDir = this.getPlugin().getHistoryDir(this.project.getConfigFile());
        if (historyRootDir.exists()) {
            for (File historyDir : historyRootDir.listFiles(JobConfigHistory.HISTORY_FILTER)) {
                XmlFile historyXml = new XmlFile(new File(historyDir, "history.xml"));
                HistoryDescr histDescr = (HistoryDescr)historyXml.read();
                ConfigInfo config = ConfigInfo.create(this.project, historyDir, histDescr);
                configs.add(config);
            }
        }
        Collections.sort(configs, ConfigInfoComparator.INSTANCE);
        return configs;
    }

    public final AbstractItem getProject() {
        return this.project;
    }

    @Override
    protected AccessControlled getAccessControlledObject() {
        return this.project;
    }

    @Override
    protected void checkConfigurePermission() {
        this.getAccessControlledObject().checkPermission(AbstractProject.CONFIGURE);
    }

    @Override
    protected boolean hasConfigurePermission() {
        return this.getAccessControlledObject().hasPermission(AbstractProject.CONFIGURE);
    }

    public final void doRestore(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.checkConfigurePermission();
        String timestamp = req.getParameter("timestamp");
        String name = req.getParameter("name");
        XmlFile xmlFile = this.getConfigXml(name, timestamp, true);
        String oldConfig = xmlFile.asString();
        ByteArrayInputStream is = new ByteArrayInputStream(oldConfig.getBytes("UTF-8"));
        this.project.updateByXml(new StreamSource(is));
        this.project.save();
        rsp.sendRedirect(Hudson.getInstance().getRootUrl() + this.project.getUrl());
    }

    public final void doForwardToRestoreQuestion(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String timestamp = req.getParameter("timestamp");
        String name = req.getParameter("name");
        rsp.sendRedirect("restoreQuestion?timestamp=" + timestamp + "&name=" + name);
    }
}

