/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.BuildBadgeAction;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.jobConfigHistory.HistoryDao;
import hudson.plugins.jobConfigHistory.HistoryDescr;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import hudson.plugins.jobConfigHistory.JobConfigHistoryStrategy;
import hudson.plugins.jobConfigHistory.Messages;
import hudson.plugins.jobConfigHistory.ParsedDateComparator;
import hudson.plugins.jobConfigHistory.PluginUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.model.RunAction2;

public class JobConfigBadgeAction
implements BuildBadgeAction,
RunAction2 {
    private String[] configDates;
    private transient Run<?, ?> build;

    JobConfigBadgeAction(String[] configDates) {
        this.configDates = (String[])configDates.clone();
        this.build = null;
    }

    public void onAttached(Run<?, ?> r) {
        this.build = r;
    }

    public void onLoad(Run<?, ?> r) {
        this.build = r;
    }

    public boolean showBadge() {
        return this.getPlugin().showBuildBadges(this.build.getParent());
    }

    public boolean oldConfigsExist() {
        HistoryDao historyDao = this.getHistoryDao();
        Job project = this.build.getParent();
        for (String timestamp : this.configDates) {
            if (historyDao.hasOldRevision(project.getConfigFile(), timestamp)) continue;
            return false;
        }
        return true;
    }

    public String createLink() {
        return this.getRootUrl() + this.build.getParent().getUrl() + "jobConfigHistory" + "/showDiffFiles?timestamp1=" + this.configDates[1] + "&timestamp2=" + this.configDates[0];
    }

    String getRootUrl() {
        return Jenkins.getInstance().getRootUrlFromRequest();
    }

    public String getTooltip() {
        return Messages.JobConfigBadgeAction_ToolTip();
    }

    public String getIcon() {
        return "/plugin/jobConfigHistory/img/buildbadge.png";
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "";
    }

    JobConfigHistory getPlugin() {
        return PluginUtils.getPlugin();
    }

    HistoryDao getHistoryDao() {
        return PluginUtils.getHistoryDao();
    }

    @Extension
    public static class Listener
    extends RunListener<Run<?, ?>> {
        public void onStarted(Run<?, ?> build, TaskListener listener) {
            List<HistoryDescr> historyDescriptions;
            Job project = build.getParent();
            if (project.getNextBuildNumber() <= 2) {
                super.onStarted(build, listener);
                return;
            }
            Date lastBuildDate = null;
            Run lastBuild = project.getLastBuild();
            if (lastBuild != null && lastBuild.getPreviousBuild() != null) {
                lastBuildDate = lastBuild.getPreviousBuild().getTime();
            }
            if ((historyDescriptions = this.getRevisions(project)).size() > 1) {
                Collections.sort(historyDescriptions, ParsedDateComparator.DESCENDING);
                HistoryDescr lastChange = (HistoryDescr)Collections.min(historyDescriptions, ParsedDateComparator.DESCENDING);
                Date lastConfigChange = lastChange.parsedDate();
                if (lastBuildDate != null && lastConfigChange.after(lastBuildDate)) {
                    String[] dates = new String[]{lastChange.getTimestamp(), this.findLastRelevantConfigChangeDate(historyDescriptions, lastBuildDate)};
                    build.addAction((Action)new JobConfigBadgeAction(dates));
                }
            }
            super.onStarted(build, listener);
        }

        List<HistoryDescr> getRevisions(Job<?, ?> project) {
            JobConfigHistoryStrategy historyDao = PluginUtils.getHistoryDao();
            ArrayList<HistoryDescr> historyDescriptions = new ArrayList<HistoryDescr>(historyDao.getRevisions(project.getConfigFile()).values());
            return historyDescriptions;
        }

        private String findLastRelevantConfigChangeDate(List<HistoryDescr> historyDescriptions, Date lastBuildDate) {
            for (HistoryDescr oldConfigChange : historyDescriptions.subList(1, historyDescriptions.size())) {
                Date changeDate = oldConfigChange.parsedDate();
                if (changeDate == null || !changeDate.before(lastBuildDate)) continue;
                return oldConfigChange.getTimestamp();
            }
            return historyDescriptions.get(1).getTimestamp();
        }
    }
}

