/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import hudson.XmlFile;
import hudson.plugins.jobConfigHistory.HistoryDescr;
import java.io.IOException;

public class LazyHistoryDescr
extends HistoryDescr {
    HistoryDescr historyDescr = HistoryDescr.EMPTY_HISTORY_DESCR;
    private final XmlFile historyDescriptionFile;

    public LazyHistoryDescr(XmlFile historyDescriptionFile) {
        super(null, null, null, null);
        this.historyDescriptionFile = historyDescriptionFile;
    }

    @Override
    public String getUser() {
        return this.loadAndGetHistory().getUser();
    }

    @Override
    public String getUserID() {
        return this.loadAndGetHistory().getUserID();
    }

    @Override
    public String getOperation() {
        return this.loadAndGetHistory().getOperation();
    }

    @Override
    public String getTimestamp() {
        return this.loadAndGetHistory().getTimestamp();
    }

    private HistoryDescr loadAndGetHistory() {
        if (this.historyDescr == HistoryDescr.EMPTY_HISTORY_DESCR) {
            try {
                this.historyDescr = (HistoryDescr)this.historyDescriptionFile.read();
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to read " + this.historyDescriptionFile.getFile(), ex);
            }
            catch (CannotResolveClassException ex) {
                throw new RuntimeException(this.historyDescriptionFile.getFile() + " is not a history description", ex);
            }
        }
        return this.historyDescr;
    }
}

