/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.model.AbstractItem;
import hudson.plugins.jobConfigHistory.HistoryDescr;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class ConfigInfo {
    private final String user;
    private final String userID;
    private final String date;
    private final String file;
    private final String job;
    private final String operation;
    private boolean isJob;

    public static ConfigInfo create(AbstractItem item, File file, HistoryDescr histDescr) throws UnsupportedEncodingException {
        return new ConfigInfo(item.getName(), URLEncoder.encode(file.getAbsolutePath(), "utf-8"), histDescr.getTimestamp(), histDescr.getUser(), histDescr.getOperation(), histDescr.getUserID(), true);
    }

    public static ConfigInfo create(String name, File file, HistoryDescr histDescr, boolean isJob) throws UnsupportedEncodingException {
        return new ConfigInfo(name, URLEncoder.encode(file.getAbsolutePath(), "utf-8"), histDescr.getTimestamp(), histDescr.getUser(), histDescr.getOperation(), histDescr.getUserID(), isJob);
    }

    ConfigInfo(String job, String file, String date, String user, String operation, String userID, boolean isJob) {
        this.job = job;
        this.file = file;
        this.date = date;
        this.user = user;
        this.operation = operation;
        this.userID = userID;
        this.isJob = isJob;
    }

    @Exported
    public String getUser() {
        return this.user;
    }

    @Exported
    public String getUserID() {
        return this.userID;
    }

    @Exported
    public String getDate() {
        return this.date;
    }

    @Exported
    public String getFile() {
        return this.file;
    }

    @Exported
    public String getJob() {
        return this.job;
    }

    @Exported
    public String getOperation() {
        return this.operation;
    }

    public boolean getIsJob() {
        return this.isJob;
    }
}

