/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.jobConfigHistory.PluginUtils;
import hudson.util.FormValidation;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class JobLocalConfiguration
extends JobProperty<Job<?, ?>> {
    private static final Logger LOG = Logger.getLogger(JobLocalConfiguration.class.getName());
    private static final Map<File, String> lastChangeReasonCommentByXmlFile = Collections.synchronizedMap(new HashMap());
    private final String changeReasonComment;

    static Optional<String> lastChangeReasonComment(XmlFile file) {
        return Optional.ofNullable(lastChangeReasonCommentByXmlFile.remove(file.getFile()));
    }

    @DataBoundConstructor
    public JobLocalConfiguration(String changeReasonComment) {
        this.changeReasonComment = changeReasonComment;
    }

    public String getChangeReasonComment() {
        return "";
    }

    @Extension
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public DescriptorImpl() {
            super(JobLocalConfiguration.class);
        }

        @NonNull
        public String getDisplayName() {
            return "changeReasonComment_holder";
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="JavaDoc says it is always Non-null")
        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JobLocalConfiguration jp = (JobLocalConfiguration)super.newInstance(req, formData);
            Job job = (Job)req.findAncestorObject(Job.class);
            if (job != null) {
                lastChangeReasonCommentByXmlFile.put(job.getConfigFile().getFile(), Util.fixEmptyAndTrim((String)jp.changeReasonComment));
            }
            return null;
        }

        public boolean configure(StaplerRequest request, JSONObject jsonObject) throws Descriptor.FormException {
            LOG.info("CONFIGURE");
            throw new Descriptor.FormException("form exception", "localValues.changeReasonComment");
        }

        public FormValidation doCheckChangeReasonComment(@QueryParameter String changeReasonComment, @AncestorInPath Item item) {
            return FormValidation.ok();
        }

        public boolean getShowChangeReasonCommentWindow() {
            return PluginUtils.getPlugin().getShowChangeReasonCommentWindow();
        }
    }
}

