/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.Patch;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.XmlFile;
import hudson.model.Action;
import hudson.plugins.jobConfigHistory.GetDiffLines;
import hudson.plugins.jobConfigHistory.HistoryDao;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import hudson.plugins.jobConfigHistory.Messages;
import hudson.plugins.jobConfigHistory.PluginUtils;
import hudson.plugins.jobConfigHistory.SideBySideView;
import hudson.security.AccessControlled;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.DefaultNodeMatcher;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.Difference;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.diff.ElementSelector;
import org.xmlunit.diff.ElementSelectors;
import org.xmlunit.diff.NodeMatcher;

public abstract class JobConfigHistoryBaseAction
implements Action {
    private static final Logger LOG = Logger.getLogger(JobConfigHistoryBaseAction.class.getName());
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public JobConfigHistoryBaseAction() {
        this.transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        this.transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
    }

    public String getDisplayName() {
        return Messages.displayName();
    }

    public String getUrlName() {
        return "jobConfigHistory";
    }

    public final String getOutputType() {
        if ("xml".equalsIgnoreCase(this.getRequestParameter("type"))) {
            return "xml";
        }
        return "plain";
    }

    protected boolean checkTimestamp(String timestamp) {
        if (timestamp == null || "null".equals(timestamp)) {
            return false;
        }
        PluginUtils.parsedDate(timestamp);
        return true;
    }

    protected String getRequestParameter(String parameterName) {
        return this.getCurrentRequest().getParameter(parameterName);
    }

    protected abstract void checkConfigurePermission();

    public abstract boolean hasAdminPermission();

    public abstract boolean hasDeleteEntryPermission();

    protected abstract void checkDeleteEntryPermission();

    protected abstract boolean hasConfigurePermission();

    public abstract int getRevisionAmount();

    protected abstract AccessControlled getAccessControlledObject();

    public final List<SideBySideView.Line> getDiffLines(List<String> diffLines) {
        try {
            return new GetDiffLines(diffLines).get();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "DiffException occurred while trying to get diffs: {0}", e.getMessage());
            return Collections.emptyList();
        }
    }

    protected final String getDiffAsString(File file1, File file2, String[] file1Lines, String[] file2Lines) {
        return this.getDiffAsString(file1, file2, file1Lines, file2Lines, false);
    }

    private Diff getVersionDiffsOnly(String file1Str, String file2Str) {
        DifferenceEvaluator versionDifferenceEvaluator = (comparison, comparisonResult) -> {
            String[] testValue;
            if (comparison.getType() != ComparisonType.ATTR_VALUE) {
                return ComparisonResult.EQUAL;
            }
            Node controlNode = comparison.getControlDetails().getTarget();
            Node testNode = comparison.getTestDetails().getTarget();
            if (controlNode == null || testNode == null) {
                return ComparisonResult.EQUAL;
            }
            String[] controlValue = controlNode.getNodeValue().split("@");
            if (!controlValue[0].equals((testValue = testNode.getNodeValue().split("@"))[0]) || controlValue.length != 2 || testValue.length != 2) {
                return ComparisonResult.EQUAL;
            }
            if (controlValue[1].equals(testValue[1])) {
                return ComparisonResult.EQUAL;
            }
            return ComparisonResult.DIFFERENT;
        };
        return DiffBuilder.compare((Object)Input.fromString((String)file1Str)).withTest((Object)Input.fromString((String)file2Str)).ignoreWhitespace().withNodeMatcher((NodeMatcher)new DefaultNodeMatcher(new ElementSelector[]{ElementSelectors.byNameAndText})).withDifferenceEvaluator(versionDifferenceEvaluator).build();
    }

    public String getShowVersionDiffs() {
        String showVersionDiffs = this.getRequestParameter("showVersionDiffs");
        return showVersionDiffs == null ? "True" : showVersionDiffs;
    }

    public final List<SideBySideView.Line> getLines() throws IOException {
        boolean hideVersionDiffs = !Boolean.parseBoolean(this.getShowVersionDiffs());
        return this.getLines(hideVersionDiffs);
    }

    public abstract List<SideBySideView.Line> getLines(boolean var1) throws IOException;

    private String reformatAndConcatStringArray(String[] arr) {
        Object ret = "";
        String firstLineRegex = "<[^<>]*>";
        String firstLine = arr[0];
        if (firstLine.matches("<[^<>]*>")) {
            ret = (String)ret + firstLine;
        } else {
            String tagThatBelongsInTheNextLine = firstLine.replaceFirst("<[^<>]*>", "");
            ret = (String)ret + firstLine.substring(0, firstLine.length() - tagThatBelongsInTheNextLine.length()) + "\n" + tagThatBelongsInTheNextLine + "\n";
        }
        for (int i = 1; i < arr.length; ++i) {
            ret = i < arr.length - 1 ? ((String)ret).concat(arr[i]).concat("\n") : ((String)ret).concat(arr[i]);
        }
        return ret;
    }

    protected final String getDiffAsString(File file1, File file2, String[] file1Lines, String[] file2Lines, boolean hideVersionDiffs) {
        Patch patch;
        try {
            patch = DiffUtils.diff(Arrays.asList(file1Lines), Arrays.asList(file2Lines));
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "DiffException occurred while trying to calculate diffs: {0}", e.getMessage());
            return "";
        }
        if (hideVersionDiffs) {
            Diff versionDiffs = this.getVersionDiffsOnly(this.reformatAndConcatStringArray(file1Lines), this.reformatAndConcatStringArray(file2Lines));
            LinkedList<AbstractDelta> deltasToBeRemovedAfterTheMainLoop = new LinkedList<AbstractDelta>();
            for (AbstractDelta delta : patch.getDeltas()) {
                ArrayList originalLines = Lists.newArrayList((Iterable)delta.getSource().getLines());
                ArrayList revisedLines = Lists.newArrayList((Iterable)delta.getTarget().getLines());
                for (Difference versionDifference : versionDiffs.getDifferences()) {
                    String controlValue = versionDifference.getComparison().getControlDetails().getValue().toString();
                    String testValue = versionDifference.getComparison().getTestDetails().getValue().toString();
                    for (int oriLineNumber = 0; oriLineNumber < originalLines.size(); ++oriLineNumber) {
                        String currentOriLine = (String)originalLines.get(oriLineNumber);
                        String otherValue = "";
                        if (currentOriLine.contains(controlValue)) {
                            otherValue = testValue;
                        } else {
                            if (!currentOriLine.contains(testValue)) continue;
                            otherValue = controlValue;
                        }
                        for (int revLineNumber = 0; revLineNumber < revisedLines.size(); ++revLineNumber) {
                            String currentRevLine = (String)revisedLines.get(revLineNumber);
                            if (!currentRevLine.contains(otherValue)) continue;
                            originalLines.remove(oriLineNumber);
                            revisedLines.remove(revLineNumber);
                        }
                    }
                }
                if (originalLines.isEmpty() && revisedLines.isEmpty()) {
                    deltasToBeRemovedAfterTheMainLoop.add(delta);
                }
                delta.getSource().setLines((List)originalLines);
                delta.getTarget().setLines((List)revisedLines);
            }
            patch.getDeltas().removeAll(deltasToBeRemovedAfterTheMainLoop);
        }
        return StringUtils.join((Collection)UnifiedDiffUtils.generateUnifiedDiff((String)file1.getPath(), (String)file2.getPath(), Arrays.asList(file1Lines), (Patch)patch, (int)3), (String)"\n") + "\n";
    }

    public List<Integer> getRelevantPageNums(int currentPageNum) {
        return this.getRelevantPageNums(currentPageNum, this.getMaxPageNum());
    }

    public List<Integer> getRelevantPageNums(int currentPageNum, int maxPageNum) {
        int i;
        int epsilon = 2;
        HashSet<Integer> pageNumsSet = new HashSet<Integer>();
        pageNumsSet.add(0);
        pageNumsSet.add(maxPageNum);
        if (maxPageNum > 10) {
            pageNumsSet.add(currentPageNum);
            for (i = currentPageNum; i <= Math.min(currentPageNum + 2, maxPageNum); ++i) {
                pageNumsSet.add(i);
            }
            for (i = currentPageNum; i >= Math.max(0, currentPageNum - 2); --i) {
                pageNumsSet.add(i);
            }
        } else {
            for (i = 0; i <= maxPageNum; ++i) {
                pageNumsSet.add(i);
            }
        }
        ArrayList<Integer> pageNumsList = new ArrayList<Integer>(pageNumsSet);
        pageNumsList.sort(Comparator.naturalOrder());
        int lastNumber = (Integer)pageNumsList.get(0);
        for (int i2 = 1; i2 < pageNumsList.size(); ++i2) {
            int thisNumber = pageNumsList.get(i2);
            if (lastNumber + 1 != thisNumber) {
                pageNumsList.add(i2++, -1);
            }
            lastNumber = thisNumber;
        }
        return pageNumsList;
    }

    public int getMaxEntriesPerPage() {
        String maxEntriesPerPage = this.getPlugin().getMaxEntriesPerPage();
        try {
            return maxEntriesPerPage == null || maxEntriesPerPage.isEmpty() ? 25 : Integer.parseInt(maxEntriesPerPage);
        }
        catch (NumberFormatException e) {
            LOG.log(Level.WARNING, "Configured MaxEntriesPerPage does not represent an integer: {0}. Falling back to default.", maxEntriesPerPage);
            return 25;
        }
    }

    public int getMaxPageNum() {
        String entriesPerPageStr = this.getCurrentRequest().getParameter("entriesPerPage");
        if (entriesPerPageStr != null && entriesPerPageStr.equals("all")) {
            return 0;
        }
        int entriesPerPage = entriesPerPageStr != null && !entriesPerPageStr.isEmpty() ? Integer.parseInt(entriesPerPageStr) : this.getMaxEntriesPerPage();
        int revisionAmount = this.getRevisionAmount();
        int div = revisionAmount / entriesPerPage;
        return revisionAmount % entriesPerPage == 0 ? div - 1 : div;
    }

    public void doDiffFiles(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        String timestamp1 = req.getParameter("timestamp1");
        String timestamp2 = req.getParameter("timestamp2");
        if (PluginUtils.parsedDate(timestamp1).after(PluginUtils.parsedDate(timestamp2))) {
            timestamp1 = req.getParameter("timestamp2");
            timestamp2 = req.getParameter("timestamp1");
        }
        rsp.sendRedirect("showDiffFiles?timestamp1=" + timestamp1 + "&timestamp2=" + timestamp2);
    }

    public final void doDiffFilesPrevNext(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String timestamp1 = req.getParameter("timestamp1");
        String timestamp2 = req.getParameter("timestamp2");
        rsp.sendRedirect("showDiffFiles?timestamp1=" + timestamp1 + "&timestamp2=" + timestamp2);
    }

    protected StaplerRequest getCurrentRequest() {
        return Stapler.getCurrentRequest();
    }

    protected JobConfigHistory getPlugin() {
        return PluginUtils.getPlugin();
    }

    protected HistoryDao getHistoryDao() {
        return PluginUtils.getHistoryDao();
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"}, justification="Unsure where the NPE can be thrown, so ok for the moment.")
    private Writer sort(File file) throws IOException {
        StringWriter stringWriter;
        block8: {
            BufferedReader source = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);
            try {
                InputStream xslt = JobConfigHistoryBaseAction.class.getResourceAsStream("xslt/sort.xslt");
                Objects.requireNonNull(xslt);
                Transformer transformer = this.transformerFactory.newTransformer(new StreamSource(xslt));
                StringWriter result = new StringWriter();
                transformer.transform(new SAXSource(new InputSource(source)), new StreamResult(result));
                transformer.reset();
                stringWriter = result;
                if (source == null) break block8;
            }
            catch (Throwable xslt) {
                try {
                    if (source != null) {
                        try {
                            ((Reader)source).close();
                        }
                        catch (Throwable throwable) {
                            xslt.addSuppressed(throwable);
                        }
                    }
                    throw xslt;
                }
                catch (NullPointerException | TransformerException | TransformerFactoryConfigurationError e) {
                    LogRecord lr = new LogRecord(Level.WARNING, "Diff may have extra changes for XML config {0}");
                    lr.setParameters(new Object[]{file.toPath()});
                    lr.setThrown(e);
                    LOG.log(lr);
                    StringWriter fallback = new StringWriter();
                    new XmlFile(file).writeRawTo((Writer)fallback);
                    return fallback;
                }
            }
            ((Reader)source).close();
        }
        return stringWriter;
    }

    protected final List<SideBySideView.Line> getLines(XmlFile leftConfig, XmlFile rightConfig, boolean hideVersionDiffs) throws IOException {
        String[] leftLines = this.sort(leftConfig.getFile()).toString().split("\\n");
        String[] rightLines = this.sort(rightConfig.getFile()).toString().split("\\n");
        String diffAsString = this.getDiffAsString(leftConfig.getFile(), rightConfig.getFile(), leftLines, rightLines, hideVersionDiffs);
        List<String> diffLines = Arrays.asList(diffAsString.split("\n"));
        return this.getDiffLines(diffLines);
    }
}

