/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.Extension;
import hudson.XmlFile;
import hudson.maven.MavenModule;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.plugins.jobConfigHistory.FileHistoryDao;
import hudson.plugins.jobConfigHistory.HistoryDao;
import hudson.plugins.jobConfigHistory.Messages;
import hudson.plugins.jobConfigHistory.PluginUtils;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Symbol(value={"jobConfigHistory"})
@Extension
public class JobConfigHistory
extends GlobalConfiguration {
    private static final PermissionGroup PERMISSION_GROUP = new PermissionGroup(JobConfigHistory.class, Messages._displayName());
    protected static final Permission DELETEENTRY_PERMISSION = new Permission(PERMISSION_GROUP, Messages.JobConfigHistory_deleteEntryPermission(), Messages._JobConfigHistory_deleteEntryPermissionDescription(), Jenkins.ADMINISTER, true, new PermissionScope[]{PermissionScope.ITEM, PermissionScope.COMPUTER});
    private static final Logger LOG = Logger.getLogger(JobConfigHistory.class.getName());
    private String historyRootDir;
    private String maxHistoryEntries;
    private String maxEntriesPerPage;
    private String maxDaysToKeepEntries;
    private String excludedUsers;
    private boolean skipDuplicateHistory = true;
    private String excludePattern = "queue\\.xml|nodeMonitors\\.xml|UpdateCenter\\.xml|global-build-stats|LockableResourcesManager\\.xml|MilestoneStep\\.xml|cloudbees-disk-usage-simple\\.xml";
    private transient Pattern excludeRegexpPattern;
    private boolean saveModuleConfiguration = false;
    private String showBuildBadges = "always";
    private boolean showChangeReasonCommentWindow = true;

    @DataBoundConstructor
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="The Descriptor#load documentation states that \"The constructor of the derived class must call this method\".")
    public JobConfigHistory() {
        this.load();
        this.loadRegexpPatterns();
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        try (BulkChange bc = new BulkChange((Saveable)this);){
            req.bindJSON((Object)this, formData);
            bc.commit();
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed to save " + this.getConfigFile(), e);
        }
        return true;
    }

    protected XmlFile getConfigFile() {
        return new XmlFile(new File(Jenkins.get().getRootDir(), "jobConfigHistory.xml"));
    }

    public String getDefaultRootDir() {
        return "config-history";
    }

    public String getHistoryRootDir() {
        return this.historyRootDir;
    }

    @DataBoundSetter
    public void setHistoryRootDir(String historyRootDir) {
        this.historyRootDir = historyRootDir;
        this.save();
    }

    public String getMaxHistoryEntries() {
        return this.maxHistoryEntries;
    }

    @DataBoundSetter
    public void setMaxHistoryEntries(String maxEntryInput) {
        String trimmedValue;
        String string = trimmedValue = maxEntryInput == null || maxEntryInput.trim().isEmpty() ? null : maxEntryInput.trim();
        if (trimmedValue == null || this.isPositiveInteger(trimmedValue)) {
            this.maxHistoryEntries = trimmedValue;
        }
        this.save();
    }

    public String getMaxEntriesPerPage() {
        return this.maxEntriesPerPage;
    }

    @DataBoundSetter
    public void setMaxEntriesPerPage(String maxEntryInput) {
        String trimmedValue;
        String string = trimmedValue = maxEntryInput == null || maxEntryInput.trim().isEmpty() ? null : maxEntryInput.trim();
        if (trimmedValue == null || this.isPositiveInteger(trimmedValue)) {
            this.maxEntriesPerPage = trimmedValue;
        }
        this.save();
    }

    public String getMaxDaysToKeepEntries() {
        return this.maxDaysToKeepEntries;
    }

    @DataBoundSetter
    public void setMaxDaysToKeepEntries(String maxDaysInput) {
        String trimmedValue;
        String string = trimmedValue = maxDaysInput == null || maxDaysInput.trim().isEmpty() ? null : maxDaysInput.trim();
        if (trimmedValue == null || this.isPositiveInteger(trimmedValue)) {
            this.maxDaysToKeepEntries = trimmedValue;
        }
        this.save();
    }

    public boolean isPositiveInteger(String numberString) {
        try {
            int number = Integer.parseInt(numberString);
            if (number < 0) {
                throw new NumberFormatException();
            }
            return true;
        }
        catch (NumberFormatException e) {
            LOG.log(Level.WARNING, "No positive integer: {0}", numberString);
            return false;
        }
    }

    @Deprecated
    public boolean getSaveItemGroupConfiguration() {
        return true;
    }

    public boolean getSkipDuplicateHistory() {
        return this.skipDuplicateHistory;
    }

    @DataBoundSetter
    public void setSkipDuplicateHistory(boolean skipDuplicateHistory) {
        this.skipDuplicateHistory = skipDuplicateHistory;
        this.save();
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    @DataBoundSetter
    public void setExcludePattern(String excludePattern) {
        this.excludePattern = excludePattern;
        this.loadRegexpPatterns();
        this.save();
    }

    public boolean getSaveModuleConfiguration() {
        return this.saveModuleConfiguration;
    }

    @DataBoundSetter
    public void setSaveModuleConfiguration(boolean saveModuleConfiguration) {
        this.saveModuleConfiguration = saveModuleConfiguration;
        this.save();
    }

    public String getShowBuildBadges() {
        return this.showBuildBadges;
    }

    @DataBoundSetter
    public void setShowBuildBadges(String showBuildBadges) {
        this.showBuildBadges = showBuildBadges;
        this.save();
    }

    public boolean getShowChangeReasonCommentWindow() {
        return this.showChangeReasonCommentWindow;
    }

    @DataBoundSetter
    public void setShowChangeReasonCommentWindow(boolean showChangeReasonCommentWindow) {
        this.showChangeReasonCommentWindow = showChangeReasonCommentWindow;
        this.save();
    }

    public boolean showBuildBadges(Job<?, ?> project) {
        if ("always".equals(this.showBuildBadges)) {
            return true;
        }
        if ("userWithConfigPermission".equals(this.showBuildBadges) && project.hasPermission(Item.CONFIGURE)) {
            return true;
        }
        return "adminUser".equals(this.showBuildBadges) && this.getJenkins().hasPermission(Jenkins.ADMINISTER);
    }

    public Pattern getExcludeRegexpPattern() {
        return this.excludeRegexpPattern;
    }

    private void loadRegexpPatterns() {
        this.excludeRegexpPattern = this.loadRegex(this.excludePattern);
    }

    private Pattern loadRegex(String patternString) {
        if (patternString != null) {
            try {
                return Pattern.compile(patternString);
            }
            catch (PatternSyntaxException e) {
                return null;
            }
        }
        return null;
    }

    public File getConfiguredHistoryRootDir() {
        File jenkinsHome = this.getJenkinsHome();
        File rootDir = this.historyRootDir == null ? new File(jenkinsHome, "config-history") : (this.historyRootDir.matches("^(/|\\\\|[a-zA-Z]:).*") ? new File(this.historyRootDir + "/config-history") : new File(jenkinsHome, this.historyRootDir + "/config-history"));
        return rootDir;
    }

    public File getConfigFile(File historyDir) {
        return FileHistoryDao.getConfigFile(historyDir);
    }

    public String getExcludedUsers() {
        return this.excludedUsers;
    }

    @DataBoundSetter
    public void setExcludedUsers(String excludedUsers) {
        this.excludedUsers = excludedUsers;
        this.save();
    }

    public boolean isSaveable(Saveable item, XmlFile xmlFile) {
        boolean canSave = this.checkRegex(xmlFile);
        if (!canSave) {
            LOG.log(Level.FINE, "skipped recording change history for job {0}", xmlFile.getFile().getAbsolutePath());
            return false;
        }
        if (item instanceof TopLevelItem) {
            return true;
        }
        if (xmlFile.getFile().getParentFile().equals(this.getJenkinsHome())) {
            return canSave;
        }
        return PluginUtils.isMavenPluginAvailable() && item instanceof MavenModule && this.saveModuleConfiguration;
    }

    private boolean checkRegex(XmlFile xmlFile) {
        if (this.excludeRegexpPattern != null) {
            String fullPath = xmlFile.getFile().getAbsolutePath();
            Matcher matcher = this.excludeRegexpPattern.matcher(fullPath);
            return !matcher.find();
        }
        return true;
    }

    public FormValidation doCheckMaxHistoryEntries(@QueryParameter String value) {
        String trimmedValue;
        String string = trimmedValue = value == null || value.trim().isEmpty() ? null : value.trim();
        if (trimmedValue == null || this.isPositiveInteger(trimmedValue)) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)"Enter a valid positive integer");
    }

    public FormValidation doCheckMaxEntriesPerPage(@QueryParameter String value) {
        String trimmedValue;
        String string = trimmedValue = value == null || value.trim().isEmpty() ? null : value.trim();
        if (trimmedValue == null || this.isPositiveInteger(trimmedValue)) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)"Enter a valid positive integer");
    }

    public FormValidation doCheckMaxDaysToKeepEntries(@QueryParameter String value) {
        String trimmedValue;
        String string = trimmedValue = value == null || value.trim().isEmpty() ? null : value.trim();
        if (trimmedValue == null || this.isPositiveInteger(trimmedValue)) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)"Enter a valid positive integer");
    }

    public FormValidation doCheckExcludePattern(@QueryParameter String value) {
        try {
            Pattern.compile(value);
            return FormValidation.ok();
        }
        catch (PatternSyntaxException e) {
            return FormValidation.error((String)"Enter a valid regular expression");
        }
    }

    protected HistoryDao getHistoryDao() {
        return PluginUtils.getHistoryDao(this);
    }

    protected File getJenkinsHome() {
        return Jenkins.get().getRootDir();
    }

    @Deprecated
    public Jenkins getJenkins() {
        return Jenkins.get();
    }
}

