/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.plugins.jobConfigHistory.ConfigInfo;
import hudson.plugins.jobConfigHistory.DeletedFileFilter;
import hudson.plugins.jobConfigHistory.FileNameComparator;
import hudson.plugins.jobConfigHistory.HistoryDescr;
import hudson.plugins.jobConfigHistory.HistoryDescrToConfigInfo;
import hudson.plugins.jobConfigHistory.OverviewHistoryDao;
import hudson.plugins.jobConfigHistory.PluginUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

final class ConfigInfoCollector {
    private final List<ConfigInfo> configs = new ArrayList<ConfigInfo>();
    private final String type;
    private final OverviewHistoryDao overViewhistoryDao;

    public ConfigInfoCollector(String type, OverviewHistoryDao overviewHistoryDao) {
        this.type = type;
        this.overViewhistoryDao = overviewHistoryDao;
    }

    void getConfigsForType(File itemDir, String folderName) {
        boolean isNotADeletedJob;
        String jobsString = "/jobs/";
        Object itemName = folderName.isEmpty() ? itemDir.getName() : folderName + "/jobs/" + itemDir.getName();
        ArrayList<HistoryDescr> historyEntries = new ArrayList<HistoryDescr>(this.overViewhistoryDao.getJobHistory((String)itemName).values());
        if (historyEntries.isEmpty()) {
            return;
        }
        boolean isADeletedJob = DeletedFileFilter.accepts((String)itemName);
        boolean bl = isNotADeletedJob = !isADeletedJob;
        if ("created".equals(this.type)) {
            if (isADeletedJob) {
                return;
            }
            for (HistoryDescr descr : historyEntries) {
                if (!"Created".equals(descr.getOperation())) continue;
                ConfigInfo config = ConfigInfo.create((String)itemName, true, descr, true);
                this.configs.add(config);
                return;
            }
        } else if ("deleted".equals(this.type)) {
            HistoryDescr histDescr = (HistoryDescr)historyEntries.get(historyEntries.size() - 1);
            if ("Deleted".equals(histDescr.getOperation())) {
                ConfigInfo config = ConfigInfo.create((String)itemName, false, histDescr, false);
                this.configs.add(config);
            }
        } else {
            this.configs.addAll(HistoryDescrToConfigInfo.convert((String)itemName, true, historyEntries, isNotADeletedJob));
        }
    }

    public List<ConfigInfo> collect(String folderName) throws IOException {
        File[] itemDirs = "deleted".equals(this.type) ? this.overViewhistoryDao.getDeletedJobs(folderName) : (File[])ArrayUtils.addAll((Object[])this.overViewhistoryDao.getDeletedJobs(folderName), (Object[])this.overViewhistoryDao.getJobs(folderName));
        Arrays.sort(itemDirs, FileNameComparator.INSTANCE);
        for (File itemDir : itemDirs) {
            this.getConfigsForType(itemDir, folderName);
        }
        return this.configs;
    }

    public List<ConfigInfo> collect() throws IOException {
        File[] itemDirs = "deleted".equals(this.type) ? this.overViewhistoryDao.getDeletedJobs() : (File[])ArrayUtils.addAll((Object[])this.overViewhistoryDao.getDeletedJobs(), (Object[])this.overViewhistoryDao.getJobs());
        Arrays.sort(itemDirs, FileNameComparator.INSTANCE);
        for (File itemDir : itemDirs) {
            String folderName = this.getFolderName(itemDir);
            this.getConfigsForType(itemDir, folderName);
        }
        return this.configs;
    }

    private String getFolderName(File file) {
        if (this.isJobInFolder(file)) {
            File nextAncestor = file.getParentFile().getParentFile();
            StringBuilder folderName = new StringBuilder();
            File jobConfigHistoryJobDirection = new File(PluginUtils.getPlugin().getConfiguredHistoryRootDir(), "jobs");
            while (nextAncestor.isDirectory() && !nextAncestor.toString().equals(jobConfigHistoryJobDirection.toString())) {
                folderName.insert(0, nextAncestor.getName() + (folderName.length() == 0 ? "" : "/"));
                nextAncestor = nextAncestor.getParentFile();
            }
            return folderName.toString();
        }
        return "";
    }

    private boolean isJobInFolder(File file) {
        File grandparentDir;
        File jobConfigHistoryRootDirection = PluginUtils.getPlugin().getConfiguredHistoryRootDir();
        File parent = file.getParentFile();
        String grandparent = null;
        if (parent != null && (grandparentDir = parent.getParentFile()) != null) {
            grandparent = parent.getParentFile().toString();
        }
        if (grandparent != null) {
            return !grandparent.equals(jobConfigHistoryRootDirection.toString());
        }
        return false;
    }
}

