/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import com.github.difflib.text.DiffRow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class SideBySideView {
    private final List<Line> lines = new ArrayList<Line>();

    public List<Line> getLines() {
        return Collections.unmodifiableList(this.lines);
    }

    public void addLine(Line line) {
        this.lines.add(line);
    }

    public void clearDuplicateLines() {
        TreeMap<Integer, Line> linesByNumbers = new TreeMap<Integer, Line>();
        ArrayList<Line> dupes = new ArrayList<Line>();
        Iterator<Line> iter = this.lines.iterator();
        while (iter.hasNext()) {
            Line line = iter.next();
            String lineNum = line.left.getLineNumber();
            if (lineNum.length() == 0) continue;
            int lineNumInt = Integer.parseInt(lineNum);
            if (linesByNumbers.containsKey(lineNumInt)) {
                if (line.getTag() == DiffRow.Tag.EQUAL) {
                    iter.remove();
                    continue;
                }
                dupes.add((Line)linesByNumbers.get(lineNumInt));
                continue;
            }
            linesByNumbers.put(lineNumInt, line);
        }
        this.lines.removeAll(dupes);
    }

    public static class Line {
        private final Item left = new Item();
        private final Item right = new Item();
        private boolean skipping;
        private DiffRow.Tag tag;

        public Item getLeft() {
            return this.left;
        }

        public Item getRight() {
            return this.right;
        }

        public boolean isSkipping() {
            return this.skipping;
        }

        public void setSkipping(boolean skipping) {
            this.skipping = skipping;
        }

        public DiffRow.Tag getTag() {
            return this.tag;
        }

        public void setTag(DiffRow.Tag tag) {
            this.tag = tag;
        }

        public static class Item {
            private Integer lineNumber;
            private String text;
            private String cssClass;

            public String getLineNumber() {
                return this.lineNumber == null ? "" : String.valueOf(this.lineNumber);
            }

            public void setLineNumber(Integer lineNumber) {
                this.lineNumber = lineNumber;
            }

            public String getText() {
                return this.text;
            }

            public void setText(String text) {
                this.text = text;
            }

            public String getCssClass() {
                return this.cssClass;
            }

            public void setCssClass(String cssClass) {
                this.cssClass = cssClass;
            }
        }
    }
}

