/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.XmlFile;
import hudson.model.AbstractProject;
import hudson.plugins.jobConfigHistory.ConfigInfo;
import hudson.plugins.jobConfigHistory.ConfigInfoComparator;
import hudson.plugins.jobConfigHistory.HistoryDescr;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import hudson.plugins.jobConfigHistory.JobConfigHistoryBaseAction;
import hudson.security.AccessControlled;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobConfigHistoryProjectAction
extends JobConfigHistoryBaseAction {
    private static final Logger LOG = Logger.getLogger(JobConfigHistoryProjectAction.class.getName());
    private final transient AbstractProject<?, ?> project;

    public JobConfigHistoryProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public final List<ConfigInfo> getConfigs() throws IOException {
        this.checkConfigurePermission();
        ArrayList<ConfigInfo> configs = new ArrayList<ConfigInfo>();
        File historyRootDir = this.getPlugin().getHistoryDir(this.project.getConfigFile());
        if (!historyRootDir.isDirectory()) {
            LOG.info(historyRootDir + " is not a directory, assuming that no history exists yet.");
            return Collections.emptyList();
        }
        for (File historyDir : historyRootDir.listFiles(JobConfigHistory.HISTORY_FILTER)) {
            XmlFile historyXml = new XmlFile(new File(historyDir, "history.xml"));
            HistoryDescr histDescr = (HistoryDescr)historyXml.read();
            ConfigInfo config = ConfigInfo.create(this.project, historyDir, histDescr);
            configs.add(config);
        }
        Collections.sort(configs, ConfigInfoComparator.INSTANCE);
        return configs;
    }

    public final AbstractProject<?, ?> getProject() {
        return this.project;
    }

    @Override
    protected AccessControlled getAccessControlledObject() {
        return this.project;
    }

    @Override
    protected void checkConfigurePermission() {
        this.getAccessControlledObject().checkPermission(AbstractProject.CONFIGURE);
    }

    @Override
    protected boolean hasConfigurePermission() {
        return this.getAccessControlledObject().hasPermission(AbstractProject.CONFIGURE);
    }
}

