/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import bmsi.util.Diff;
import bmsi.util.DiffPrint;
import hudson.XmlFile;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import hudson.plugins.jobConfigHistory.Messages;
import hudson.security.AccessControlled;
import hudson.util.MultipartFormDataParser;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class JobConfigHistoryBaseAction
implements Action {
    private final Hudson hudson = Hudson.getInstance();

    public final String getDisplayName() {
        return Messages.displayName();
    }

    public final String getIconFileName() {
        return this.hasConfigurePermission() ? "/plugin/jobConfigHistory/img/confighistory.png" : null;
    }

    public String getUrlName() {
        return "jobConfigHistory";
    }

    public final boolean wantRawOutput() {
        return this.isTypeParameter("raw");
    }

    public final boolean wantXmlOutput() {
        return this.isTypeParameter("xml");
    }

    public final String getFile() throws IOException {
        this.checkConfigurePermission();
        XmlFile xmlFile = this.getConfigXml(this.getRequestParameter("file"));
        return xmlFile.asString();
    }

    private boolean isTypeParameter(String toCompare) {
        return this.getRequestParameter("type").equalsIgnoreCase(toCompare);
    }

    protected XmlFile getConfigXml(String diffDir) {
        JobConfigHistory plugin = (JobConfigHistory)this.hudson.getPlugin(JobConfigHistory.class);
        File configuredHistoryRootDir = plugin.getConfiguredHistoryRootDir();
        String allowedHistoryRootDir = configuredHistoryRootDir == null ? this.getHudson().getRootDir().getAbsolutePath() : configuredHistoryRootDir.getAbsolutePath();
        File configFile = null;
        if (diffDir != null) {
            if (!diffDir.startsWith(allowedHistoryRootDir) || diffDir.contains("..")) {
                throw new IllegalArgumentException(diffDir + " does not start with " + allowedHistoryRootDir + " or contains '..'");
            }
            if (configuredHistoryRootDir == null && !diffDir.contains("config-history")) {
                throw new IllegalArgumentException(diffDir + " does not contain '" + "config-history" + "'");
            }
            configFile = plugin.getConfigFile(new File(diffDir));
        }
        if (configFile == null) {
            throw new IllegalArgumentException("Unable to get history from: " + diffDir);
        }
        return new XmlFile(configFile);
    }

    protected String getRequestParameter(String parameterName) {
        return Stapler.getCurrentRequest().getParameter(parameterName);
    }

    protected abstract void checkConfigurePermission();

    protected abstract boolean hasConfigurePermission();

    protected final Hudson getHudson() {
        return this.hudson;
    }

    protected final JobConfigHistory getPlugin() {
        return (JobConfigHistory)this.hudson.getPlugin(JobConfigHistory.class);
    }

    protected abstract AccessControlled getAccessControlledObject();

    public final void doDiffFiles(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        MultipartFormDataParser parser = new MultipartFormDataParser((HttpServletRequest)req);
        rsp.sendRedirect("showDiffFiles?histDir1=" + parser.get("histDir1") + "&histDir2=" + parser.get("histDir2"));
    }

    public final String getDiffFile() throws IOException {
        this.checkConfigurePermission();
        XmlFile configXml1 = this.getConfigXml(this.getRequestParameter("histDir1"));
        String[] configXml1Lines = configXml1.asString().split("\\n");
        XmlFile configXml2 = this.getConfigXml(this.getRequestParameter("histDir2"));
        String[] configXml2Lines = configXml2.asString().split("\\n");
        return this.getDiff(configXml1.getFile(), configXml2.getFile(), configXml1Lines, configXml2Lines);
    }

    protected final String getDiff(File file1, File file2, String[] file1Lines, String[] file2Lines) {
        Diff.change change2 = new Diff(file1Lines, file2Lines).diff_2(false);
        DiffPrint.UnifiedPrint unifiedPrint = new DiffPrint.UnifiedPrint(file1Lines, file2Lines);
        StringWriter output = new StringWriter();
        unifiedPrint.setOutput(output);
        unifiedPrint.print_header(file1.getPath(), file2.getPath());
        unifiedPrint.print_script(change2);
        return output.toString();
    }
}

