/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.Util;
import hudson.XmlFile;
import hudson.model.Hudson;
import hudson.model.User;
import hudson.plugins.jobConfigHistory.HistoryDescr;
import hudson.plugins.jobConfigHistory.JobConfigHistory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ConfigHistoryListenerHelper {
    CREATED("Created"),
    RENAMED("Renamed"),
    CHANGED("Changed"),
    DELETED("Deleted");

    private static final Logger LOG;
    private final String operation;

    private ConfigHistoryListenerHelper(String operation) {
        this.operation = operation;
    }

    private File getRootDir(XmlFile xmlFile, Calendar timestamp) {
        JobConfigHistory plugin = (JobConfigHistory)Hudson.getInstance().getPlugin(JobConfigHistory.class);
        File itemHistoryDir = plugin.getHistoryDir(xmlFile);
        plugin.checkForPurgeByQuantity(itemHistoryDir);
        File f = new File(itemHistoryDir, this.getIdFormatter().format(timestamp.getTime()));
        if (!f.mkdirs() && !f.exists()) {
            throw new RuntimeException("Could not create rootDir " + f);
        }
        return f;
    }

    public final void createNewHistoryEntry(XmlFile xmlFile) {
        try {
            GregorianCalendar timestamp = new GregorianCalendar();
            File timestampedDir = this.getRootDir(xmlFile, timestamp);
            if (this != DELETED) {
                this.copyConfigFile(xmlFile.getFile(), timestampedDir);
            }
            this.createHistoryXmlFile(timestamp, timestampedDir);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Unable to create history entry for configuration file: " + xmlFile, e);
        }
        catch (RuntimeException e) {
            LOG.log(Level.SEVERE, "Unable to create history entry for configuration file: " + xmlFile, e);
        }
    }

    private void createHistoryXmlFile(Calendar timestamp, File timestampedDir) throws IOException {
        String userId;
        String user;
        User currentUser = this.getCurrentUser();
        if (currentUser != null) {
            user = currentUser.getFullName();
            userId = currentUser.getId();
        } else {
            user = "Anonym";
            userId = "anonymous";
        }
        XmlFile historyDescription = new XmlFile(new File(timestampedDir, "history.xml"));
        HistoryDescr myDescr = new HistoryDescr(user, userId, this.operation, this.getIdFormatter().format(timestamp.getTime()));
        historyDescription.write((Object)myDescr);
    }

    User getCurrentUser() {
        return User.current();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyConfigFile(File currentConfig, File timestampedDir) throws FileNotFoundException, IOException {
        FileOutputStream configCopy = new FileOutputStream(new File(timestampedDir, currentConfig.getName()));
        try {
            FileInputStream configOriginal = new FileInputStream(currentConfig);
            try {
                Util.copyStream((InputStream)configOriginal, (OutputStream)configCopy);
            }
            finally {
                configOriginal.close();
            }
        }
        finally {
            configCopy.close();
        }
    }

    SimpleDateFormat getIdFormatter() {
        return new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    }

    static {
        LOG = Logger.getLogger(ConfigHistoryListenerHelper.class.getName());
    }
}

