/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jobimport.model;

import com.google.common.base.Objects;
import java.io.Serializable;
import org.jenkins.ci.plugins.jobimport.model.RemoteFolder;
import org.jenkins.ci.plugins.jobimport.utils.RemoteItemUtils;

public abstract class RemoteItem
implements Serializable,
Comparable<RemoteItem> {
    protected final String name;
    protected final String fullName;
    protected final String impl;
    protected final String url;
    protected final String description;
    protected final RemoteFolder parent;

    protected RemoteItem(String name, String impl, String url, String description, RemoteFolder parent) {
        this.name = name;
        this.impl = impl;
        this.url = url;
        this.description = RemoteItemUtils.cleanRemoteString(description);
        this.parent = parent;
        this.fullName = this.getFullName();
    }

    public abstract boolean isFolder();

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return RemoteItemUtils.fullName(this);
    }

    public String getUrl() {
        return this.url;
    }

    public String getDescription() {
        return this.description;
    }

    public RemoteFolder getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getFullName(), this.impl});
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoteItem) {
            return Objects.equal((Object)this.impl, (Object)((RemoteItem)obj).impl) && Objects.equal((Object)this.getFullName(), (Object)((RemoteItem)obj).getFullName());
        }
        return false;
    }

    @Override
    public int compareTo(RemoteItem o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.getFullName().compareTo(o.getFullName());
    }
}

