/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ci.plugins.jobimport;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.RootAction;
import hudson.model.TopLevelItem;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ci.plugins.jobimport.Messages;
import org.jenkins.ci.plugins.jobimport.MessagesUtils;
import org.jenkins.ci.plugins.jobimport.RemoteItemImportStatus;
import org.jenkins.ci.plugins.jobimport.client.RestApiClient;
import org.jenkins.ci.plugins.jobimport.model.RemoteFolder;
import org.jenkins.ci.plugins.jobimport.model.RemoteItem;
import org.jenkins.ci.plugins.jobimport.utils.CredentialsUtils;
import org.jenkins.ci.plugins.jobimport.utils.RemoteItemUtils;
import org.jenkins.ci.plugins.jobimport.utils.URLUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public final class JobImportAction
implements RootAction,
Describable<JobImportAction> {
    private static final Logger LOG = Logger.getLogger(JobImportAction.class.getName());
    private String remoteUrl;
    private String localFolder;
    private String credentialId;
    private String recursiveSearch;
    private final SortedSet<RemoteItem> remoteJobs = new TreeSet<RemoteItem>();
    private final SortedMap<RemoteItem, RemoteItemImportStatus> remoteJobsImportStatus = new TreeMap<RemoteItem, RemoteItemImportStatus>();

    public void doClear(StaplerRequest request, StaplerResponse response) throws ServletException, IOException {
        this.remoteUrl = null;
        this.credentialId = null;
        this.localFolder = null;
        this.recursiveSearch = null;
        this.remoteJobs.clear();
        this.remoteJobsImportStatus.clear();
        response.sendRedirect(Jenkins.getActiveInstance().getRootUrl());
    }

    public void doImport(StaplerRequest request, StaplerResponse response) throws ServletException, IOException {
        this.remoteJobsImportStatus.clear();
        this.localFolder = request.getParameter("localFolder");
        if (this.isRemoteJobsAvailable() && request.hasParameter("jobUrl")) {
            for (String jobUrl : Arrays.asList(request.getParameterValues("jobUrl"))) {
                this.doImportInternal(jobUrl, this.localFolder);
            }
        }
        response.forwardToPreviousPage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doImportInternal(String jobUrl, String localPath) throws IOException {
        InputStream inputStream;
        block13: {
            RemoteItem remoteJob = RemoteItemUtils.getRemoteJob(this.remoteJobs, jobUrl);
            if (remoteJob == null) return;
            if (!this.remoteJobsImportStatus.containsKey(remoteJob)) {
                this.remoteJobsImportStatus.put(remoteJob, new RemoteItemImportStatus(remoteJob));
            }
            if (StringUtils.isNotEmpty((String)localPath) && Jenkins.getActiveInstance().getItemByFullName(localPath + remoteJob.getName()) != null) {
                ((RemoteItemImportStatus)this.remoteJobsImportStatus.get(remoteJob)).setStatus(MessagesUtils.formatFailedDuplicateJobName());
                return;
            }
            if (StringUtils.isEmpty((String)localPath) && Jenkins.getActiveInstance().getItem(remoteJob.getName()) != null) {
                ((RemoteItemImportStatus)this.remoteJobsImportStatus.get(remoteJob)).setStatus(MessagesUtils.formatFailedDuplicateJobName());
                return;
            }
            inputStream = null;
            CredentialsUtils.NullSafeCredentials credentials = CredentialsUtils.getCredentials(this.credentialId);
            try {
                inputStream = URLUtils.fetchUrl(remoteJob.getUrl() + "/config.xml", credentials.username, credentials.password);
                TopLevelItem newItem = StringUtils.isNotEmpty((String)localPath) ? ((Folder)Jenkins.getActiveInstance().getItemByFullName(localPath, Folder.class)).createProjectFromXML(remoteJob.getFullName(), inputStream) : Jenkins.getActiveInstance().createProjectFromXML(remoteJob.getFullName(), inputStream);
                if (newItem != null) {
                    newItem.save();
                }
                ((RemoteItemImportStatus)this.remoteJobsImportStatus.get(remoteJob)).setStatus(MessagesUtils.formatSuccess());
                if (!remoteJob.isFolder() || !((RemoteFolder)remoteJob).hasChildren()) break block13;
                for (RemoteItem childJob : ((RemoteFolder)remoteJob).getChildren()) {
                    this.doImportInternal(childJob.getUrl(), newItem.getFullName());
                }
            }
            catch (Exception e) {
                try {
                    LOG.warning("Job Import Failed: " + e.getMessage());
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.log(Level.INFO, e.getMessage(), e);
                    }
                    ((RemoteItemImportStatus)this.remoteJobsImportStatus.get(remoteJob)).setStatus(MessagesUtils.formatFailedException(e));
                    try {
                        TopLevelItem created = Jenkins.getActiveInstance().getItem(remoteJob.getName());
                        if (created != null) {
                            created.delete();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                return;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return;
    }

    public void doQuery(StaplerRequest request, StaplerResponse response) throws ServletException, IOException {
        this.remoteJobs.clear();
        this.remoteJobsImportStatus.clear();
        this.remoteUrl = request.getParameter("remoteUrl");
        this.credentialId = request.getParameter("_.credentialId");
        this.recursiveSearch = request.getParameter("recursiveSearch");
        this.doQueryInternal(null, this.remoteUrl, CredentialsUtils.getCredentials(this.credentialId));
        response.forwardToPreviousPage(request);
    }

    private void doQueryInternal(RemoteFolder parent, String url, CredentialsUtils.NullSafeCredentials credentials) {
        this.remoteJobs.addAll(RestApiClient.getRemoteItems(parent, url, credentials, this.isRecursive(this.recursiveSearch)));
    }

    private boolean isRecursive(String param) {
        return StringUtils.equals((String)"on", (String)param);
    }

    public FormValidation doTestConnection(@QueryParameter(value="remoteUrl") String remoteUrl) {
        return FormValidation.ok();
    }

    public String getRootUrl() {
        return Jenkins.getActiveInstance().getRootUrl();
    }

    public String getDisplayName() {
        return Messages.DisplayName();
    }

    public String getIconFileName() {
        return "/images/32x32/setting.png";
    }

    public SortedSet<RemoteItem> getRemoteJobs() {
        return this.remoteJobs;
    }

    public SortedMap<RemoteItem, RemoteItemImportStatus> getRemoteJobsImportStatus() {
        return this.remoteJobsImportStatus;
    }

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public String getUrlName() {
        return "/job-import";
    }

    public boolean isRemoteJobsAvailable() {
        return this.remoteJobs.size() > 0;
    }

    public boolean isRemoteJobsImportStatusAvailable() {
        return this.remoteJobsImportStatus.size() > 0;
    }

    public void setRemoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public String getLocalFolder() {
        return this.localFolder;
    }

    public void setLocalFolder(String localFolder) {
        this.localFolder = localFolder;
    }

    public Descriptor<JobImportAction> getDescriptor() {
        return Jenkins.getActiveInstance().getDescriptorOrDie(this.getClass());
    }

    @Extension
    public static final class JobImportActionDescriptor
    extends Descriptor<JobImportAction> {
        public String getDisplayName() {
            return "";
        }

        public ListBoxModel doFillCredentialIdItems() {
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(Jenkins.getAuthentication(), (ItemGroup)Jenkins.getInstance(), StandardUsernamePasswordCredentials.class, Collections.emptyList(), CredentialsMatchers.always()).includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.getInstance(), StandardUsernamePasswordCredentials.class, Collections.emptyList(), CredentialsMatchers.always());
        }
    }
}

