/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira.selector;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.plugins.jira.selector.AbstractIssueSelector;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class ExplicitIssueSelector
extends AbstractIssueSelector {
    @CheckForNull
    private List<String> jiraIssueKeys;
    private String issueKeys;

    @DataBoundConstructor
    public ExplicitIssueSelector(String issueKeys) {
        this.jiraIssueKeys = StringUtils.isNotBlank((String)issueKeys) ? Lists.newArrayList((Object[])issueKeys.split(",")) : Collections.emptyList();
        this.issueKeys = issueKeys;
    }

    public ExplicitIssueSelector(List<String> jiraIssueKeys) {
        this.jiraIssueKeys = jiraIssueKeys;
    }

    public ExplicitIssueSelector() {
        this.jiraIssueKeys = Collections.emptyList();
    }

    public void setIssueKeys(String issueKeys) {
        this.issueKeys = issueKeys;
        this.jiraIssueKeys = Lists.newArrayList((Object[])issueKeys.split(","));
    }

    public String getIssueKeys() {
        return this.issueKeys;
    }

    @Override
    public Set<String> findIssueIds(Run<?, ?> run, JiraSite site, TaskListener listener) {
        return Sets.newHashSet(this.jiraIssueKeys);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<AbstractIssueSelector> {
        public String getDisplayName() {
            return Messages.IssueSelector_ExplicitIssueSelector_DisplayName();
        }
    }
}

