/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira.pipeline;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.plugins.jira.selector.AbstractIssueSelector;
import java.util.Collection;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class IssueSelectorStep
extends AbstractStepImpl {
    private AbstractIssueSelector issueSelector;

    @DataBoundConstructor
    public IssueSelectorStep() {
    }

    @DataBoundSetter
    public void setIssueSelector(AbstractIssueSelector issueSelector) {
        this.issueSelector = issueSelector;
    }

    public AbstractIssueSelector getIssueSelector() {
        return this.issueSelector;
    }

    public static class IssueSelectorStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Set<String>> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient IssueSelectorStep step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Run run;

        protected Set<String> run() throws Exception {
            JiraSite site = JiraSite.get(this.run.getParent());
            Set<String> ids = this.step.getIssueSelector().findIssueIds(this.run, site, this.listener);
            return ids;
        }
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(IssueSelectorStepExecution.class);
        }

        public Collection<? extends Descriptor<?>> getApplicableDescriptors() {
            return Jenkins.getInstance().getDescriptorList(AbstractIssueSelector.class);
        }

        public String getFunctionName() {
            return "jiraIssueSelector";
        }

        public String getDisplayName() {
            return Messages.IssueSelectorStep_Descriptor_DisplayName();
        }
    }
}

