/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira.pipeline;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class CommentStep
extends AbstractStepImpl {
    public final String issueKey;
    public final String body;

    @DataBoundConstructor
    public CommentStep(@Nonnull String issueKey, @Nonnull String body) {
        this.issueKey = issueKey;
        this.body = body;
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public String getBody() {
        return this.body;
    }

    public static class CommentStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient CommentStep step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Run run;

        protected Void run() {
            JiraSite site = JiraSite.get(this.run.getParent());
            JiraSession session = site.getSession();
            if (session == null) {
                this.listener.getLogger().println(Messages.FailedToConnect());
                return null;
            }
            session.addComment(this.step.issueKey, this.step.body, site.groupVisibility, site.roleVisibility);
            return null;
        }
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(CommentStepExecution.class);
        }

        public String getFunctionName() {
            return "jiraComment";
        }

        public String getDisplayName() {
            return Messages.CommentStep_Descriptor_DisplayName();
        }
    }
}

