/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira.listissuesparameter;

import com.atlassian.jira.rest.client.api.domain.Issue;
import hudson.Extension;
import hudson.Util;
import hudson.cli.CLICommand;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.listissuesparameter.JiraIssueParameterValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class JiraIssueParameterDefinition
extends ParameterDefinition {
    private static final long serialVersionUID = 3927562542249244416L;
    private String jiraIssueFilter;

    @DataBoundConstructor
    public JiraIssueParameterDefinition(String name, String description, String jiraIssueFilter) {
        super(name, description);
        this.jiraIssueFilter = jiraIssueFilter;
    }

    public ParameterValue createValue(StaplerRequest req) {
        String[] values = req.getParameterValues(this.getName());
        if (values == null || values.length != 1) {
            return null;
        }
        return new JiraIssueParameterValue(this.getName(), values[0]);
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject formData) {
        JiraIssueParameterValue value = (JiraIssueParameterValue)((Object)req.bindJSON(JiraIssueParameterValue.class, formData));
        return value;
    }

    public ParameterValue createValue(CLICommand command, String value) throws IOException, InterruptedException {
        return new JiraIssueParameterValue(this.getName(), value);
    }

    public List<Result> getIssues() throws IOException, TimeoutException {
        Job context = (Job)Stapler.getCurrentRequest().findAncestorObject(Job.class);
        JiraSite site = JiraSite.get(context);
        if (site == null) {
            throw new IllegalStateException("JIRA site needs to be configured in the project " + context.getFullDisplayName());
        }
        JiraSession session = site.getSession();
        if (session == null) {
            throw new IllegalStateException("Remote access for JIRA isn't configured in Jenkins");
        }
        List<Issue> issues = session.getIssuesFromJqlSearch(this.jiraIssueFilter);
        ArrayList<Result> issueValues = new ArrayList<Result>();
        for (Issue issue : Util.fixNull(issues)) {
            issueValues.add(new Result(issue));
        }
        return issueValues;
    }

    public String getJiraIssueFilter() {
        return this.jiraIssueFilter;
    }

    public void setJiraIssueFilter(String jiraIssueFilter) {
        this.jiraIssueFilter = jiraIssueFilter;
    }

    public static class Result {
        public final String key;
        public final String summary;

        public Result(Issue issue) {
            this.key = issue.getKey();
            this.summary = issue.getSummary();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "JIRA Issue Parameter";
        }
    }
}

