/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jira.JiraBuildAction;
import hudson.plugins.jira.JiraCarryOverAction;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.plugins.jira.RunScmChangeExtractor;
import hudson.plugins.jira.model.JiraIssue;
import hudson.plugins.jira.selector.AbstractIssueSelector;
import hudson.scm.ChangeLogSet;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

class Updater {
    private SCM scm;
    private List<String> labels;
    private static final Logger LOGGER = Logger.getLogger(Updater.class.getName());
    public static boolean debug = false;

    public Updater(SCM scm) {
        this(scm, new ArrayList<String>());
    }

    public Updater(SCM scm, List<String> labels) {
        this.scm = scm;
        this.labels = labels == null ? new ArrayList<String>() : labels;
    }

    boolean perform(Run<?, ?> build, TaskListener listener, AbstractIssueSelector selector) {
        block9: {
            PrintStream logger = listener.getLogger();
            Set<JiraIssue> issues = null;
            try {
                JiraSite site = JiraSite.get(build.getParent());
                if (site == null) {
                    logger.println(Messages.NoJiraSite());
                    build.setResult(Result.FAILURE);
                    return true;
                }
                String rootUrl = Hudson.getInstance().getRootUrl();
                if (rootUrl == null) {
                    logger.println(Messages.NoJenkinsUrl());
                    build.setResult(Result.FAILURE);
                    return true;
                }
                Set<String> ids = selector.findIssueIds(build, site, listener);
                if (ids.isEmpty()) {
                    if (debug) {
                        logger.println("No JIRA issues found.");
                    }
                    return true;
                }
                JiraSession session = site.getSession();
                if (session == null) {
                    logger.println(Messages.NoRemoteAccess());
                    build.setResult(Result.FAILURE);
                    return true;
                }
                boolean doUpdate = false;
                doUpdate = site.updateJiraIssueForAllStatus || build.getResult() == null ? true : build.getResult().isBetterOrEqualTo(Result.UNSTABLE);
                boolean useWikiStyleComments = site.supportsWikiStyleComment;
                issues = Updater.getJiraIssues(ids, session, logger);
                build.addAction((Action)new JiraBuildAction(build, issues));
                if (doUpdate) {
                    this.submitComments(build, logger, rootUrl, issues, session, useWikiStyleComments, site.recordScmChanges, site.groupVisibility, site.roleVisibility);
                } else {
                    build.addAction((Action)new JiraCarryOverAction(issues));
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error updating JIRA issues. Saving issues for next build.", e);
                logger.println("Error updating JIRA issues. Saving issues for next build.\n" + e);
                if (issues == null || issues.isEmpty()) break block9;
                build.addAction((Action)new JiraCarryOverAction(issues));
            }
        }
        return true;
    }

    void submitComments(Run<?, ?> build, PrintStream logger, String jenkinsRootUrl, Set<JiraIssue> issues, JiraSession session, boolean useWikiStyleComments, boolean recordScmChanges, String groupVisibility, String roleVisibility) throws RestClientException {
        ImmutableSet copy = ImmutableSet.copyOf(issues);
        for (JiraIssue issue : copy) {
            logger.println(Messages.UpdatingIssue(issue.getKey()));
            try {
                session.addComment(issue.getKey(), this.createComment(build, useWikiStyleComments, jenkinsRootUrl, recordScmChanges, issue), groupVisibility, roleVisibility);
                if (!this.labels.isEmpty()) {
                    session.addLabels(issue.getKey(), this.labels);
                }
            }
            catch (RestClientException e) {
                if (((Integer)e.getStatusCode().or((Object)0)).equals(404)) {
                    logger.println(issue.getKey() + " - JIRA issue not found. Dropping comment from update queue.");
                }
                if (((Integer)e.getStatusCode().or((Object)0)).equals(403)) {
                    logger.println(issue.getKey() + " - Jenkins JIRA user does not have permissions to comment on this issue. Preserving comment for future update.");
                    continue;
                }
                if (((Integer)e.getStatusCode().or((Object)0)).equals(401)) {
                    logger.println(issue.getKey() + " - Jenkins JIRA authentication problem. Preserving comment for future update.");
                    continue;
                }
                logger.println(Messages.FailedToUpdateIssueWithCarryOver(issue.getKey()));
                logger.println(e.getLocalizedMessage());
            }
            issues.remove(issue);
        }
    }

    private static Set<JiraIssue> getJiraIssues(Set<String> ids, JiraSession session, PrintStream logger) throws RemoteException {
        LinkedHashSet<JiraIssue> issues = new LinkedHashSet<JiraIssue>(ids.size());
        for (String id : ids) {
            Issue issue = session.getIssue(id);
            if (issue == null) {
                logger.println(id + " issue doesn't exist in JIRA");
                continue;
            }
            issues.add(new JiraIssue(issue));
        }
        return issues;
    }

    private String createComment(Run<?, ?> build, boolean wikiStyle, String jenkinsRootUrl, boolean recordScmChanges, JiraIssue jiraIssue) {
        Result result = build.getResult();
        if (result == null) {
            return String.format(wikiStyle ? "Integrated in [%2$s|%3$s]\n%4$s" : "Integrated in Jenkins build %2$s (See [%3$s])\n%4$s", jenkinsRootUrl, build, Util.encode((String)(jenkinsRootUrl + build.getUrl())), this.getScmComments(wikiStyle, build, recordScmChanges, jiraIssue));
        }
        return String.format(wikiStyle ? "%6$s: Integrated in !%1$simages/16x16/%3$s! [%2$s|%4$s]\n%5$s" : "%6$s: Integrated in Jenkins build %2$s (See [%4$s])\n%5$s", jenkinsRootUrl, build, result != null ? result.color.getImage() : null, Util.encode((String)(jenkinsRootUrl + build.getUrl())), this.getScmComments(wikiStyle, build, recordScmChanges, jiraIssue), result.toString());
    }

    private String getScmComments(boolean wikiStyle, Run<?, ?> run, boolean recordScmChanges, JiraIssue jiraIssue) {
        JiraCarryOverAction a;
        Run prev;
        StringBuilder comment = new StringBuilder();
        RepositoryBrowser<?> repoBrowser = this.getRepositoryBrowser(run);
        for (ChangeLogSet<? extends ChangeLogSet.Entry> set : RunScmChangeExtractor.getChanges(run)) {
            for (ChangeLogSet.Entry change : set) {
                if (jiraIssue != null && !StringUtils.containsIgnoreCase((String)change.getMsg(), (String)jiraIssue.getKey())) continue;
                comment.append(this.createScmChangeEntryDescription(run, change, wikiStyle, recordScmChanges));
            }
        }
        if (jiraIssue != null && (prev = run.getPreviousBuild()) != null && (a = (JiraCarryOverAction)prev.getAction(JiraCarryOverAction.class)) != null && a.getIDs().contains(jiraIssue.getKey())) {
            comment.append(this.getScmComments(wikiStyle, prev, recordScmChanges, jiraIssue));
        }
        return comment.toString();
    }

    protected String createScmChangeEntryDescription(Run<?, ?> run, ChangeLogSet.Entry change, boolean wikiStyle, boolean recordScmChanges) {
        String revision;
        StringBuilder description = new StringBuilder();
        RepositoryBrowser<?> repoBrowser = this.getRepositoryBrowser(run);
        JiraSite site = JiraSite.get(run.getParent());
        if (change.getMsg() != null) {
            description.append(change.getMsg());
        }
        if ((revision = Updater.getRevision(change)) != null) {
            description.append(" (");
            this.appendAuthorToDescription(change, description);
            if (site.isAppendChangeTimestamp() && change.getTimestamp() > 0L) {
                this.appendChangeTimestampToDescription(description, site, change.getTimestamp());
                description.append(" ");
            }
            this.appendRevisionToDescription(change, wikiStyle, description, repoBrowser, revision);
            description.append(")");
        }
        description.append("\n");
        if (recordScmChanges) {
            this.appendAffectedFilesToDescription(change, description);
        }
        return description.toString();
    }

    protected void appendAuthorToDescription(ChangeLogSet.Entry change, StringBuilder description) {
        if (change.getAuthor() != null) {
            change.getAuthor();
            String uid = change.getAuthor().getId();
            if (StringUtils.isNotBlank((String)uid)) {
                description.append(uid).append(": ");
            }
        }
    }

    protected void appendRevisionToDescription(ChangeLogSet.Entry change, boolean wikiStyle, StringBuilder description, RepositoryBrowser repoBrowser, String revision) {
        URL url = null;
        if (repoBrowser != null) {
            try {
                url = repoBrowser.getChangeSetLink(change);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to calculate SCM repository browser link", e);
            }
        }
        if (url != null && StringUtils.isNotBlank((String)url.toExternalForm())) {
            if (wikiStyle) {
                description.append("[").append(revision).append("|");
                description.append(url.toExternalForm()).append("]");
            } else {
                description.append("[").append(url.toExternalForm()).append("]");
            }
        } else {
            description.append("rev ").append(revision);
        }
    }

    protected void appendAffectedFilesToDescription(ChangeLogSet.Entry change, StringBuilder description) {
        try {
            for (ChangeLogSet.AffectedFile affectedFile : change.getAffectedFiles()) {
                description.append("* ");
                if (affectedFile.getEditType() != null) {
                    description.append("(").append(affectedFile.getEditType().getName()).append(") ");
                }
                if (affectedFile.getPath() != null) {
                    description.append(affectedFile.getPath());
                }
                description.append("\n");
            }
        }
        catch (UnsupportedOperationException e) {
            LOGGER.warning("Unsupported SCM operation 'getAffectedFiles'. Fall back to getAffectedPaths.");
            for (String affectedPath : change.getAffectedPaths()) {
                description.append("* ").append(affectedPath).append("\n");
            }
        }
    }

    protected void appendChangeTimestampToDescription(StringBuilder description, JiraSite site, long timestamp) {
        DateFormat df = null;
        df = !Strings.isNullOrEmpty((String)site.getDateTimePattern()) ? new SimpleDateFormat(site.getDateTimePattern()) : DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        Date changeDate = new Date(timestamp);
        String dateTimeString = df.format(changeDate);
        description.append(dateTimeString);
    }

    private RepositoryBrowser<?> getRepositoryBrowser(Run<?, ?> run) {
        SCM scm = this.getScm();
        if (scm != null) {
            return scm.getEffectiveBrowser();
        }
        return null;
    }

    private static String getRevision(ChangeLogSet.Entry entry) {
        String commitId = entry.getCommitId();
        if (commitId != null) {
            return commitId;
        }
        try {
            Class<?> clazz = entry.getClass();
            Method method = clazz.getMethod("getRevision", null);
            if (method == null) {
                return null;
            }
            Object revObj = method.invoke((Object)entry, (Object[])null);
            return revObj != null ? revObj.toString() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private SCM getScm() {
        return this.scm;
    }
}

