/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import com.google.common.collect.Maps;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.scm.ChangeLogSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RunScmChangeExtractor {
    private static final String GET_CHANGESET_METHOD = "getChangeSets";
    private static final String CANNOT_ACCESS_GET_CHANGESET_METHOD = "cannot call getChangeSets";

    private RunScmChangeExtractor() {
    }

    public static List<ChangeLogSet<? extends ChangeLogSet.Entry>> getChanges(Run<?, ?> run) {
        if (run instanceof AbstractBuild) {
            ChangeLogSet cs = ((AbstractBuild)run).getChangeSet();
            return cs.isEmptySet() ? Collections.emptyList() : Collections.singletonList(cs);
        }
        if (run == null) {
            throw new IllegalStateException("run cannot be null!");
        }
        return RunScmChangeExtractor.getChangesUsingReflection(run);
    }

    static List<ChangeLogSet<? extends ChangeLogSet.Entry>> getChangesUsingReflection(Run<?, ?> run) {
        Method getChangeSetMethod = null;
        for (Method method : run.getClass().getMethods()) {
            if (!method.getName().equals(GET_CHANGESET_METHOD) || !List.class.isAssignableFrom(method.getReturnType())) continue;
            getChangeSetMethod = method;
            break;
        }
        if (getChangeSetMethod != null) {
            try {
                Object result = getChangeSetMethod.invoke(run, new Object[0]);
                return (List)result;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(CANNOT_ACCESS_GET_CHANGESET_METHOD, e);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(CANNOT_ACCESS_GET_CHANGESET_METHOD, e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(CANNOT_ACCESS_GET_CHANGESET_METHOD, e);
            }
        }
        throw new IllegalArgumentException("Unsupported Run type " + run.getClass().getName());
    }

    public static Map<AbstractProject, AbstractBuild.DependencyChange> getDependencyChanges(Run<?, ?> run) {
        Run previousBuild;
        if (run instanceof AbstractBuild && (previousBuild = run.getPreviousBuild()) instanceof AbstractBuild) {
            return ((AbstractBuild)run).getDependencyChanges((AbstractBuild)previousBuild);
        }
        return Maps.newHashMap();
    }
}

