/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.Version;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.plugins.jira.CredentialsHelper;
import hudson.plugins.jira.JiraFolderProperty;
import hudson.plugins.jira.JiraProjectProperty;
import hudson.plugins.jira.JiraRestService;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.Messages;
import hudson.plugins.jira.model.JiraIssue;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class JiraSite
extends AbstractDescribableImpl<JiraSite> {
    private static final Logger LOGGER = Logger.getLogger(JiraSite.class.getName());
    public static final Pattern DEFAULT_ISSUE_PATTERN = Pattern.compile("([a-zA-Z][a-zA-Z0-9_]+-[1-9][0-9]*)([^.]|\\.[^0-9]|\\.$|$)");
    public static final int DEFAULT_TIMEOUT = 10;
    public final URL url;
    public final URL alternativeUrl;
    public final boolean useHTTPAuth;
    public final String credentialsId;
    public final transient UsernamePasswordCredentials credentials;
    @Deprecated
    private transient String userName;
    @Deprecated
    private transient Secret password;
    public final String groupVisibility;
    public final String roleVisibility;
    public final boolean supportsWikiStyleComment;
    public final boolean recordScmChanges;
    public boolean disableChangelogAnnotations;
    private final String userPattern;
    private transient Pattern userPat;
    public final boolean updateJiraIssueForAllStatus;
    public Integer timeout;
    private String dateTimePattern;
    private Boolean appendChangeTimestamp;
    private volatile transient Set<String> projects;
    private transient Cache<String, Optional<Issue>> issueCache = JiraSite.makeIssueCache();
    private transient Lock projectUpdateLock = new ReentrantLock();
    private transient JiraSession jiraSession;

    @DataBoundConstructor
    public JiraSite(URL url, @CheckForNull URL alternativeUrl, @CheckForNull String credentialsId, boolean supportsWikiStyleComment, boolean recordScmChanges, @CheckForNull String userPattern, boolean updateJiraIssueForAllStatus, @CheckForNull String groupVisibility, @CheckForNull String roleVisibility, boolean useHTTPAuth) {
        this(url, alternativeUrl, CredentialsHelper.lookupSystemCredentials(credentialsId, url), supportsWikiStyleComment, recordScmChanges, userPattern, updateJiraIssueForAllStatus, groupVisibility, roleVisibility, useHTTPAuth);
    }

    @Deprecated
    public JiraSite(URL url, @CheckForNull URL alternativeUrl, String userName, String password, boolean supportsWikiStyleComment, boolean recordScmChanges, @CheckForNull String userPattern, boolean updateJiraIssueForAllStatus, @CheckForNull String groupVisibility, @CheckForNull String roleVisibility, boolean useHTTPAuth) {
        this(url, alternativeUrl, CredentialsHelper.migrateCredentials(userName, password, url), supportsWikiStyleComment, recordScmChanges, userPattern, updateJiraIssueForAllStatus, groupVisibility, roleVisibility, useHTTPAuth);
    }

    public JiraSite(URL url, URL alternativeUrl, StandardUsernamePasswordCredentials credentials, boolean supportsWikiStyleComment, boolean recordScmChanges, String userPattern, boolean updateJiraIssueForAllStatus, String groupVisibility, String roleVisibility, boolean useHTTPAuth) {
        if (url != null && !url.toExternalForm().endsWith("/")) {
            try {
                url = new URL(url.toExternalForm() + "/");
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        if (alternativeUrl != null && !alternativeUrl.toExternalForm().endsWith("/")) {
            try {
                alternativeUrl = new URL(alternativeUrl.toExternalForm() + "/");
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        this.url = url;
        this.timeout = 10;
        this.alternativeUrl = alternativeUrl;
        this.credentials = credentials;
        this.credentialsId = credentials != null ? credentials.getId() : null;
        this.supportsWikiStyleComment = supportsWikiStyleComment;
        this.recordScmChanges = recordScmChanges;
        this.userPattern = Util.fixEmpty((String)userPattern);
        this.userPat = this.userPattern != null ? Pattern.compile(this.userPattern) : null;
        this.updateJiraIssueForAllStatus = updateJiraIssueForAllStatus;
        this.groupVisibility = Util.fixEmpty((String)groupVisibility);
        this.roleVisibility = Util.fixEmpty((String)roleVisibility);
        this.useHTTPAuth = useHTTPAuth;
        this.jiraSession = null;
    }

    @DataBoundSetter
    public void setDisableChangelogAnnotations(boolean disableChangelogAnnotations) {
        this.disableChangelogAnnotations = disableChangelogAnnotations;
    }

    public boolean getDisableChangelogAnnotations() {
        return this.disableChangelogAnnotations;
    }

    @DataBoundSetter
    public void setTimeout(Integer timeoutSec) {
        this.timeout = timeoutSec;
    }

    @DataBoundSetter
    public void setDateTimePattern(String dateTimePattern) {
        this.dateTimePattern = dateTimePattern;
    }

    @DataBoundSetter
    public void setAppendChangeTimestamp(Boolean appendChangeTimestamp) {
        this.appendChangeTimestamp = appendChangeTimestamp;
    }

    public String getDateTimePattern() {
        return this.dateTimePattern;
    }

    public boolean isAppendChangeTimestamp() {
        return this.appendChangeTimestamp != null && this.appendChangeTimestamp != false;
    }

    protected Object readResolve() {
        if (this.credentialsId == null && this.userName != null && this.password != null) {
            return new JiraSite(this.url, this.alternativeUrl, this.userName, this.password.getPlainText(), this.supportsWikiStyleComment, this.recordScmChanges, this.userPattern, this.updateJiraIssueForAllStatus, this.groupVisibility, this.roleVisibility, this.useHTTPAuth);
        }
        return new JiraSite(this.url, this.alternativeUrl, this.credentialsId, this.supportsWikiStyleComment, this.recordScmChanges, this.userPattern, this.updateJiraIssueForAllStatus, this.groupVisibility, this.roleVisibility, this.useHTTPAuth);
    }

    private static Cache<String, Optional<Issue>> makeIssueCache() {
        return CacheBuilder.newBuilder().concurrencyLevel(2).expireAfterAccess(2L, TimeUnit.MINUTES).build();
    }

    public String getName() {
        return this.url.toExternalForm();
    }

    @Nullable
    public JiraSession getSession() {
        if (this.jiraSession == null) {
            this.jiraSession = this.createSession();
        }
        return this.jiraSession;
    }

    protected JiraSession createSession() {
        URI uri;
        if (this.credentials == null) {
            return null;
        }
        try {
            uri = this.url.toURI();
        }
        catch (URISyntaxException e) {
            LOGGER.warning("convert URL to URI error: " + e.getMessage());
            throw new RuntimeException("failed to create JiraSession due to convert URI error");
        }
        LOGGER.fine("creating JIRA Session: " + uri);
        String userName = this.credentials.getUsername();
        Secret password = this.credentials.getPassword();
        JiraRestClient jiraRestClient = new AsynchronousJiraRestClientFactory().createWithBasicHttpAuthentication(uri, userName, password.getPlainText());
        int usedTimeout = this.timeout != null ? this.timeout : 10;
        return new JiraSession(this, new JiraRestService(uri, jiraRestClient, userName, password.getPlainText(), usedTimeout));
    }

    @Nullable
    public URL getUrl() {
        return (URL)Objects.firstNonNull((Object)this.url, (Object)this.alternativeUrl);
    }

    public URL getUrl(JiraIssue issue) throws IOException {
        return this.getUrl(issue.getKey());
    }

    public URL getUrl(String id) throws MalformedURLException {
        return new URL(this.url, "browse/" + id.toUpperCase());
    }

    public URL getAlternativeUrl(String id) throws MalformedURLException {
        return this.alternativeUrl == null ? null : new URL(this.alternativeUrl, "browse/" + id.toUpperCase());
    }

    public Pattern getUserPattern() {
        if (this.userPattern == null) {
            return null;
        }
        if (this.userPat == null) {
            this.userPat = Pattern.compile(this.userPattern);
        }
        return this.userPat;
    }

    public Pattern getIssuePattern() {
        Pattern result = this.getUserPattern();
        return result == null ? DEFAULT_ISSUE_PATTERN : result;
    }

    public Set<String> getProjectKeys() {
        Set<String> p;
        block8: {
            if (this.projects == null) {
                try {
                    if (!this.projectUpdateLock.tryLock(3L, TimeUnit.SECONDS)) break block8;
                    try {
                        JiraSession session = this.getSession();
                        if (session != null) {
                            this.projects = Collections.unmodifiableSet(session.getProjectKeys());
                        }
                    }
                    finally {
                        this.projectUpdateLock.unlock();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if ((p = this.projects) == null) {
            return Collections.emptySet();
        }
        return p;
    }

    public static JiraSite get(Job<?, ?> p) {
        JiraSite site;
        JiraProjectProperty jpp = (JiraProjectProperty)p.getProperty(JiraProjectProperty.class);
        if (jpp != null && (site = jpp.getSite()) != null) {
            return site;
        }
        ItemGroup parent = p.getParent();
        while (parent != null) {
            JiraSite[] sites;
            AbstractFolder folder;
            JiraFolderProperty jfp;
            if (parent instanceof AbstractFolder && (jfp = (JiraFolderProperty)(folder = (AbstractFolder)parent).getProperties().get(JiraFolderProperty.class)) != null && (sites = jfp.getSites()) != null && sites.length > 0) {
                return sites[0];
            }
            if (parent instanceof Item) {
                parent = ((Item)parent).getParent();
                continue;
            }
            parent = null;
        }
        JiraSite[] sites = JiraProjectProperty.DESCRIPTOR.getSites();
        if (sites.length == 1) {
            return sites[0];
        }
        return null;
    }

    @CheckForNull
    public JiraIssue getIssue(String id) throws IOException {
        try {
            Optional issue = (Optional)this.issueCache.get((Object)id, () -> {
                JiraSession session = this.getSession();
                if (session == null) {
                    return null;
                }
                return Optional.fromNullable((Object)session.getIssue(id));
            });
            if (!issue.isPresent()) {
                return null;
            }
            return new JiraIssue((Issue)issue.get());
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    public Set<Version> getVersions(String projectKey) {
        JiraSession session = this.getSession();
        if (session == null) {
            LOGGER.warning("JIRA session could not be established");
            return Collections.emptySet();
        }
        return new HashSet<Version>(session.getVersions(projectKey));
    }

    public String getReleaseNotesForFixVersion(String projectKey, String versionName, String filter) throws TimeoutException {
        JiraSession session = this.getSession();
        if (session == null) {
            LOGGER.warning("JIRA session could not be established");
            return "";
        }
        List<Issue> issues = session.getIssuesWithFixVersion(projectKey, versionName, filter);
        if (issues.isEmpty()) {
            return "";
        }
        HashMap releaseNotes = new HashMap();
        for (Issue issue : issues) {
            Set<String> issueSet;
            String key = issue.getKey();
            String summary = issue.getSummary();
            String status = issue.getStatus().getName();
            String type = issue.getIssueType().getName();
            if (releaseNotes.containsKey(type)) {
                issueSet = (Set)releaseNotes.get(type);
            } else {
                issueSet = new HashSet();
                releaseNotes.put(type, issueSet);
            }
            issueSet.add(String.format(" - [%s] %s (%s)", key, summary, status));
        }
        StringBuilder sb = new StringBuilder();
        for (String type : releaseNotes.keySet()) {
            sb.append(String.format("# %s\n", type));
            for (String issue : (Set)releaseNotes.get(type)) {
                sb.append(issue);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public void replaceFixVersion(String projectKey, String fromVersion, String toVersion, String query) throws TimeoutException {
        JiraSession session = this.getSession();
        if (session == null) {
            LOGGER.warning("JIRA session could not be established");
            return;
        }
        session.replaceFixVersion(projectKey, fromVersion, toVersion, query);
    }

    public void migrateIssuesToFixVersion(String projectKey, String versionName, String query) throws TimeoutException {
        JiraSession session = this.getSession();
        if (session == null) {
            LOGGER.warning("JIRA session could not be established");
            return;
        }
        session.migrateIssuesToFixVersion(projectKey, versionName, query);
    }

    public void addFixVersionToIssue(String projectKey, String versionName, String query) throws TimeoutException {
        JiraSession session = this.getSession();
        if (session == null) {
            LOGGER.warning("JIRA session could not be established");
            return;
        }
        session.addFixVersion(projectKey, versionName, query);
    }

    public boolean progressMatchingIssues(String jqlSearch, String workflowActionName, String comment, PrintStream console) throws TimeoutException {
        JiraSession session = this.getSession();
        if (session == null) {
            LOGGER.warning("JIRA session could not be established");
            console.println(Messages.FailedToConnect());
            return false;
        }
        boolean success = true;
        List<Issue> issues = session.getIssuesFromJqlSearch(jqlSearch);
        if (StringUtils.isEmpty((String)workflowActionName)) {
            console.println("[JIRA] No workflow action was specified, thus no status update will be made for any of the matching issues.");
        }
        for (Issue issue : issues) {
            String issueKey = issue.getKey();
            if (StringUtils.isNotEmpty((String)comment)) {
                session.addComment(issueKey, comment, null, null);
            }
            if (StringUtils.isEmpty((String)workflowActionName)) continue;
            Integer actionId = session.getActionIdForIssue(issueKey, workflowActionName);
            if (actionId == null) {
                LOGGER.fine(String.format("Invalid workflow action %s for issue %s; issue status = %s", workflowActionName, issueKey, issue.getStatus()));
                console.println(Messages.JiraIssueUpdateBuilder_UnknownWorkflowAction(issueKey, workflowActionName));
                success = false;
                continue;
            }
            String newStatus = session.progressWorkflowAction(issueKey, actionId);
            console.println(String.format("[JIRA] Issue %s transitioned to \"%s\" due to action \"%s\".", issueKey, newStatus, workflowActionName));
        }
        return success;
    }

    static class JiraSiteBuilder {
        private URL mainURL;
        private URL alternativeURL;
        private String credentialsId;
        private boolean supportsWikiStyleComment;
        private boolean recordScmChanges;
        private String userPattern;
        private boolean updateJiraIssueForAllStatus;
        private String groupVisibility;
        private String roleVisibility;
        private boolean useHTTPAuth;

        JiraSiteBuilder() {
        }

        public JiraSiteBuilder withMainURL(URL mainURL) {
            this.mainURL = mainURL;
            return this;
        }

        public JiraSiteBuilder withAlternativeURL(URL alternativeURL) {
            this.alternativeURL = alternativeURL;
            return this;
        }

        public JiraSiteBuilder withCredentialsId(String credentialsId) {
            this.credentialsId = credentialsId;
            return this;
        }

        public JiraSiteBuilder withSupportsWikiStyleComment(boolean supportsWikiStyleComment) {
            this.supportsWikiStyleComment = supportsWikiStyleComment;
            return this;
        }

        public JiraSiteBuilder withRecordScmChanges(boolean recordScmChanges) {
            this.recordScmChanges = recordScmChanges;
            return this;
        }

        public JiraSiteBuilder withUserPattern(String userPattern) {
            this.userPattern = userPattern;
            return this;
        }

        public JiraSiteBuilder withUpdateJiraIssueForAllStatus(boolean updateJiraIssueForAllStatus) {
            this.updateJiraIssueForAllStatus = updateJiraIssueForAllStatus;
            return this;
        }

        public JiraSiteBuilder withGroupVisibility(String groupVisibility) {
            this.groupVisibility = groupVisibility;
            return this;
        }

        public JiraSiteBuilder withRoleVisibility(String roleVisibility) {
            this.roleVisibility = roleVisibility;
            return this;
        }

        public JiraSiteBuilder withUseHTTPAuth(boolean useHTTPAuth) {
            this.useHTTPAuth = useHTTPAuth;
            return this;
        }

        public JiraSite build() {
            return new JiraSite(this.mainURL, this.alternativeURL, this.credentialsId, this.supportsWikiStyleComment, this.recordScmChanges, this.userPattern, this.updateJiraIssueForAllStatus, this.groupVisibility, this.roleVisibility, this.useHTTPAuth);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<JiraSite> {
        public String getDisplayName() {
            return "JIRA Site";
        }

        public FormValidation doValidate(@QueryParameter String url, @QueryParameter String credentialsId, @QueryParameter String groupVisibility, @QueryParameter String roleVisibility, @QueryParameter boolean useHTTPAuth, @QueryParameter String alternativeUrl, @QueryParameter Integer timeout) {
            URL mainURL;
            url = Util.fixEmpty((String)url);
            alternativeUrl = Util.fixEmpty((String)alternativeUrl);
            URL alternativeURL = null;
            try {
                if (url == null) {
                    return FormValidation.error((String)"No URL given");
                }
                mainURL = new URL(url);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)String.format("Malformed URL (%s)", url), (Object[])new Object[]{e});
            }
            try {
                if (alternativeUrl != null) {
                    alternativeURL = new URL(alternativeUrl);
                }
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)String.format("Malformed alternative URL (%s)", alternativeUrl), (Object[])new Object[]{e});
            }
            credentialsId = Util.fixEmpty((String)credentialsId);
            JiraSite site = this.getJiraSiteBuilder().withMainURL(mainURL).withAlternativeURL(alternativeURL).withCredentialsId(credentialsId).withGroupVisibility(groupVisibility).withRoleVisibility(roleVisibility).withUseHTTPAuth(useHTTPAuth).build();
            site.setTimeout(timeout);
            try {
                JiraSession session = site.createSession();
                session.getMyPermissions();
                return FormValidation.ok((String)"Success");
            }
            catch (RestClientException e) {
                LOGGER.log(Level.WARNING, "Failed to login to JIRA at " + url, e);
                return FormValidation.error((String)"Failed to login to JIRA");
            }
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context, @QueryParameter String url) {
            Jenkins _context;
            Object object = _context = context instanceof AccessControlled ? (AccessControlled)context : Jenkins.getInstance();
            if (_context == null || !_context.hasPermission(Jenkins.ADMINISTER)) {
                return new StandardUsernameListBoxModel();
            }
            return new StandardUsernameListBoxModel().withEmptySelection().withAll((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)url).build()));
        }

        JiraSiteBuilder getJiraSiteBuilder() {
            return new JiraSiteBuilder();
        }
    }
}

