/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jira.Messages;
import hudson.plugins.jira.VersionReleaser;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class JiraReleaseVersionUpdaterBuilder
extends Builder
implements SimpleBuildStep {
    private String jiraProjectKey;
    private String jiraRelease;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public JiraReleaseVersionUpdaterBuilder(String jiraProjectKey, String jiraRelease) {
        this.jiraRelease = jiraRelease;
        this.jiraProjectKey = jiraProjectKey;
    }

    public String getJiraRelease() {
        return this.jiraRelease;
    }

    public void setJiraRelease(String jiraRelease) {
        this.jiraRelease = jiraRelease;
    }

    public String getJiraProjectKey() {
        return this.jiraProjectKey;
    }

    public void setJiraProjectKey(String jiraProjectKey) {
        this.jiraProjectKey = jiraProjectKey;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) {
        new VersionReleaser().perform(run.getParent(), this.jiraProjectKey, this.jiraRelease, run, listener);
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private DescriptorImpl() {
            super(JiraReleaseVersionUpdaterBuilder.class);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.JiraReleaseVersionBuilder_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/jira/help.html";
        }

        public JiraReleaseVersionUpdaterBuilder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (JiraReleaseVersionUpdaterBuilder)((Object)req.bindJSON(JiraReleaseVersionUpdaterBuilder.class, formData));
        }
    }
}

