/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.jira.EmptyFriendlyURLConverter;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.util.CopyOnWriteList;
import java.net.URL;
import java.util.Collection;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.Converter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class JiraProjectProperty
extends JobProperty<Job<?, ?>> {
    public final String siteName;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public JiraProjectProperty(String siteName) {
        JiraSite[] sites;
        if (siteName == null && (sites = DESCRIPTOR.getSites()).length > 0) {
            siteName = sites[0].getName();
        }
        this.siteName = siteName;
    }

    public JiraSite getSite() {
        JiraSite[] sites = DESCRIPTOR.getSites();
        if (this.siteName == null && sites.length > 0) {
            return sites[0];
        }
        for (JiraSite site : sites) {
            if (!site.getName().equals(this.siteName)) continue;
            return site;
        }
        return null;
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private final CopyOnWriteList<JiraSite> sites = new CopyOnWriteList();

        public DescriptorImpl() {
            super(JiraProjectProperty.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return Job.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return Messages.JiraProjectProperty_DisplayName();
        }

        public void setSites(JiraSite site) {
            this.sites.add((Object)site);
        }

        public JiraSite[] getSites() {
            return (JiraSite[])this.sites.toArray((Object[])new JiraSite[0]);
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JiraProjectProperty jpp = (JiraProjectProperty)((Object)req.bindParameters(JiraProjectProperty.class, "jira."));
            if (jpp.siteName == null) {
                jpp = null;
            }
            return jpp;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            Stapler.CONVERT_UTILS.deregister(URL.class);
            Stapler.CONVERT_UTILS.register((Converter)new EmptyFriendlyURLConverter(), URL.class);
            this.sites.replaceBy((Collection)req.bindJSONToList(JiraSite.class, formData.get("sites")));
            this.save();
            return true;
        }
    }
}

