/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import com.atlassian.jira.rest.client.api.domain.User;
import hudson.Extension;
import hudson.plugins.jira.JiraProjectProperty;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraSite;
import hudson.tasks.MailAddressResolver;
import java.util.logging.Logger;
import java.util.regex.Pattern;

@Extension
public class JiraMailAddressResolver
extends MailAddressResolver {
    private static final Logger LOGGER = Logger.getLogger(JiraMailAddressResolver.class.getName());
    public static boolean disabled = Boolean.getBoolean(JiraMailAddressResolver.class.getName() + ".disabled");
    private static final String PRE = "[( \\[<_{\"=]+";
    private static final String POST = "[) \\]>_}\"=]+";
    private static final Pattern AT = Pattern.compile("[( \\[<_{\"=]+[aA][tT][) \\]>_}\"=]+");
    private static final Pattern DOT = Pattern.compile("[( \\[<_{\"=]+[dD][oO0][tT][) \\]>_}\"=]+");

    public String findMailAddressFor(hudson.model.User u) {
        if (disabled) {
            return null;
        }
        String username = u.getId();
        for (JiraSite site : JiraProjectProperty.DESCRIPTOR.getSites()) {
            String email;
            User user;
            JiraSession session = site.getSession();
            if (session == null || (user = session.service.getUser(username)) == null || (email = user.getEmailAddress()) == null) continue;
            email = JiraMailAddressResolver.unmaskEmail(email);
            return email;
        }
        return null;
    }

    static String unmaskEmail(String email) {
        email = AT.matcher(email).replaceAll("@");
        email = DOT.matcher(email).replaceAll(".");
        return email;
    }
}

