/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.IssueType;
import com.atlassian.jira.rest.client.api.domain.Priority;
import com.atlassian.jira.rest.client.api.domain.Status;
import com.google.common.base.Splitter;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.jira.JiraProjectProperty;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class JiraCreateIssueNotifier
extends Notifier {
    private static final Logger LOG = Logger.getLogger(JiraCreateIssueNotifier.class.getName());
    private String projectKey;
    private String testDescription;
    private String assignee;
    private String component;
    private Long typeId;
    private Long priorityId;
    private Integer actionIdOnSuccess;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public JiraCreateIssueNotifier(String projectKey, String testDescription, String assignee, String component, Long typeId, Long priorityId, Integer actionIdOnSuccess) {
        if (projectKey == null) {
            throw new IllegalArgumentException("Project key cannot be null");
        }
        this.projectKey = projectKey;
        this.testDescription = testDescription;
        this.assignee = assignee;
        this.component = component;
        this.typeId = typeId;
        this.priorityId = priorityId;
        this.actionIdOnSuccess = actionIdOnSuccess;
    }

    @Deprecated
    public JiraCreateIssueNotifier(String projectKey, String testDescription, String assignee, String component) {
        this(projectKey, testDescription, assignee, component, null, null, null);
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public String getTestDescription() {
        return this.testDescription;
    }

    public void setTestDescription(String testDescription) {
        this.testDescription = testDescription;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public Long getTypeId() {
        return this.typeId;
    }

    public Long getPriorityId() {
        return this.priorityId;
    }

    public Integer getActionIdOnSuccess() {
        return this.actionIdOnSuccess;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        String jobDirPath = build.getProject().getBuildDir().getPath();
        String filename = jobDirPath + File.separator + "issue.txt";
        EnvVars vars = build.getEnvironment(TaskListener.NULL);
        Result currentBuildResult = build.getResult();
        Result previousBuildResult = null;
        AbstractBuild previousBuild = build.getPreviousBuild();
        if (previousBuild != null) {
            previousBuildResult = previousBuild.getResult();
        }
        if (currentBuildResult != Result.ABORTED && previousBuild != null) {
            if (currentBuildResult == Result.FAILURE) {
                this.currentBuildResultFailure(build, listener, previousBuildResult, filename, vars);
            }
            if (currentBuildResult == Result.SUCCESS) {
                this.currentBuildResultSuccess(build, listener, previousBuildResult, filename, vars);
            }
        }
        return true;
    }

    private Issue createJiraIssue(AbstractBuild<?, ?> build, String filename) throws IOException, InterruptedException {
        Long priority;
        EnvVars vars = build.getEnvironment(TaskListener.NULL);
        JiraSession session = this.getJiraSession(build);
        String buildName = this.getBuildName(vars);
        String summary = String.format("Build %s failed", buildName);
        String description = String.format("%s\n\nThe build %s has failed.\nFirst failed run: %s", this.testDescription.equals("") ? "No description is provided" : this.testDescription, buildName, this.getBuildDetailsString(vars));
        Iterable components = Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)this.component);
        Long type = this.typeId;
        if (type == null || type == 0L) {
            LOG.info("Returning default issue type id 1");
            type = 1L;
        }
        if ((priority = this.priorityId) != null && priority == 0L) {
            priority = null;
        }
        Issue issue = session.createIssue(this.projectKey, description, this.assignee, components, summary, type, priority);
        this.writeInFile(filename, issue);
        return issue;
    }

    private Status getStatus(AbstractBuild<?, ?> build, String id) throws IOException {
        JiraSession session = this.getJiraSession(build);
        Issue issue = session.getIssueByKey(id);
        return issue.getStatus();
    }

    private void addComment(AbstractBuild<?, ?> build, BuildListener listener, String id, String comment) throws IOException {
        JiraSession session = this.getJiraSession(build);
        session.addCommentWithoutConstrains(id, comment);
        listener.getLogger().println(String.format("[%s] Commented issue", id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getIssue(String filename) throws IOException, InterruptedException {
        String issueId = "";
        try (BufferedReader br = null;){
            String issue;
            br = new BufferedReader(new FileReader(filename));
            while ((issue = br.readLine()) != null) {
                issueId = issue;
            }
            String string = issueId;
            return string;
        }
    }

    JiraSite getSiteForProject(AbstractProject<?, ?> project) {
        return JiraSite.get(project);
    }

    private JiraSession getJiraSession(AbstractBuild<?, ?> build) throws IOException {
        JiraSite site = this.getSiteForProject(build.getProject());
        if (site == null) {
            throw new IllegalStateException("JIRA site needs to be configured in the project " + build.getFullDisplayName());
        }
        JiraSession session = site.getSession();
        if (session == null) {
            throw new IllegalStateException("Remote access for JIRA isn't configured in Jenkins");
        }
        return session;
    }

    private void deleteFile(String filename) {
        File file = new File(filename);
        if (file.exists() && !file.delete()) {
            LOG.warning("WARNING: couldn't delete file: " + filename);
        }
    }

    private void writeInFile(String Filename, Issue issue) throws FileNotFoundException {
        PrintWriter writer = new PrintWriter(Filename);
        writer.println(issue.getKey());
        writer.close();
    }

    private void currentBuildResultFailure(AbstractBuild<?, ?> build, BuildListener listener, Result previousBuildResult, String filename, EnvVars vars) throws InterruptedException, IOException {
        if (previousBuildResult == Result.FAILURE) {
            String comment = String.format("Build is still failing.\nFailed run: %s", this.getBuildDetailsString(vars));
            String issueId = this.getIssue(filename);
            if (issueId != null) {
                try {
                    Status status = this.getStatus(build, issueId);
                    if (status.getName().equalsIgnoreCase(finishedStatuses.Closed.toString()) || status.getName().equalsIgnoreCase(finishedStatuses.Resolved.toString()) || status.getName().equalsIgnoreCase(finishedStatuses.Done.toString())) {
                        listener.getLogger().println("The previous build also failed but the issue is closed");
                        this.deleteFile(filename);
                        Issue issue = this.createJiraIssue(build, filename);
                        LOG.info(String.format("[%s] created.", issue.getKey()));
                        listener.getLogger().println("Build failed, created JIRA issue " + issue.getKey());
                    } else {
                        this.addComment(build, listener, issueId, comment);
                        LOG.info(String.format("[%s] The previous build also failed, comment added.", issueId));
                    }
                }
                catch (IOException e) {
                    LOG.warning(String.format("[%s] - error processing JIRA change: %s", issueId, e.getMessage()));
                }
            }
        }
        if (previousBuildResult == Result.SUCCESS || previousBuildResult == Result.ABORTED) {
            try {
                Issue issue = this.createJiraIssue(build, filename);
                LOG.info(String.format("[%s] created.", issue.getKey()));
                listener.getLogger().println("Build failed, created JIRA issue " + issue.getKey());
            }
            catch (IOException e) {
                listener.error("Error creating JIRA issue : " + e.getMessage());
                LOG.warning("Error creating JIRA issue\n" + e.getMessage());
            }
        }
    }

    private void currentBuildResultSuccess(AbstractBuild<?, ?> build, BuildListener listener, Result previousBuildResult, String filename, EnvVars vars) throws InterruptedException, IOException {
        if (previousBuildResult == Result.FAILURE || previousBuildResult == Result.SUCCESS) {
            String comment = String.format("Previously failing build now is OK.\n Passed run: %s", this.getBuildDetailsString(vars));
            String issueId = this.getIssue(filename);
            if (issueId != null) {
                try {
                    Status status = this.getStatus(build, issueId);
                    if (status.getName().equalsIgnoreCase(finishedStatuses.Closed.toString()) || status.getName().equalsIgnoreCase(finishedStatuses.Resolved.toString()) || status.getName().equalsIgnoreCase(finishedStatuses.Done.toString())) {
                        LOG.info(String.format("%s is closed", issueId));
                        this.deleteFile(filename);
                    } else {
                        LOG.info(String.format("%s is not closed, comment was added.", issueId));
                        this.addComment(build, listener, issueId, comment);
                        if (this.actionIdOnSuccess != null && this.actionIdOnSuccess > 0) {
                            this.progressWorkflowAction(build, issueId, this.actionIdOnSuccess);
                        }
                    }
                }
                catch (IOException e) {
                    listener.error("Error updating JIRA issue " + issueId + " : " + e.getMessage());
                    LOG.warning("Error updating JIRA issue " + issueId + "\n" + e);
                }
            }
        }
    }

    private void progressWorkflowAction(AbstractBuild<?, ?> build, String issueId, Integer actionId) throws IOException {
        JiraSession session = this.getJiraSession(build);
        session.progressWorkflowAction(issueId, actionId);
    }

    private String getBuildDetailsString(EnvVars vars) {
        String buildURL = (String)vars.get((Object)"BUILD_URL");
        return String.format("[%s|%s] [console log|%s]", this.getBuildName(vars), buildURL, buildURL.concat("console"));
    }

    private String getBuildName(EnvVars vars) {
        String jobName = (String)vars.get((Object)"JOB_NAME");
        String buildNumber = (String)vars.get((Object)"BUILD_NUMBER");
        return String.format("%s #%s", jobName, buildNumber);
    }

    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(JiraCreateIssueNotifier.class);
        }

        public FormValidation doCheckProjectKey(@QueryParameter String value) throws IOException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set the project key");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillPriorityIdItems() {
            ListBoxModel items = new ListBoxModel().add("");
            for (JiraSite site : JiraProjectProperty.DESCRIPTOR.getSites()) {
                JiraSession session = site.getSession();
                if (session == null) continue;
                for (Priority priority : session.getPriorities()) {
                    items.add("[" + site.getName() + "] " + priority.getName(), String.valueOf(priority.getId()));
                }
            }
            return items;
        }

        public ListBoxModel doFillTypeIdItems() {
            ListBoxModel items = new ListBoxModel().add("");
            for (JiraSite site : JiraProjectProperty.DESCRIPTOR.getSites()) {
                JiraSession session = site.getSession();
                if (session == null) continue;
                for (IssueType type : session.getIssueTypes()) {
                    items.add("[" + site.getName() + "] " + type.getName(), String.valueOf(type.getId()));
                }
            }
            return items;
        }

        public JiraCreateIssueNotifier newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (JiraCreateIssueNotifier)((Object)req.bindJSON(JiraCreateIssueNotifier.class, formData));
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.JiraCreateIssueNotifier_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/jira/help-jira-create-issue.html";
        }
    }

    static enum finishedStatuses {
        Closed,
        Done,
        Resolved;

    }
}

