/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.Secret;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;

public class CredentialsHelper {
    private static final Logger LOGGER = Logger.getLogger(CredentialsHelper.class.getName());

    @CheckForNull
    public static StandardUsernamePasswordCredentials lookupSystemCredentials(@CheckForNull String credentialsId, @CheckForNull URL url) {
        if (credentialsId == null) {
            return null;
        }
        return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)(url != null ? url.toExternalForm() : null)).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    public static StandardUsernamePasswordCredentials migrateCredentials(@Nonnull String username, String password, @CheckForNull URL url) {
        List credentials = CredentialsMatchers.filter((List)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)(url != null ? url.toExternalForm() : null)).build()), (CredentialsMatcher)CredentialsMatchers.withUsername((String)username));
        for (StandardUsernamePasswordCredentials c : credentials) {
            if (!StringUtils.equals((String)password, (String)Secret.toString((Secret)c.getPassword()))) continue;
            return c;
        }
        UsernamePasswordCredentialsImpl newCredentials = new UsernamePasswordCredentialsImpl(CredentialsScope.SYSTEM, null, "Migrated by JIRA Plugin", username, password);
        SystemCredentialsProvider.getInstance().getCredentials().add(newCredentials);
        try {
            SystemCredentialsProvider.getInstance().save();
            LOGGER.log(Level.INFO, "Provided username and password were successfully migrated and stored as {0}", newCredentials.getId());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to store migrated credentials", e);
        }
        return newCredentials;
    }
}

