/*
 * Decompiled with CFR 0.152.
 */
package de.pellepelster.jenkins.walldisplay;

import hudson.model.Action;
import hudson.model.Hudson;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class WallDisplayViewAction
implements Action {
    private static final String ENCODING = "UTF-8";
    private String viewName;
    private String viewOwnerUrl;

    public WallDisplayViewAction(String viewName, String viewOwnerUrl) {
        this.viewName = viewName;
        this.viewOwnerUrl = viewOwnerUrl;
    }

    public String getIconFileName() {
        return "/plugin/jenkinswalldisplay/images/icon.png";
    }

    public String getDisplayName() {
        return "Wall Display";
    }

    public String getUrlName() {
        String hudsonUrl = this.getRootUrl();
        try {
            hudsonUrl = URLEncoder.encode(hudsonUrl, ENCODING);
            this.viewName = URLEncoder.encode(this.viewName, ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return String.format("%splugin/jenkinswalldisplay/walldisplay.html?viewName=%s&jenkinsUrl=%s%s", this.getRootUrl(), this.viewName, hudsonUrl, this.viewOwnerUrl);
    }

    public String getRootUrl() {
        return Hudson.getInstance().getRootUrl();
    }
}

