/*
 * Decompiled with CFR 0.152.
 */
package de.pellepelster.jenkins.walldisplay;

import de.pellepelster.jenkins.walldisplay.Configuration;
import de.pellepelster.jenkins.walldisplay.WallDisplayTransientViewActionFactory;
import hudson.Plugin;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.Api;
import hudson.model.Hudson;
import hudson.model.TransientViewActionFactory;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class WallDisplayPlugin
extends Plugin {
    private static final Logger LOGGER = Logger.getLogger("hudson." + WallDisplayPlugin.class.getName());
    public static final String PLUGIN_NAME = "jenkinswalldisplay";
    static final String[] themes = new String[]{"Default", "Plain", "Christmas", "Boss", "Dark", "Colorblind"};
    static final String[] fontFamilies = new String[]{"Sans-Serif", "Arial", "Helvetica", "Verdana"};
    static final String[] buildRange = new String[]{"All", "Active this month", "Active this week", "Active today"};
    static final String[] sortOrder = new String[]{"Job Name", "Job Status", "Job Order"};
    @Exported
    public Configuration config;

    public Api getApi() {
        return new Api((Object)this);
    }

    @Exported
    public Date getDate() {
        return new Date();
    }

    @Exported
    public String getVersion() {
        return Hudson.getInstance().getPluginManager().getPlugin(WallDisplayPlugin.class).getVersion();
    }

    protected Configuration loadConfiguration() throws IOException {
        XmlFile xmlFile = this.getConfigXml();
        Configuration config = null;
        if (xmlFile.exists()) {
            config = (Configuration)xmlFile.read();
            LOGGER.info(String.format("Loaded configuration data: %s", config.toString()));
        } else {
            LOGGER.info("Could not find configuration file, creating empty object");
            config = new Configuration();
        }
        return config;
    }

    public void start() throws Exception {
        this.config = this.loadConfiguration();
        Hudson.getInstance().getExtensionList(TransientViewActionFactory.class).add(0, (Object)new WallDisplayTransientViewActionFactory());
        super.start();
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException {
        this.config.setTheme(Util.fixEmptyAndTrim((String)formData.optString("theme")));
        this.config.setFontFamily(Util.fixEmptyAndTrim((String)formData.optString("fontFamily")));
        this.config.setBuildRange(Util.fixEmptyAndTrim((String)formData.optString("buildRange")));
        this.config.setJenkinsTimeOut(formData.optInt("jenkinsTimeOut"));
        this.config.setPaintInterval(formData.optInt("paintInterval"));
        this.config.setJenkinsUpdateInterval(formData.optInt("jenkinsUpdateInterval"));
        this.config.setShowLastStableTimeAgo(formData.optBoolean("jenkinsLastStableTimeAgo"));
        this.config.setBlinkBgPicturesWhenBuilding(formData.optBoolean("blinkBgPicturesWhenBuilding"));
        this.config.setShowBuildNumber(formData.optBoolean("jenkinsShowBuildNumber"));
        this.config.setShowDetails(formData.optBoolean("jenkinsShowDetails"));
        this.config.setShowGravatar(formData.optBoolean("jenkinsShowGravatar"));
        this.config.setGravatarUrl(formData.optString("jenkinsGravatarUrl"));
        this.config.setShowDisabledBuilds(formData.optBoolean("jenkinsShowDisabledBuilds"));
        this.config.setSortOrder(Util.fixEmptyAndTrim((String)formData.optString("sortOrder")));
        this.config.setCustomTheme(formData.optString("customTheme"));
        this.config.setShowWeatherReport(formData.optBoolean("jenkinsShowWeatherReport"));
        this.config.setShowJunitResults(formData.optBoolean("jenkinsShowJunitResults"));
        this.config.setMaxQueuePositionToShow(formData.optInt("maxQueuePositionToShow"));
        this.getConfigXml().write((Object)this.config);
    }

    protected XmlFile getConfigXml() {
        return new XmlFile(Hudson.XSTREAM, new File(Hudson.getInstance().getRootDir(), WallDisplayPlugin.class.getName() + ".xml"));
    }
}

